/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;

public class EmAppleII
extends Em6502
implements Runnable {
    public static final int MEM_PHYS_ZP = 0;
    public static final int MEM_PHYS_STACK = 256;
    public static final int MEM_PHYS_RAM1 = 512;
    public static final int MEM_PHYS_TEXT = 1024;
    public static final int MEM_PHYS_RAM2 = 2048;
    public static final int MEM_PHYS_HIRES = 8192;
    public static final int MEM_PHYS_RAM3 = 16384;
    public static final int MEM_PHYS_IO = 49152;
    public static final int MEM_PHYS_ROM_LOW = 53248;
    public static final int MEM_PHYS_ROM_HIGH = 57344;
    public static final int MEM_MAIN_RAM1 = 512;
    public static final int MEM_MAIN_TEXT = 1024;
    public static final int MEM_MAIN_RAM2 = 2048;
    public static final int MEM_MAIN_HIRES = 8192;
    public static final int MEM_MAIN_RAM3 = 16384;
    public static final int MEM_MAIN_LC1 = 49152;
    public static final int MEM_MAIN_LC2 = 53248;
    public static final int MEM_MAIN_LC_HIGH = 57344;
    public static final int MEM_AUX_ZP = 65536;
    public static final int MEM_AUX_STACK = 65792;
    public static final int MEM_AUX_RAM1 = 66048;
    public static final int MEM_AUX_TEXT = 66560;
    public static final int MEM_AUX_RAM2 = 67584;
    public static final int MEM_AUX_HIRES = 73728;
    public static final int MEM_AUX_RAM3 = 81920;
    public static final int MEM_AUX_LC1 = 114688;
    public static final int MEM_AUX_LC2 = 118784;
    public static final int MEM_AUX_LC_HIGH = 122880;
    public static final int MEM_ROM_MAIN_LOW = 131072;
    public static final int MEM_ROM_MAIN_HIGH = 135168;
    public static final int MEM_ROM_INTERNAL = 143360;
    public static final int MEM_ROM_EXTERNAL = 147456;
    public static final int MEM_MAIN_ZP = 151552;
    public static final int MEM_MAIN_STACK = 151808;
    public static final int MEM_WASTE = 152064;
    public static final int MEM_END = 163840;
    public Paddle paddle;
    public Peripheral[] slots;
    public AppleSpeaker speaker;
    public int graphicsMode;
    public boolean[] graphicsDirty = new boolean[512];
    public static final int GR_TEXT = 1;
    public static final int GR_MIXMODE = 2;
    public static final int GR_PAGE2 = 4;
    public static final int GR_HIRES = 8;
    public static final int GR_80STORE = 16;
    public static final int GR_80CHAR = 32;
    public static final int GR_ALTCHAR = 64;
    public static final int GR_DHIRES = 128;
    public static final int SPEAKER_FLIPS_BITS = 12;
    public static final int SPEAKER_FLIPS_SIZE = 4096;
    public static final int SPEAKER_FLIPS_MASK = 4095;
    public int[] speakerFlips = new int[4096];
    public int speakerFlipsPointer = 0;
    private static final int[] defaultRom = new int[]{173, 81, 192, 169, 160, 162, 255, 157, 255, 3, 202, 208, 250, 162, 255, 157, 255, 4, 202, 208, 250, 162, 255, 157, 255, 5, 202, 208, 250, 162, 255, 157, 255, 6, 202, 208, 250, 162, 39, 189, 184, 254, 157, 128, 4, 202, 16, 247, 162, 39, 189, 224, 254, 157, 0, 5, 202, 16, 247, 162, 39, 189, 8, 255, 157, 128, 5, 202, 16, 247, 162, 39, 189, 48, 255, 157, 0, 6, 202, 16, 247, 162, 39, 189, 88, 255, 157, 128, 7, 202, 16, 247, 162, 39, 189, 128, 255, 157, 40, 4, 202, 16, 247, 162, 39, 189, 168, 255, 157, 0, 7, 202, 16, 247, 162, 39, 189, 208, 255, 157, 0, 7, 202, 16, 247, 76, 173, 254, 234, 234, 234, 234, 234, 234, 234, 234, 160, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 160, 160, 32, 32, 32, 32, 32, 32, 32, 32, 1, 16, 16, 12, 5, 9, 9, 7, 15, 32, 18, 5, 17, 21, 9, 18, 5, 19, 32, 1, 14, 32, 32, 32, 32, 32, 32, 32, 32, 32, 160, 160, 32, 32, 32, 32, 32, 32, 1, 16, 16, 12, 5, 32, 9, 9, 32, 18, 15, 13, 32, 9, 13, 1, 7, 5, 32, 20, 15, 32, 18, 21, 14, 32, 32, 32, 32, 32, 32, 32, 160, 160, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 160, 160, 198, 207, 210, 160, 205, 207, 210, 197, 160, 201, 206, 198, 207, 210, 205, 193, 212, 201, 207, 206, 160, 208, 204, 197, 193, 211, 197, 160, 195, 204, 201, 195, 203, 160, 207, 206, 160, 160, 160, 160, 212, 200, 197, 160, 193, 208, 208, 204, 197, 201, 201, 199, 207, 160, 204, 207, 199, 207, 160, 194, 197, 204, 207, 215, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 0, 0, 48, 254, 48, 254, 48, 254};
    private boolean isRestart;
    private int cpuSpeed;
    private int clocksPerInterval;
    private int refreshRate;
    private long refreshInterval;
    private long refreshDelayCumulative;
    private long refreshDelayPerSecond;
    private long refreshCycle;
    private int keyboardLatch;
    private int[] memoryReadOffset = new int[257];
    private int[] memoryWriteOffset = new int[257];
    private boolean isLcReadEnable;
    private boolean isLcWriteEnable;
    private boolean isLcBank2;
    private boolean isRomInternal;
    private boolean isRomC3External;
    private boolean isAuxRead;
    private boolean isAuxWrite;
    private boolean isAuxZeroPage;
    private boolean isVideoVBL;
    private boolean isPaused = true;
    private Thread thread;
    private String threadError = null;
    private boolean isStepMode = false;
    private boolean isNextStep = false;
    private int stepCount;

    public EmAppleII() {
        this.mem = new byte[163840];
        this.initMemoryMap();
        this.setRandomSeed();
        this.setCpuSpeed(1000);
        this.reset();
        this.loadDefaultRom();
        this.paddle = new Paddle(this);
        this.slots = new Peripheral[8];
        for (int i = 1; i < 8; ++i) {
            this.setPeripheral(new Peripheral(), i);
        }
    }

    public void setRandomSeed() {
        this.mem[205] = (byte)System.currentTimeMillis();
    }

    public void loadDefaultRom() {
        for (int i = 0; i < 464; ++i) {
            this.mem[142896 + i] = (byte)defaultRom[i];
        }
    }

    private boolean isValidRom(byte[] byArray, int n) {
        if ((byArray[n + 4096] & 0xFF) == 32) {
            return true;
        }
        return (byArray[n + 4096] & 0xFF) == 76;
    }

    public boolean loadRom(DataInputStream dataInputStream) throws IOException {
        byte[] byArray = new byte[32768];
        int n = 0;
        dataInputStream.readFully(byArray, 0, 32768);
        if (this.isValidRom(byArray, 0)) {
            n = 0;
        } else if (this.isValidRom(byArray, 4096)) {
            n = 4096;
        } else if (this.isValidRom(byArray, 8192)) {
            n = 8192;
        } else {
            return false;
        }
        System.arraycopy(byArray, n, this.mem, 131072, 12288);
        System.arraycopy(byArray, n + 12288, this.mem, 143360, 4096);
        System.arraycopy(byArray, n + 14336, this.mem, 149504, 2048);
        return true;
    }

    public void setPeripheral(Peripheral peripheral, int n) {
        this.slots[n] = peripheral;
        int n2 = 147456 + (n << 8);
        for (int i = 0; i < 256; ++i) {
            this.mem[n2 + i] = (byte)peripheral.memoryRead(i);
        }
    }

    public void setPaused(boolean bl) {
        if (this.isPaused == bl) {
            return;
        }
        this.isPaused = bl;
        if (this.isPaused) {
            try {
                this.thread.join(1000L);
            }
            catch (InterruptedException interruptedException) {}
        } else {
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    public boolean getPaused() {
        return this.isPaused;
    }

    public void setKeyLatch(int n) {
        this.keyboardLatch = (n &= 0x7F) | 0x80;
    }

    public void restart() {
        this.isRestart = true;
        this.assertReset();
    }

    public void reset() {
        this.isRestart = false;
        this.assertReset();
    }

    public void setCpuSpeed(int n) {
        if (n < 0) {
            return;
        }
        this.cpuSpeed = n;
        this.refreshRate = 20;
        this.refreshInterval = (int)(1000.0 / (double)this.refreshRate);
        this.clocksPerInterval = (int)((long)this.cpuSpeed * this.refreshInterval);
    }

    public int getCpuSpeed() {
        return this.cpuSpeed;
    }

    public int getRefreshRate() {
        return this.refreshRate;
    }

    public void setStepMode(boolean bl) {
        this.isNextStep = false;
        this.isStepMode = bl;
    }

    public boolean getStepMode() {
        return this.isStepMode;
    }

    public void stepInstructions(int n) {
        if (n <= 0) {
            return;
        }
        this.stepCount = n;
        this.isNextStep = true;
    }

    private String zeroPad(String string, int n) {
        n -= string.length();
        while (n > 0) {
            string = "0" + string;
            --n;
        }
        return string;
    }

    private String formatHex(int n, int n2) {
        return this.zeroPad(Integer.toString(n, 16), n2);
    }

    private String formatDec(int n, int n2) {
        String string = this.zeroPad(Integer.toString(n), n2 + 1);
        int n3 = string.length();
        return string.substring(0, n3 - n2) + "." + string.substring(n3 - n2, n3);
    }

    public String getStatInfo() {
        String string = "";
        long l = this.isPaused || this.isStepMode ? 0L : (this.refreshDelayPerSecond > 1000L ? (long)(this.cpuSpeed * 1000) / this.refreshDelayPerSecond : (long)this.cpuSpeed);
        string = string + " A=" + this.formatHex(this.A, 2);
        string = string + " X=" + this.formatHex(this.X, 2);
        string = string + " Y=" + this.formatHex(this.Y, 2);
        string = string + " P=" + this.formatHex(this.P, 2);
        string = string + " S=" + this.formatHex(this.S, 2);
        string = string + "\n";
        string = string + " PC=" + this.formatHex(this.PC, 4) + "\n";
        string = string + " [PC]=";
        string = string + " " + this.formatHex(this.memoryRead(this.PC + 0), 2);
        string = string + " " + this.formatHex(this.memoryRead(this.PC + 1), 2);
        string = string + " " + this.formatHex(this.memoryRead(this.PC + 2), 2);
        string = string + " " + this.formatHex(this.memoryRead(this.PC + 3), 2);
        string = string + "\n";
        string = string + " MHZ=" + this.formatDec((int)l, 3) + " [" + this.refreshDelayPerSecond + " ms/s]\n";
        if (this.threadError != null) {
            string = string + this.threadError + "\n";
        }
        return string;
    }

    public int noise() {
        return this.mem[this.clock & 0x3FFF];
    }

    protected int memoryRead(int n) {
        if ((n & 0xFF00) == 49152) {
            return this.ioRead(n);
        }
        return this.mem[n + this.memoryReadOffset[n >> 8]] & 0xFF;
    }

    protected void memoryWrite(int n, int n2) {
        if ((n & 0xFF00) == 49152) {
            this.ioWrite(n, n2);
        } else {
            this.mem[n + this.memoryWriteOffset[n >> 8]] = (byte)n2;
            this.graphicsDirty[n >> 7] = true;
        }
    }

    private void updateMainMemoryMap() {
        int n;
        boolean bl = (this.graphicsMode & 4) != 0;
        boolean bl2 = (this.graphicsMode & 0x10) != 0;
        boolean bl3 = (this.graphicsMode & 8) != 0;
        int n2 = this.isAuxRead ? 65536 : 0;
        int n3 = n2;
        int n4 = n2;
        int n5 = this.isAuxWrite ? 65536 : 0;
        int n6 = n5;
        int n7 = n5;
        if (bl2) {
            n4 = bl ? 65536 : 0;
            n7 = n4;
            if (bl3) {
                n6 = n3 = n4;
            }
        }
        this.memoryReadOffset[2] = this.memoryReadOffset[3] = n2;
        this.memoryWriteOffset[2] = this.memoryWriteOffset[3] = n5;
        this.memoryReadOffset[6] = this.memoryReadOffset[7] = n4;
        this.memoryReadOffset[5] = this.memoryReadOffset[7];
        this.memoryReadOffset[4] = this.memoryReadOffset[7];
        this.memoryWriteOffset[6] = this.memoryWriteOffset[7] = n7;
        this.memoryWriteOffset[5] = this.memoryWriteOffset[7];
        this.memoryWriteOffset[4] = this.memoryWriteOffset[7];
        for (n = 8; n < 32; ++n) {
            this.memoryReadOffset[n] = n2;
            this.memoryWriteOffset[n] = n5;
        }
        for (n = 32; n < 64; ++n) {
            this.memoryReadOffset[n] = n3;
            this.memoryWriteOffset[n] = n6;
        }
        for (n = 64; n < 192; ++n) {
            this.memoryReadOffset[n] = n2;
            this.memoryWriteOffset[n] = n5;
        }
    }

    private void updateIOMemoryMap() {
        int n = this.isRomInternal ? 94208 : 98304;
        for (int i = 193; i < 208; ++i) {
            this.memoryReadOffset[i] = n;
        }
        this.memoryReadOffset[195] = this.isRomC3External ? 98304 : 94208;
    }

    private void initIOMemoryMap() {
        for (int i = 193; i < 208; ++i) {
            this.memoryWriteOffset[i] = 102912;
        }
    }

    private void updateLCMemoryMap() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        if (!this.isLcReadEnable) {
            n5 = 77824;
            n4 = 77824;
        } else if (this.isAuxZeroPage) {
            n5 = this.isLcBank2 ? 65536 : 61440;
            n4 = 65536;
        } else {
            n5 = this.isLcBank2 ? 0 : -4096;
            n4 = 0;
        }
        if (!this.isLcWriteEnable) {
            n3 = 98816;
            n2 = 94720;
        } else if (this.isAuxZeroPage) {
            n3 = this.isLcBank2 ? 65536 : 61440;
            n2 = 65536;
        } else {
            n3 = this.isLcBank2 ? 0 : -4096;
            n2 = 0;
        }
        for (n = 208; n < 224; ++n) {
            this.memoryReadOffset[n] = n5;
            this.memoryWriteOffset[n] = n3;
        }
        for (n = 224; n < 256; ++n) {
            this.memoryReadOffset[n] = n4;
            this.memoryWriteOffset[n] = n2;
        }
    }

    void initMemoryMap() {
        this.initIOMemoryMap();
        this.updateMainMemoryMap();
        this.updateIOMemoryMap();
        this.updateLCMemoryMap();
    }

    private int ioRead(int n) {
        if ((n &= 0xFF) >= 144) {
            return this.slots[(n & 0x70) >> 4].ioRead(n);
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                return this.keyboardLatch;
            }
            case 16: {
                this.keyboardLatch &= 0x7F;
                return this.keyboardLatch;
            }
            case 17: {
                return this.keyboardLatch & 0x7F | (this.isLcBank2 ? 128 : 0);
            }
            case 18: {
                return this.keyboardLatch & 0x7F | (this.isLcReadEnable ? 128 : 0);
            }
            case 19: {
                return this.keyboardLatch & 0x7F | (this.isAuxRead ? 128 : 0);
            }
            case 20: {
                return this.keyboardLatch & 0x7F | (this.isAuxWrite ? 128 : 0);
            }
            case 21: {
                return this.keyboardLatch & 0x7F | (this.isRomInternal ? 128 : 0);
            }
            case 22: {
                return this.keyboardLatch & 0x7F | (this.isAuxZeroPage ? 128 : 0);
            }
            case 23: {
                return this.keyboardLatch & 0x7F | (this.isRomC3External ? 128 : 0);
            }
            case 24: {
                return this.keyboardLatch & 0x7F | ((this.graphicsMode & 0x10) != 0 ? 128 : 0);
            }
            case 25: {
                this.isVideoVBL = !this.isVideoVBL;
                return this.keyboardLatch & 0x7F | (this.isVideoVBL ? 128 : 0);
            }
            case 26: {
                return this.keyboardLatch & 0x7F | ((this.graphicsMode & 1) != 0 ? 128 : 0);
            }
            case 27: {
                return this.keyboardLatch & 0x7F | ((this.graphicsMode & 2) != 0 ? 128 : 0);
            }
            case 28: {
                return this.keyboardLatch & 0x7F | ((this.graphicsMode & 4) != 0 ? 128 : 0);
            }
            case 29: {
                return this.keyboardLatch & 0x7F | ((this.graphicsMode & 8) != 0 ? 128 : 0);
            }
            case 30: {
                return this.keyboardLatch & 0x7F | ((this.graphicsMode & 0x40) != 0 ? 128 : 0);
            }
            case 31: {
                return this.keyboardLatch & 0x7F | ((this.graphicsMode & 0x20) != 0 ? 128 : 0);
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                this.speakerFlips[this.speakerFlipsPointer] = this.clock;
                this.speakerFlipsPointer = this.speakerFlipsPointer + 1 & 0xFFF;
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: {
                break;
            }
            case 80: {
                this.graphicsMode &= 0xFFFFFFFE;
                break;
            }
            case 81: {
                this.graphicsMode |= 1;
                break;
            }
            case 82: {
                this.graphicsMode &= 0xFFFFFFFD;
                break;
            }
            case 83: {
                this.graphicsMode |= 2;
                break;
            }
            case 84: {
                this.graphicsMode &= 0xFFFFFFFB;
                this.updateMainMemoryMap();
                break;
            }
            case 85: {
                this.graphicsMode |= 4;
                this.updateMainMemoryMap();
                break;
            }
            case 86: {
                this.graphicsMode &= 0xFFFFFFF7;
                this.updateMainMemoryMap();
                break;
            }
            case 87: {
                this.graphicsMode |= 8;
                this.updateMainMemoryMap();
                break;
            }
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: {
                break;
            }
            case 94: {
                this.graphicsMode |= 0x80;
                break;
            }
            case 95: {
                this.graphicsMode &= 0xFFFFFF7F;
                break;
            }
            case 96: 
            case 104: {
                return this.paddle.getButtonRegister(3);
            }
            case 97: 
            case 105: {
                return this.paddle.getButtonRegister(0);
            }
            case 98: 
            case 106: {
                return this.paddle.getButtonRegister(1);
            }
            case 99: 
            case 107: {
                return this.paddle.getButtonRegister(2);
            }
            case 100: 
            case 108: {
                return this.paddle.getPaddleRegister(0);
            }
            case 101: 
            case 109: {
                return this.paddle.getPaddleRegister(1);
            }
            case 102: 
            case 110: {
                return this.paddle.getPaddleRegister(2);
            }
            case 103: 
            case 111: {
                return this.paddle.getPaddleRegister(3);
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: {
                this.paddle.triggerRegister();
                break;
            }
            case 128: 
            case 132: {
                this.isLcBank2 = true;
                this.isLcReadEnable = true;
                this.isLcWriteEnable = false;
                this.updateLCMemoryMap();
                break;
            }
            case 129: 
            case 133: {
                this.isLcBank2 = true;
                this.isLcReadEnable = false;
                this.isLcWriteEnable = true;
                this.updateLCMemoryMap();
                break;
            }
            case 130: 
            case 134: {
                this.isLcBank2 = true;
                this.isLcReadEnable = false;
                this.isLcWriteEnable = false;
                this.updateLCMemoryMap();
                break;
            }
            case 131: 
            case 135: {
                this.isLcBank2 = true;
                this.isLcReadEnable = true;
                this.isLcWriteEnable = true;
                this.updateLCMemoryMap();
                break;
            }
            case 136: 
            case 140: {
                this.isLcBank2 = false;
                this.isLcReadEnable = true;
                this.isLcWriteEnable = false;
                this.updateLCMemoryMap();
                break;
            }
            case 137: 
            case 141: {
                this.isLcBank2 = false;
                this.isLcReadEnable = false;
                this.isLcWriteEnable = true;
                this.updateLCMemoryMap();
                break;
            }
            case 138: 
            case 142: {
                this.isLcBank2 = false;
                this.isLcReadEnable = false;
                this.isLcWriteEnable = false;
                this.updateLCMemoryMap();
                break;
            }
            case 139: 
            case 143: {
                this.isLcBank2 = false;
                this.isLcReadEnable = true;
                this.isLcWriteEnable = true;
                this.updateLCMemoryMap();
                break;
            }
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: {
                return this.slots[1].ioRead(n);
            }
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: {
                return this.slots[2].ioRead(n);
            }
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: {
                return this.slots[3].ioRead(n);
            }
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: {
                return this.slots[4].ioRead(n);
            }
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: {
                return this.slots[5].ioRead(n);
            }
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 235: 
            case 236: 
            case 237: 
            case 238: 
            case 239: {
                return this.slots[6].ioRead(n);
            }
            case 240: 
            case 241: 
            case 242: 
            case 243: 
            case 244: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 250: 
            case 251: 
            case 252: 
            case 253: 
            case 254: 
            case 255: {
                return this.slots[7].ioRead(n);
            }
        }
        return this.noise();
    }

    private void ioWrite(int n, int n2) {
        if ((n &= 0xFF) >= 144) {
            this.slots[(n & 0x70) >> 4].ioWrite(n, n2);
            return;
        }
        switch (n) {
            case 0: {
                this.graphicsMode &= 0xFFFFFFEF;
                this.updateMainMemoryMap();
                return;
            }
            case 1: {
                this.graphicsMode |= 0x10;
                this.updateMainMemoryMap();
                return;
            }
            case 2: {
                this.isAuxRead = false;
                this.updateMainMemoryMap();
                return;
            }
            case 3: {
                this.isAuxRead = true;
                this.updateMainMemoryMap();
                return;
            }
            case 4: {
                this.isAuxWrite = false;
                this.updateMainMemoryMap();
                return;
            }
            case 5: {
                this.isAuxWrite = true;
                this.updateMainMemoryMap();
                return;
            }
            case 6: {
                this.isRomInternal = false;
                this.updateIOMemoryMap();
                return;
            }
            case 7: {
                this.isRomInternal = true;
                this.updateIOMemoryMap();
                return;
            }
            case 8: {
                if (this.isAuxZeroPage) {
                    System.arraycopy(this.mem, 0, this.mem, 65536, 512);
                    System.arraycopy(this.mem, 151552, this.mem, 0, 512);
                }
                this.isAuxZeroPage = false;
                this.updateLCMemoryMap();
                return;
            }
            case 9: {
                if (!this.isAuxZeroPage) {
                    System.arraycopy(this.mem, 0, this.mem, 151552, 512);
                    System.arraycopy(this.mem, 65536, this.mem, 0, 512);
                }
                this.isAuxZeroPage = true;
                this.updateLCMemoryMap();
                return;
            }
            case 10: {
                this.isRomC3External = false;
                this.updateIOMemoryMap();
                return;
            }
            case 11: {
                this.isRomC3External = true;
                this.updateIOMemoryMap();
                return;
            }
            case 12: {
                this.graphicsMode &= 0xFFFFFFDF;
                return;
            }
            case 13: {
                this.graphicsMode |= 0x20;
                return;
            }
            case 14: {
                this.graphicsMode &= 0xFFFFFFBF;
                return;
            }
            case 15: {
                this.graphicsMode |= 0x40;
                return;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                this.keyboardLatch &= 0x7F;
                return;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                return;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                this.speakerFlips[this.speakerFlipsPointer] = this.clock;
                this.speakerFlipsPointer = this.speakerFlipsPointer + 1 & 0xFFF;
                return;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: {
                return;
            }
            case 80: {
                this.graphicsMode &= 0xFFFFFFFE;
                return;
            }
            case 81: {
                this.graphicsMode |= 1;
                return;
            }
            case 82: {
                this.graphicsMode &= 0xFFFFFFFD;
                return;
            }
            case 83: {
                this.graphicsMode |= 2;
                return;
            }
            case 84: {
                this.graphicsMode &= 0xFFFFFFFB;
                this.updateMainMemoryMap();
                return;
            }
            case 85: {
                this.graphicsMode |= 4;
                this.updateMainMemoryMap();
                return;
            }
            case 86: {
                this.graphicsMode &= 0xFFFFFFF7;
                this.updateMainMemoryMap();
                return;
            }
            case 87: {
                this.graphicsMode |= 8;
                this.updateMainMemoryMap();
                return;
            }
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: {
                return;
            }
            case 94: {
                this.graphicsMode |= 0x80;
                break;
            }
            case 95: {
                this.graphicsMode &= 0xFFFFFF7F;
                break;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: {
                return;
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: {
                this.paddle.triggerRegister();
                return;
            }
            case 128: 
            case 132: {
                this.isLcBank2 = true;
                this.isLcReadEnable = true;
                this.isLcWriteEnable = false;
                this.updateLCMemoryMap();
                break;
            }
            case 129: 
            case 133: {
                this.isLcBank2 = true;
                this.isLcReadEnable = false;
                this.isLcWriteEnable = true;
                this.updateLCMemoryMap();
                break;
            }
            case 130: 
            case 134: {
                this.isLcBank2 = true;
                this.isLcReadEnable = false;
                this.isLcWriteEnable = false;
                this.updateLCMemoryMap();
                break;
            }
            case 131: 
            case 135: {
                this.isLcBank2 = true;
                this.isLcReadEnable = true;
                this.isLcWriteEnable = true;
                this.updateLCMemoryMap();
                break;
            }
            case 136: 
            case 140: {
                this.isLcBank2 = false;
                this.isLcReadEnable = true;
                this.isLcWriteEnable = false;
                this.updateLCMemoryMap();
                break;
            }
            case 137: 
            case 141: {
                this.isLcBank2 = false;
                this.isLcReadEnable = false;
                this.isLcWriteEnable = true;
                this.updateLCMemoryMap();
                break;
            }
            case 138: 
            case 142: {
                this.isLcBank2 = false;
                this.isLcReadEnable = false;
                this.isLcWriteEnable = false;
                this.updateLCMemoryMap();
                break;
            }
            case 139: 
            case 143: {
                this.isLcBank2 = false;
                this.isLcReadEnable = true;
                this.isLcWriteEnable = true;
                this.updateLCMemoryMap();
            }
        }
    }

    public void run() {
        try {
            while (!this.isPaused) {
                long l = System.currentTimeMillis();
                this.checkInterrupts();
                if (this.isStepMode) {
                    if (this.isNextStep) {
                        this.isNextStep = false;
                        this.executeInstructions(this.stepCount);
                    }
                } else {
                    for (int i = this.clocksPerInterval; i > 0; i -= this.executeInstructions(1 + (i >> 3))) {
                    }
                }
                this.speaker.refreshSpeaker();
                long l2 = System.currentTimeMillis() - l;
                this.refreshDelayCumulative += l2;
                ++this.refreshCycle;
                if (this.refreshCycle >= (long)this.refreshRate) {
                    this.refreshDelayPerSecond = this.refreshDelayCumulative;
                    this.refreshCycle = 0L;
                    this.refreshDelayCumulative = 0L;
                }
                if (l2 >= this.refreshInterval) continue;
                Thread.sleep(this.refreshInterval - l2);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void onReset() {
        int n;
        this.ioWrite(0, 0);
        this.ioWrite(2, 0);
        this.ioWrite(4, 0);
        this.ioWrite(6, 0);
        this.ioWrite(8, 0);
        this.ioWrite(10, 0);
        this.ioWrite(12, 0);
        this.ioWrite(14, 0);
        this.ioWrite(80, 0);
        this.ioWrite(82, 0);
        this.ioWrite(84, 0);
        this.ioWrite(86, 0);
        this.ioWrite(95, 0);
        this.ioWrite(130, 0);
        if (this.isRestart) {
            for (n = 0; n < 131072; ++n) {
                this.mem[n] = 0;
            }
            this.setRandomSeed();
        }
        for (n = 1; n < 8; ++n) {
            this.slots[n].reset();
        }
    }
}

