#
# Makefile for NuLib v3.25.  This makefile is intended for use
# with dmake under GNO/ME.
#
# $Id: makefile.mk,v 1.2 1996/11/28 06:16:33 gdr Exp $
#

# To make a smaller executable, you can exclude the Binary II routines
# by setting DEFINES= -DNO_BLU
# To exclude the UNIX compression routines, add -DNO_UCOMP


# Select appropriate flag... -g for debugging, -O for optimized.
OPTIMIZE	= -G25 -w -v
DEFINES		= -D__GNO__
CFLAGS		= $(DEFINES) $(OPTIMIZE)

LDFLAGS	=
LIBS	= -l ../contrib/src/libc2

HDRS	= nudefs.h nuread.h nuview.h nuadd.h nuext.h nupdel.h nupak.h nuetc.h \
	  nublu.h nucomp.h nucompfn.h
SRCS	= numain.c nuread.c nuview.c nuadd.c nuext.c nupdel.c nupak.c nuetc.c \
	  nublu.c nucomp.c nushk.c nusq.c
OBJS	= numain.o nuread.o nuview.o nuadd.o nuext.o nupdel.o nupak.o nuetc.o \
	  nublu.o nucomp.o nushk.o nusq.o
ARCFILES= README NOTES Makefile make.apw linker.scr linked.scr \
	  mkshk nulib.mak nulib.lnk $(SRCS) $(HDRS)

all:	nulib

nulib: $(OBJS) nulib.r
	@purge
	$(CC) $(CFLAGS) $(OBJS) -o nulib $(LIBS)
	copyfork nulib.r $@ -r

# shar version 3.49
#	-c : add "cut here" line at top
#	-o : base name for output files
#	-l48 : max size is 48KB, but don't split files
#	-v : (not used) turn off verbose msgs
shar:
	shar349 -c -osh.files/nulib -l48 $(ARCFILES)

tar:
	tar cvf nulib.tar $(ARCFILES) nulib.doc

clean:
	rm -f $(OBJS)

clobber: clean
	rm -f nulib

#
# Additional dependancies
#

nuadd.o::	nudefs.h nuread.h nuadd.h nupak.h nuetc.h
nublu.o::	nudefs.h nuview.h nuread.h nuadd.h nupak.h nuetc.h \
                nuext.h nublu.h
nucomp.o::	nudefs.h nuread.h nupak.h nuetc.h nucomp.h nucompfn.h
nuetc.o::	nudefs.h nuetc.h
nuext.o::	nudefs.h nuread.h nuext.h nupak.h nuetc.h
numain.o::	nudefs.h nuread.h nuview.h nuadd.h nuext.h nupdel.h \
                nublu.h nupak.h nuetc.h
nupak.o::	nudefs.h nuread.h nucomp.h nucompfn.h nupak.h nuetc.h
nupdel.o::	nudefs.h nuread.h nuadd.h nupak.h nupdel.h nuetc.h
nuread.o::	nudefs.h crc.h nuread.h nupak.h nuetc.h
nushk.o::	nudefs.h nuread.h nupak.h nuetc.h
nusq.o::		nudefs.h nuetc.h nuread.h nupak.h
nuview.o::	nudefs.h nuview.h nuread.h nuetc.h
