/*
 * nuadd.h - declarations for nuadd.c
 *
 * NuLib v3.2  March 1992  Freeware (distribute, don't sell)
 * By Andy McFadden (fadden@netcom.com)
 *
 * $Id: nuadd.h,v 1.3 1996/11/03 23:01:02 gdr Exp $
 */

/* information is copied from file-dependent structures (FileRec) to here */
typedef struct file_info {
    char *pathname;	 /* as much of the path as we need to know */
    char *store_name;  /* what name the file will be stored under */
    fourbyt eof;  /* length of file */
    fourbyt fAccess;  /* was Word */
    fourbyt fileType;  /* was Word */
    fourbyt auxType;
    twobyt storageType;
    Time create_dt;  /* Time = TimeRec = 8 bytes in misctool.h/nuread.h */
    Time mod_dt;
    twobyt fileSysID;  /* these two are non-standard */
    onebyt fileSysInfo;
    int marked;  /* application specific */
} file_info, *file_info_ptr;

typedef struct fileInfoArrayElem {
  file_info_ptr *vec;
  int alloced;
  int used;
} fileInfoArrayElem, *fileInfoArray;

typedef struct stringArrayElem {
  char **vec;
  int alloced;
  int used;
} stringArrayElem, *stringArray;

/* #define MAXARGS 255  *//* max #of files specified on command line; signed int */

extern void NuAdd __P((char *filename, int namecount, char **names, 
		       char *options));
extern long AddFile __P((int arcfd, file_info *infoptr));
extern onebyt *MakeMHblock __P((ListHdr *archive, fourbyt total_records, 
				fourbyt master_eof));
extern int EvalArgs __P((int count, char **names, fileInfoArray FIArray,
			 BOOLEAN first));
extern int OptNum __P((char *ptr));

extern void addToFileArray __P((fileInfoArray array, file_info_ptr entry));
extern void addToStringArray __P((stringArray array, char *entry));
extern fileInfoArray newFileArray __P((void));
extern stringArray newStringArray __P((void));
extern void clearStringArray __P((stringArray array));
extern void *xmalloc __P((size_t));
extern void *xrealloc __P((void *, size_t));
extern char *xstrdup __P((const char *str));
