/*
 * nucompfn.h - function declarations for nucomp.c
 *
 * NuLib v3.2  March 1992  Freeware (distribute, don't sell)
 * By Andy McFadden (fadden@netcom.com)
 *
 * $Id: nucompfn.h,v 1.3 1996/11/03 23:01:03 gdr Exp $
 */

/*
 *  COMPRESS.FNS  global function declarations
 *  this should be compatible with any type of declaration for external
 *  functions. See compress.h for explaination
 */

extern CODE getcode __P((void));
extern char *get_program_name __P((char *));
extern char *name_index __P((char *));
extern int  alloc_tables __P((CODE maxcode, HASH hashsize));
extern int  check_error __P((void));
extern int  cl_block __P((void));
extern int  is_z_name __P((char *));
extern int  make_z_name __P((char *));
extern int  nextcode __P((CODE *codeptr));
extern int  u_compress __P((int srcfd, int dstfd, long thread_eof));
extern int  u_decompress __P((int srcfd, int dstfd, long comp_thread_eof));
extern void Usage __P((char *));
extern void compress __P((long thread_eof));
extern void copystat __P((char *, char *));
extern void decompress __P((void));
extern void init_tables __P((void));
extern void prratio __P((FILE *stream, long int num, long int den));
extern void putcode __P((CODE code, int bits));
extern void unmake_z_name __P((char *));
extern void version __P((void));
extern void writeerr __P((void));

#ifdef NO_STRCHR
extern char *strchr __P((const char *, int));
#endif

#ifdef NO_STRRCHR
extern char *strrchr __P((const char *, int));
#endif

#ifdef NO_REVSEARCH
extern char *strrpbrk __P((const char *, const char *));
#endif

#ifndef NOSIGNAL
extern int foreground __P((void));
extern SIGTYPE onintr __P((void));
extern SIGTYPE oops __P((void));
#endif

#ifdef NEARHEAP
extern ALLOCTYPE *emalloc __P((unsigned int x, int y));
extern void efree __P((ALLOCTYPE *ptr));
#else
extern ALLOCTYPE FAR *emalloc __P((unsigned int x, int y));
extern void efree __P((ALLOCTYPE FAR *ptr));
#endif
