/*
 * nudefs.h - system-dependent typdefs, and global #defines and variables.
 *
 * NuLib v3.2  March 1992  Freeware (distribute, don't sell)
 * By Andy McFadden (fadden@netcom.com)
 *
 * IMPORTANT: This file must be first on the list of #includes, since some
 *	      include files will be processed based on these #defines
 *
 * $Id: nudefs.h,v 1.6 1996/11/28 07:48:28 gdr Exp $
 */

#if defined(__GNUC__) || defined(__LCC__)
#define __lint 1
#endif

#ifndef __P
#ifdef  __STDC__
#define __P(proto) proto
#else
#define __P(proto) ()
#endif
#endif

/* SYSTEM DEPENDENCIES */
typedef unsigned char onebyt;
typedef unsigned short twobyt;
typedef unsigned long fourbyt;

/*
 * Setup for Apple //gs compiling with APW or Orca/C
 * See also __GNO__, below. 
 */
#if defined(APW) || defined(__ORCAC__)
#define __appleiigs__
#pragma lint  -1
#pragma memorymodel 1
#pragma optimize 7
/* pragma debug 25 */

/* Setup for Apple //gs compiling with lcc. See also __GNO__, below. */
#elif defined(__appleiigs__) && defined(__LCC__)

/* Setup for HAL Sparc-64 (Solaris compatible) */
#elif defined(sparc) && defined(hal)
#define UNIX
#define SYSV
#define __lint
#define _POSIX_SOURCE
#define HAS_DIRENT

/* Setup for SunPro C and Solaris 2.5.1 */
#elif defined(__SUNPRO_C) && defined(__SunOS_5_5_1)
#define UNIX
#define SYSV
#define _POSIX_SOURCE
#define HAS_DIRENT
#define __EXTENSIONS__

/* Setup for SunPro C and Solaris 2.4 */
#elif defined(__SUNPRO_C) && defined(__SunOS_5_4)
#define UNIX
#define SYSV
#define _POSIX_SOURCE
#define HAS_DIRENT

#elif defined(__sun__) && defined(__GNUC__)
#define UNIX
#define HAS_DIRENT
#ifdef __SVR4
#define SYSV            /* Solaris with gcc */
#define _POSIX_SOURCE
#else 
#define SUNOS4          /* SunOS 4.x with gcc */
#endif

/* Setup for SunOS 4.1.3 with /usr/5bin/cc */
#elif defined(sun) && defined(sparc) && !defined(__GNUC__)
#define UNIX
#define BSD43
#define const           /* "const" not understood */
#define SUNOS4
#undef  HAS_DIRENT

/* Setup for HPUX with cc and gcc */
#elif defined(__hpux)
#define UNIX
#define SYSV
#define HAS_DIRENT
#ifndef __STDC__
#define const           /* HPUX cc not ANSI by default */
#endif
#ifdef __GNUC__
#define _POSIX_SOURCE
#endif

/* Setup for Linux */
#elif defined(__linux__)
#define UNIX
#define SYSV
#define HAS_DIRENT

/* Setup for AIX */
#elif defined(_AIX)
#define UNIX
#define SYSV
#define BSD_INCLUDES
#define _ALL_SOURCE
#define HAS_DIRENT
 
/* Setup for BSD 4.4 systems (BSDI, NetBSD, FreeBSD, and OpenBSD) */
#elif defined(__bsdi__) || defined(__NetBSD__) || defined(__FreeBSD__) || defined(__OpenBSD__)
#define UNIX
#define BSD43
#define HAS_UTIMBUF
#undef  HAS_DIRENT
#undef __P
#include <sys/cdefs.h>  /* to get __P definition */

#else
%%%% unknown architecture %%%%
#endif

#ifdef __GNO__
#define UNIX
#define BSD43
#define HAS_DIRENT
#endif   

/* Setup for MS-DOS machines (80xxx based: IBM PC) */
/* #ifndef MSDOS */
/* #define MSDOS */
/* #endif */

/* Setup for BSD UNIX systems */
/*#define UNIX*/
/*#define BSD43*/

/* Setup for the NeXT */
/* #define UNIX */
/* #define BSD43 */
/* #define NeXT */		/* (is this defined automatically?) */

/* Setup for XENIX/386 */
/* NOTE: if you get error messages about readdir() and opendir() during */
/*	 linking, remove the leading '#' from the line "#CLIBS= -lx" in */
/*	 "Makefile"							*/
/* #define XENIX386 */
/* #define UNIX */
/* #define SYSV */
/* #define NO_RENAME */		/* no rename() call in C library */

/* Setup for Amdahl UTS 2.1; also works on the AT&T 3B2 */
/* #define UNIX */
/* #define SYSV */
/* #define NO_RENAME */
/* (UTS only:) */
/* #define HAS_EFT */ /*(don't forget to add "-eft" flag in Makefile for UTS 2.1)*/

/* Setup for AOS/VS @ DG */
/* #define UNIX */
/* #define DATAGENERAL */
/* #define AOSVS */

/* Setup for AViiONs */
/* #define UNIX */
/* #define SYSV */
/* #define HAS_EFT */

/* Setup for other UNIX systems */
/* #define UNIX */
/* #define SYSV (or whatever) */

/* use table lookups to get CRCs */
#define CRC_TAB

/* don't include Binary II */
/* #define NO_BLU */

/* don't include UNIX compress */
/* #define NO_UCOMP */

#ifndef SEGMENT_NAME
%%% unspecified segment %%%
#endif

#ifdef __ORCAC__
segment SEGMENT_NAME;
#elif defined(APW)
segment SEGMENT_NAME
#elif defined(__appleiigs__) && defined(__LCC__)
#pragma segment SEGMENT_NAME
#endif

#ifdef __ORCAC__
extern int _mapErr(int);

#define TOOL_CHECK(action, file, isFatal) \
{ \
  if (_toolErr) { \
    fprintf(stderr, "couldn't %s %s: %s\n", action, file, \
	    strerror(_mapErr(_toolErr))); \
    if (isFatal) { \
      QuitNulib(1); \
    } \
  } \
}
#endif

#ifdef UNIX
/* (the #include setup for NuLib is pretty screwed up at this point...) */
# include <sys/types.h>		/* need off_t, if it exists */

/*
 * With EFT, off_t is a longlong (8 bytes) and mode_t is four bytes (ulong).
 * They affect lseek() and open() calls.  Without EFT, off_t is usually
 * four bytes, and mode_t is a short or an int.
 *
 * I'm not sure which systems don't have off_t or mode_t.  BSD seems to have
 * off_t, but not mode_t; this'll have to be handled on a case-by-case basis.
 * Unfortunately #ifdefs don't pick up typedefs on all compilers...
 */
# ifndef HAS_EFT
/*typedef long off_t;*/
/*typedef unsigned short mode_t;*/
# endif

#else
# ifndef HAS_EFT
/* APW and MS-DOS should be the same */
typedef long off_t;
typedef unsigned int mode_t;
# endif
#endif

#if !defined(UNIX) && !defined(__ORCAC__)
/* VERY important if lseek() doesn't return int */
extern off_t lseek __P((int, off_t, int));
#endif

/*
 * Define this if you want the file sizes to be printed.
 */
#define SHOW_DATA_SIZE

/*
 * The rest of this stuff shouldn't need to be changed
 */

/*
 * Some global defs
 */

/* errno wasn't defined in <errno.h> on some systems... */
#ifndef MSDOS
extern int errno;
#endif

/* Maximum file name length that we intend to handle (watch stack size!) */
#define MAXFILENAME	   1024

/* file operations */
#define S_ABS	0  /* seek absolute */
#define S_REL	1  /* seek relative */
#define S_END	2  /* seek from end */

#ifdef UNIX	      /* stuff for open() */
# ifdef __GNO__
#  define WPERMS 0644	/* read/write for owner, read only for others */
# else
#  define WPERMS 0644	/* read/write for owner, read only for others */
#  define O_BINARY 0    /* for non-UNIX open(); easier than #ifdefs */
# endif
# define FREAD_STR	"r"
# define FWRITE_STR	"w"
#else
# ifdef APW
#  define WPERMS 0666	 /* read/write for all; this may not work for some */
#  define FREAD_STR	"rb"
#  define FWRITE_STR	"wb"
# endif
# ifdef MSDOS
#  define S_IREAD     0000400         /* read permission, owner */
#  define S_IWRITE    0000200         /* write permission, owner */
#  define WPERMS S_IREAD | S_IWRITE
#  define FREAD_STR	"rb"
#  define FWRITE_STR	"wb"
# endif
# ifndef WPERMS /* other system */
#  define WPERMS 0666  /* +PORT+ */
#  define FREAD_STR	"rb"
#  define FWRITE_STR	"wb"
# endif
#endif /*UNIX*/

/* Time structure; same as TimeRec from misctool.h */


/* one-byte entries should not have alignment problems... */
typedef struct {
    onebyt second;
    onebyt minute;
    onebyt hour;
    onebyt year;
    onebyt day;
    onebyt month;
    onebyt extra;
    onebyt weekDay;
} Time;


/*
 * global to entire program
 */

/* byte ordering; TRUE if high byte is first (68xxx), else FALSE (65xxx) */
extern int HiLo;        /* actually part of numain.c */

extern int verbose;	/* BOOLEAN: print verbose? */
extern int interact;	/* BOOLEAN: interactive when overwriting? */
extern int dopack;	/* BOOLEAN: do we want to pack/unpack? */
extern int doSubdir;	/* BOOLEAN: expand subdirectories? */
extern int doExpand;	/* BOOLEAN: expand archived filenames? */
extern int doMessages;	/* BOOLEAN: do comments instead of data? */
extern int transfrom;	/* how to do CR<->LF translation?  (-1 = none) */
extern int transto;
extern int packMethod;	/* how to pack a file (thread_format) */
extern int diskData;	/* BOOLEAN: store files as disk images */
extern fourbyt defFileType;	/* default file type */
extern fourbyt defAuxType;	/* default aux type */
extern onebyt *pakbuf;	/* used by compression routines; created once to */
              /* eliminate overhead involved in malloc()ing a 64K buffer */
extern char *prgName;	/* for errors; don't like argv[0] */

/* define these if they haven't been already */
/* (typedef int BOOLEAN caused too many problems... #define is easier) */
#ifdef __ORCAC__
# ifndef __TYPES__
#  include <types.h>
# endif
#elif !defined(BOOLEAN)
# define BOOLEAN int
#endif

#ifndef TRUE
# define TRUE	 1
# define FALSE	 0
#endif
