/*
 * nuetc.h - declarations for nuetc.c
 *
 * NuLib v3.2  March 1992  Freeware (distribute, don't sell)
 * By Andy McFadden (fadden@netcom.com)
 *
 * (this will be included by almost all source files; it should come last)
 *
 * $Id: nuetc.h,v 1.4 1996/11/28 06:16:34 gdr Exp $
 */

/* define these if they haven't been already */
/* (typedef int BOOLEAN caused too many problems... #define is easier) */
#if 0 /* should only be nudefs.h */
#ifndef BOOLEAN
# define BOOLEAN int
#endif
#endif

#ifndef TRUE
# define TRUE	 1
# define FALSE	 0
#endif

#ifdef UNIX
# ifdef BSD43
#  ifndef NeXT
   extern char *index __P((const char *, int));    /* BSD version */
   extern char *rindex __P((const char *, int));
#  endif
#  define INDEX(s, c)  index(s, c)
#  define RINDEX(s, c) rindex(s, c)
# else
   extern char *strchr __P((const char *, int));   /* AT&T version */
   extern char *strrchr __P((const char *, int));
#  define INDEX(s, c)  strchr(s, c)
#  define RINDEX(s, c) strrchr(s, c)
# endif
#else
  extern char *strchr __P((const char *, int));    /* APW, MSC */
  extern char *strrchr __P((const char *, int));
# define INDEX(s, c)  strchr(s, c)
# define RINDEX(s, c) strrchr(s, c)
#endif

extern char tmpNameBuf[];

/* external function declarations */
extern void Fatal __P((char *, char *));
extern void QuitNulib __P((int));
extern char *Malloc __P((size_t));

extern long timecvt __P((Time *));

#ifdef APW
extern void ToolErrChk __((void));
extern void perror __P((const char *));
#endif

extern int strcasecmp __P((const char *, const char *));
extern int strncasecmp __P((const char *, const char *, size_t));

extern void ArcfiCreate __P((char *));
extern void Rename __P((char *, char *));
extern BOOLEAN Exists __P((char *));
extern char *MakeTemp __P((char *));

extern void ExpandTime __P((void *, Time *));
extern long ReduceTime __P((Time *));
extern Time *GetTime __P((void));

#ifdef __ORCAC__
# ifndef __TYPES__
# include <types.h>
# endif

# ifdef __GNO__
#   define STOP_KEY() 0
# else
#   define STOP_KEY() keyboardStop()
#   define unlink(name) remove(name)
    extern int keyboardStop(void);
# endif

extern GSString255Ptr __C2GSMALLOC(char *);
#endif
