/*
 * nupak.h - declarations for nupak.c
 *
 * NuLib v3.2  March 1992  Freeware (distribute, don't sell)
 * By Andy McFadden (fadden@netcom.com)
 *
 * This has function declarations for all of the pack routines; that way we
 *   don't have to include .h files for all of the pack code.
 *
 * $Id: nupak.h,v 1.3 1996/11/03 23:01:05 gdr Exp $
 */

/* Pack/unpack buffer size; should be as big as read() & malloc() can take */
/* Note: must be AT LEAST 8200 bytes or things may break */
/*       Bad things could happen if it's less than 12K   */
#define PAKBUFSIZ   0xff80

extern long packedSize;
extern onebyt lastseen;

extern int UnpackFile __P((int, int, THblock *, int, onebyt *));
extern unsigned int crlf __P((int dstfd, onebyt *buffer, unsigned int length));
extern void Spin __P((void));
extern void FCopy __P((int, int, fourbyt, onebyt *, BOOLEAN));
extern twobyt PackFile __P((int, int, fourbyt, int, onebyt *));

/* pack P8 ShrinkIt format, in nushk.c */
extern long pak_SHK __P((int srcfd, int dstfd, long length, onebyt *copybuf));

extern void unpak_SQU __P((int srcfd, int dstfd, long length));

/* unShrink, in nushk.c */
extern void unpak_SHK __P((int srcfd, int dstfd, fourbyt comp_thread_eof,
			   fourbyt thread_eof, register onebyt *buffer, 
			   BOOLEAN use_type2, twobyt thread_crc));

