>      Are the tool locater, memory manager, and miscellaneous toolsets
> ROM-based?  That is, do I have to worry about people booting ProDOS 8
> on the Apple IIGS from a floppy disk?

Yes, they are ROM based.

There is a big catch: you can't make a MMStartUp call if the area of
memory you are running from hasn't been allocated (as happens if you
boot directly into ProDOS-8).

To get around this, you should start up the toolbox using the
following code:

        clc
        xce
        rep     #$30            ; Get into 16-bit native mode
        stz     NewID           ; I haven't created a new user ID
        _TLStartUp
        pha
        _MMStartUp
        pla
        bcc     MM_OK           ; This is probably a bad branch.  :-)
* If the Memory Manager reported an error, we need to allocate our own
* memory first.
        _MTStartUp
* First we need a user ID.
        pha
        pea     $1000
        _GetNewID               ; Get me a new user ID (Application)
        pla
        sta     NewID           ; Save it for later
* Now give me all of bank zero and bank one.
        pha
        pha                     ; Result space
        pea     $0000
        pea     $B800           ; Block size
        lda     NewID
        pha                     ; User ID
        pea     $C002           ; Attributes: locked, fixed, absolute
        pea     $0000
        pea     $0800           ; Location (bank 0, $0800-$BFFF)
        _NewHandle
        plx
        ply
        bcs     HelpMe          ; This shouldn't happen!
        sty     Bnk0Hnd
        stx     Bnk0Hnd+2       ; Save handle to bank 0 memory
        pha
        pha                     ; Result space
        pea     $0000
        pea     $B800           ; Block size
        lda     NewID
        pha                     ; User ID
        pea     $C002           ; Attributes: locked, fixed, absolute
        pea     $0001
        pea     $0800           ; Location (bank 1, $0800-$BFFF)
        _NewHandle
        plx
        ply
        bcs     HelpMe          ; This shouldn't happen!
        sty     Bnk1Hnd
        stx     Bnk1Hnd+2       ; Save handle to bank 0 memory
* We have the necessary memory protected.  Start up the memory manager again.
        pha
        _MMStartup
        pla
        bcs     HelpMe          ; This shouldn't happen!
MM_OK   sta     MyID            ; Save the memory ID


You can now use NewHandle to allocate a buffer of the necessary size,
using attributes of "locked, fixed, purge=0, no special memory"
($C008).  You can allocate a single handle, say 32k, then use it as
two separate buffers of 16k each.  Don't forget to de-reference the
handle before using it as a pointer!

A note regarding the above code: if you had to use the special code to
create the user ID and allocate the two handles, then you should
probably free them again on exit:

* Free the serial buffer handle first, after restoring the original
* buffer pointers.
        lda     NewID           ; Did we allocate our own memory?
        beq     No_ID
        lda     Bnk1Hnd+2       ; Yes, so free it.
        pha
        lda     Bnk1Hnd
        pha
        _DisposeHandle
        lda     Bnk0Hnd+2
        pha
        lda     Bnk0Hnd
        pha
        _DisposeHandle
        lda     NewID
        pha
        _DeleteID               ; and get rid of the user ID
No_ID   _MTShutDown
        _MMShutDown
        _TLShutDown
        sec
        xce

Also note that all of this code is in 16-bit native mode.  Any
immediate operands of A and X are 16 bits, and any referenced
variables are two bytes (four bytes for the handles).

-- 
David Empson                                                               
dempson@swell.actrix.gen.nz                                                
Snail mail: P.O. Box 27-103, Wellington, New Zealand 
