On the "card" built in to the GS, there are several routines.
To find out entry point of the Init routine, get the byte at $Cn0D
and then jump to $Cnxx, where xx is the byte you find in $Cn0D.
(and n is the slot number of the card).

offset addr   routine  Entry   x   y   a     Exit  x  y  a 
$Cn0D          Init           $Cn $n0  ?          Err ?  ?
$Cn0E          Read           $Cn $n0  ?          Err ?  Char
$Cn0F          Write          $Cn $n0  Char       Err ?  ?
$Cn10          Status         $Cn $n0  Request    Err ?  ?
 On entry to Status, Request (A) can be:
    0=Are you ready to accept output?
    1=Do you have input ready?
 On exit, the carry will be the answer:
    0=No, 1=Yes.

There are also extended commands, but I don't have time to go into that..
Basically, you want something like this:

     lda $C20D
     sta init_it+1
     lda $c20E
     sta read_it+1
     lda $C20F
     sta write_it+1
     ...

main   jsr init

loop   lda  #"A"
       jsr write
       lda  #"T"
       jsr write
       lda #$8d
       jsr write  ; print "AT ^M"
        ...


* subroutines
init     ldy #$20
         ldx #$C2
init_it  jmp $C200 ;the 00 is to be filled in
         rts

read     ldy #$20
         ldx #$C2
read_it  jmp $C200 ; filled in
         rts ; char in A

write    ldy #$20
         ...


Of course, instead of ldy #$20, you would want LDY #SLOT*16 or LDY SLOTSTORE1.
That way, you can easily re-assemble for a different slot.  The last way, you
could have it search for the slot at run-time. 
You will probably want to call status before the read so it doesn't hang
waiting for a char.  (you could call status w/A=1, then return if carry was
clear.  The main program would have to check the carry before checking the
contents of A, or else it will be garbage. Be sure and set the carry if a
char is successfuly read.)

The Error codes are as follows: 00=no err, 01=illegal command used,
02= bad parameter count.  I think the last one is only for extended commands,
which I haven't told you about.  In general, I'd ignore the error code.
If you REALLY wanted full native (65816) mode, you could go through the
toolbox, but I don't think you will gain much.

One more thing: the firmware is just like the dumb terminal mode: You can
send it commands with the CTRL-I char.  For example, "^I10B" for 2400 baud.
if you don't want it eating your ^I's, just send a "^IZ" for Zap. The tricky
part is that if you re-init the port, you will have to send the zap command
again. 

This is all taken from the GS firmware refrence.
