device.c
/* Copyright (C) 1985 by Manx Software Systems, Inc. */

#include	<sgtty.h>
#include	<device.h>
#define BASE (char *)0x212 /*jd 6/25/86...ProDOS close writes on 0x210-211 */

static char maptab[96] = {
	0x40,0x7b,0x02,0x7f,0x04,0x7c,0x06,0x07,
	0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x7e,0x0f,
	0x60,0x1b,0x7d,0x13,0x14,0x09,0x16,0x17,
	0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x5e,0x1f,
	0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,
	0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,
	0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,
	0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
	0x70,0x61,0x62,0x63,0x64,0x65,0x66,0x67,
	0x68,0x69,0x6a,0x6b,0x6c,0x6d,0x6e,0x6f,
	0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,
	0x78,0x79,0x7a,0x7b,0x7c,0x6d,0x6e,0x7f };


_kb_get(buf, cnt)
char *buf;
{
	static char *endp = BASE;
	static char needmore;
	register unsigned char c;
	register unsigned short flags;

	flags = _dev_info->tty.sg_flags;
	if (endp == BASE || needmore) {
		for (;;) {
			if ((c = _cget((flags&NODELAY)!=0)) < 0) {
				needmore = 1;
				return(0);
			}
			*endp++ = c;
			if (flags&RAW)
				break;
			if ((flags & CRMOD) && c == '\r') {
				c = '\n';
				*(endp-1) = '\n';
			}
			if (_dev_info->con_flags&CON_IMAP) {
				if (c < 0x60)
					c = maptab[c];
				if (c >= 0x60 && (*(char *)0xc063&0x80) == 0x00)
					c ^= 0x20;
				*(endp-1) = c;
			}
			if (flags&ECHO)
				if (c == 0x15) {
					--endp;
					continue;
				} else
					chput(c);
			if (flags&CBREAK)
				break;
			if (c == 0x04 && endp == BASE+1) { /* ^D */
				endp = BASE;
				break;
			}
			if (c == 3) /* ^C */
				_exit(2);
			if (c == _dev_info->tty.sg_erase) {
				if (--endp > BASE)
					endp--;
				if (flags&ECHOE) {
					if (c == 0x08)
						_kb_put(" \x8", 2);
					else {
						_kb_put("\x8 \x8", 3);
						if (c >= ' ')
							_kb_put("\x8 \x8", 3);
					}
				}
			}
			if (c == _dev_info->tty.sg_kill) {
				chput('\n');
				endp = BASE;
			}
			if (c == '\n')
				break;
		}
	}
	if ((endp-BASE) < cnt)
		cnt = endp - BASE;
	movmem(BASE, buf, cnt);
	endp -= cnt;
	movmem(BASE+cnt, BASE, endp-BASE);
	needmore = 0;
	return(cnt);
}

#asm
	instxt	<zpage.h>

_cget_
	stx	R0+1
	ldy	#2
	lda	(SP),Y
	beq	x1
	lda	$c000
	bmi	x1
	lda	#$ff
	sta	R0+1
	bne	x2
x1
	jsr	$fd0c
	and	#$7f
x2
	sta	R0
	rts
#endasm

_kb_put(buf, cnt)
char *buf;
{
	register unsigned short i;

	for (i=0;i<cnt;i++)
		chput(*buf++);
	return(cnt);
}

static unsigned char pos;

#define	WNDWDTH	(*(char *)0x21)
#define	WNDTOP	(*(char *)0x22)
#define	WNDBTM	(*(char *)0x23)
#define	CH		(*(char *)0x24)
#define	CV		(*(char *)0x25)
#define	CH80	(*(char *)0x57b)
#define	VTAB	(*((void (*)())0xfc22))
#define	CLREOP	(*((void (*)())0xfc42))
#define	HOME	(*((void (*)())0xfc58))
#define	CLREOL	(*((void (*)())0xfc9c))

static
chput(c)
{
	register unsigned short flags, end;
	static char escflg;

	flags = _dev_info->tty.sg_flags;
	if (escflg == 0) {
		if (c == '\t' && (flags&XTABS)) {
			end = 0;
			while (pos >= end)
				end += flags & TABSIZ;
			end -= pos;
			while (end--) {
				_cput(' ');
				pos++;
			}
			return;
		}
		if ((c == '\n' || c == '\r') && (flags&CRMOD)) {
			_cput('\r');
			pos = 0;
			return;
		}
	}
#ifndef NOCURS
	if (escflg == 1 && c == 0x3d) {
		escflg = 2;
		return;
	}
	if (escflg == 2) {
		pos = c - 0x20;
		escflg = 3;
		return;
	}
	if (WNDWDTH <= 40) {
		if (escflg == 3) {
			CV = pos;
			CH = pos = c - 0x20;
			VTAB();
			escflg = 0;
			return;
		}
		if (escflg) {
			switch(c) {
			case 0x45:			/* insert blank line at cursor		*/
				WNDTOP = CV;
				_rscrl();
				WNDTOP = 0;
				break;
			case 0x51:			/* insert blank character at cursor	*/
				break;
			case 0x52:			/* delete line at cursor			*/
				WNDTOP = CV;
				CV = WNDBTM - 1;
				VTAB();
				_cput(0x0a);
				CV = WNDTOP;
				WNDTOP = 0;
				VTAB();
				break;
			case 0x54:			/* clear to end of line from cursor	*/
				CLREOL();
				break;
			case 0x57:			/* delete character at cursor		*/
				break;
			case 0x59:			/* clear to end of screen from curs	*/
				CLREOP();
				break;
			}
			escflg = 0;
			return;
		}
		switch(c) {
		case 0x0b:			/* cursor up		*/
			if (CV > 0)
				CV -= 1;
			VTAB();
			return;
		case 0x0c:			/* cursor right		*/
			if (++CH >= WNDWDTH) {
				if (CV >= WNDBTM-1)
					_cput(0x0a);
				else
					CV++;
				CH = 0;
			}
			VTAB();
			pos++;
			return;
		case 0x0d:			/* begin of line	*/
			CH = pos = 0;
			VTAB();
			return;
		case 0x1a:			/* home and clear	*/
			HOME();
			pos = 0;
			break;
		case 0x1e:			/* home				*/
			CH = CV = pos = 0;
			VTAB();
			break;
		}
	}
	else {
		if (escflg == 3) {
			CV = pos;
			CH80 = pos = c - 0x20;
			VTAB();
			escflg = 0;
			return;
		}
		if (escflg) {
			switch(c) {
			case 0x45:			/* insert blank line at cursor		*/
				WNDTOP = CV;
				_cput(0x16);
				WNDTOP = 0;
				break;
			case 0x51:			/* insert blank character at cursor	*/
				break;
			case 0x52:			/* delete line at cursor			*/
				WNDTOP = CV;
				_cput(0x17);
				WNDTOP = 0;
				break;
			case 0x54:			/* clear to end of line from cursor	*/
				_cput(0x1d);
				break;
			case 0x57:			/* delete character at cursor		*/
				break;
			case 0x59:			/* clear to end of screen from curs	*/
				_cput(0x0b);
				break;
			}
			escflg = 0;
			return;
		}
		switch(c) {
		case 0x0b:			/* cursor up		*/
			if (CV > 0)
				CV -= 1;
			VTAB();
			return;
		case 0x0c:			/* cursor right		*/
			c = 0x1c;
			pos++;
			break;
		case 0x0d:			/* begin of line	*/
			CH80 = pos = 0;
			VTAB();
			return;
		case 0x1a:			/* home and clear	*/
			pos = 0;
			c = 0x0c;
			break;
		case 0x1e:			/* home				*/
			pos = 0;
			c = 0x19;
			break;
		}
	}
	switch(c) {
	case 0x08:			/* cursor left		*/
		pos--;
		break;
	case 0x1b:
		escflg = 1;
		return;
	default:
		if (c >= 0x20)
			pos++;
		break;
	}
#endif
	_cput(c);
}

#asm
CON_FLAGS	equ	14
TTY_FLAGS	equ	16

_cput_
	lda	_dev_info_
	sta	R0
	lda	_dev_info_+1
	sta	R0+1
	ldy	#CON_FLAGS		;get console flags
	lda	(R0),Y
	and	#$80			;isolate HIGH flag bit
	ldy	#2
	ora	(SP),Y			;get character to output
	jsr	$fded			;send it
	ldy	#TTY_FLAGS+1	;get tty flag high byte
	lda	(R0),Y
	and	#4				;check for raw mode
	bne	skip			;yes, don't detect ^C
	lda	$c000			;get kbd char
	cmp	#$83			;is it ^C
	bne	skip			;no, skip
	ldx	$c010			;clear kbd strobe
	ldy	#2
	sta	(SP),Y			;do _exit(0x83)
	lda	#0
	iny
	sta	(SP),Y
	jsr	_exit_#
skip
	rts

WNDLFT	equ	$20
WNDWTH	equ	$21
WNDTOP	equ	$22
WNDBTM	equ	$23
CH		equ	$24		;cursor horizontal memory location
CV		equ	$25		;cursor vertical memory lockation
BASL	equ	$28		;pointer to beginning of line
BASH	equ	$29
BAS2L	equ	$2a
BAS2H	equ	$2b
VTAB	equ	$fc22
VTABZ	equ	$fc24
CLEOLZ	equ	$fc9e
*
_rscrl_
	ldx	WNDBTM
	dex
	txa
	pha
	jsr	VTABZ
RSCRL1	lda	BASL
	sta	BAS2L
	lda	BASH
	sta	BAS2H
	ldy	WNDWTH
	dey
	pla
	tax
	dex
	txa
	bmi	RSCRL3
	cmp	WNDTOP
	bcc	RSCRL3
	pha
	jsr	VTABZ
RSCRL2	lda	(BASL),Y
	sta	(BAS2L),Y
	dey
	bpl	RSCRL2
	bmi	RSCRL1
RSCRL3	ldy	#0
	jsr	CLEOLZ
	jmp	VTAB
#endasm

devtab.c
/* Copyright (C) 1985 by Manx Software Systems, Inc. */

#include	<sgtty.h>
#include	<device.h>

#define INITLEN 64 /* 64 bytes for init-string space */

struct _dev_info _devinfo = {
	"DEV_INFO04/86",
	CON_HIGH, CRMOD | ECHO | ECHOE | XTABS | 4, 0x08, 0x18,
	"CON:", 0x40,
	"PR:", 1,
	"SER:", 2,
	0, 0, 0, 0xc0, 0x00, 0, SLOT_LFCR|SLOT_TABS|SLOT_HIGH, 0, 0, INIT_VEC, 0,
	0, 0, 0, 0xc1, 0x10, 0, SLOT_TABS, 0, 0, INIT_VEC|INIT_CAL, 0,
	0, 0, 0, 0xc2, 0x20, 0, SLOT_TABS, 0, 0, INIT_VEC, 0,
	0, 0, 0, 0xc3, 0x30, 0, SLOT_TABS, 0, 0, INIT_VEC|INIT_CAL, 0,
	0, 0, 0, 0xc4, 0x40, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0xc5, 0x50, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0xc6, 0x60, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0xc7, 0x70, 0, 0, 0, 0, 0, 0,
	INITLEN,
	0
};

static char _devinfobuf[INITLEN]={0};

gdev.a65
;:ts=8
; Copyright (C) 1985, by Manx Software Systems, Inc.

;	Generic Slot Device Driver

	instxt	<zpage.h>

; offsets into slot_dev structure

OUTVEC	equ	0
INVEC	equ	2
INIT	equ	4
SLOT	equ	6
HI_SLOT	equ	7
TYPE	equ	8
FLAGS	equ	9
TABP	equ	10
TABW	equ	11
IFLAGS	equ	12
XTRA	equ	13

; flags bit meanings

LFCR	equ	$01
TABS	equ	$02
UPPR	equ	$04
CRLF	equ	$08
HIGH	equ	$80

; iflags bit meanings

INITALL	equ	$07

INITVEC	equ	$01
INITCAL	equ	$02
INITSTR	equ	$04
REINIT	equ	$08
BACKVEC	equ	$10
BACKCAL	equ	$20
BACKSTR	equ	$40

; other zero page equates

CSWL	equ	$36
CSWH	equ	$37
KSWL	equ	$38
KSWH	equ	$39

; stuff needed for init
	public _dev_info_
INIT_BUF equ	154	;offset of initbuf from begin of devinfo structure

	public	_slot_open_
_slot_open_
	ldx	$cfff		;turn off all $C8 ROMs
	ldx	#SLOT-1
	jsr	set_slot	;copy arg from stack
	lda	#0		;set R0 to point to slot's firmware
	sta	R0
	ldy	#IFLAGS		;check out initialization flags
	lda	(VAL),Y
	sta	R0+2		;save for later use
	and	#REINIT		;check for re-open stuff
	beq	open1
	lda	(VAL),Y		;clear all the flags so only done once
	and	#$ff-INITALL
	sta	(VAL),Y
open1
	lda	R0+2
	and	#INITVEC	;check to see if we need to init the vectors
	beq	open3
	lda	R0+1
	and	#$f
	bne	open2		;if slot 0, do special
	jmp	copy_vec
open2
	ldy	#$05		;check for Pascal signature bytes
	lda	(R0),Y
	cmp	#$38
	jne	do_basic
	ldy	#$07
	lda	(R0),Y
	cmp	#$18
	jne	do_basic
	ldy	#$0b		;check for Pascal 1.1 signature
	lda	(R0),Y
	cmp	#$01
	bne	do_1.0
	ldy	#$0e		;get read entry point
	lda	(R0),Y
	ldy	#INVEC
	sta	(VAL),Y
	iny
	lda	R0+1
	sta	(VAL),Y
	ldy	#$0f		;get write entry point
	lda	(R0),Y
	ldy	#OUTVEC
	sta	(VAL),Y
	iny
	lda	R0+1
	sta	(VAL),Y
	ldy	#$0d		;get init entry point
	lda	(R0),Y
	sta	R0		;set up for call
	lda	#1
	bne	open3
;
do_1.0
	ldy	#INVEC
	lda	#$4d		;1.0 read entry point
	sta	(VAL),Y
	iny
	lda	#$c8
	sta	R0+1
	sta	(VAL),Y
	ldy	#OUTVEC+1
	sta	(VAL),Y
	dey
	lda	#$aa		;1.0 write entry point
	sta	(VAL),Y
	lda	#0
;
open3
	ldy	#TYPE		;set the entry type
	sta	(VAL),Y
open4
	lda	R0+2
	and	#INITCAL	;check to see if we should call the entry
	beq	open5
	ldy	#SLOT		;set up registers for call
	lda	(VAL),Y		;$Cs
	tax
	iny
	lda	(VAL),Y		;$s0
	tay
	jsr	call_R0
open5
	lda	R0+2
	and	#INITSTR	;check to see if anything gets sent to start
	bne	init0
	jmp	open6
init0
	clc	
	lda	_dev_info_	;set addr of init str in R0
	adc	#INIT_BUF
	sta	R1
	lda	_dev_info_+1
	bcc	init1
	adc	#0
init1	sta	R1+1
	clc
	ldy	#INIT
	lda	(VAL),Y
	adc	R1
	sta	R1
	bcc	init2
	inc	R1+1
init2					;go into loop, calling _slot_write
	ldx	#OUTVEC
	jsr	set_slot
	lda	#0
	sta	R1+2
init3	ldy	R1+2
	lda	(R1),Y
	tax	
	beq	open6
	jsr	put
	inc	R1+2
	jmp	init3
open6
	rts

;
call_R0
	jmp	(R0)		;call the init routine
;
do_basic
	jsr	copy_vec
	lda	R0+1
	sta	KSWH
	sta	CSWH
	lda	#0
	sta	KSWL
	sta	CSWL
	jsr	x1
	ldy	#OUTVEC
loop2
	lda	CSWL-OUTVEC,Y
	tax
	lda	(VAL),Y
	sta	CSWL-OUTVEC,Y
	txa
	sta	(VAL),Y
	iny
	cpy	#OUTVEC+4
	bne	loop2
	ldy	#TYPE
	lda	#-1
	sta	(VAL),Y
	bne	open5
;
x1	jmp	(KSWL)
;
copy_vec
	ldy	#OUTVEC
loop
	lda	CSWL-OUTVEC,Y
	sta	(VAL),Y
	iny
	cpy	#OUTVEC+4
	bne	loop
	rts
;

	public	_slot_read_
_slot_read_
	ldx	$CFFF		turn off all $C8 ROMs
	ldx	#INVEC
	jsr	set_slot
	jsr	do_call
	tax
	ldy	#FLAGS
	lda	(VAL),Y
	and	#LFCR
	beq	read1
	cpx	#$0d
	bne	read1
	ldx	#$0a
read1
	stx	R0
	lda	#0
	sta	R0+1
	rts
;
	public	_slot_write_
_slot_write_
	ldx	$CFFF		turn off all $C8 ROMs
	ldx	#OUTVEC
	jsr	set_slot
wr0
	tax
	ldy	#FLAGS
	lda	(VAL),Y
	tay
	and	#LFCR
	beq	wr1
	cpx	#$0a
	bne	wr1
	ldx	#$0d
wr1
	tya
	and	#UPPR
	beq	wr2
	cpx	#'a
	bcc	wr2
	cpx	#'z+1
	bcs	wr2
	txa
	adc	#'A-'a
	tax
wr2
	tya
	and	#TABS
	beq	wr3
	cpx	#$09
	bne	wr3
	ldy	#TABW
	lda	(VAL),Y
	bne	tab0
	lda	#$8
tab0
	sta	R0+2
	ldy	#TABP
tab1
	cmp	(VAL),Y
	bcc	tab2
	bne	tab3
tab2
	clc
	adc	R0+2
	bne	tab1
tab3
	sec
	sbc	(VAL),Y
	sta	R0+2
tab4
	ldx	#$20
	jsr	put
	dec	R0+2
	bne	tab4
	rts

wr3
	tya
	and	#CRLF
	beq	put
	cpx	#$0d
	bne	put
	jsr	put
	ldx	#$0a


put
	clc
	ldy	#TABP
	lda	(VAL),Y
	adc	#1
	sta	(VAL),Y
	cpx	#$0d		;is it return?
	beq	put1
	cpx	#$0c		;is it form feed
	bne	put2
put1
	lda	#0
	sta	(VAL),Y
put2
	ldy	#FLAGS
	lda	(VAL),Y
	and	#HIGH
	beq	put3
	txa
	ora	#$80
	tax
put3
	txa

do_call
	pha
	ldy	#SLOT
	lda	(VAL),Y
	tax
	iny
	lda	(VAL),Y
	tay
	pla
	jmp	(R0)
;

; set VAL to point to slot structure, and R0 to point to entry point
; optional second argument is returned in ACC

set_slot
	ldy	#2
	lda	(SP),Y
	sta	VAL
	iny
	lda	(SP),Y
	sta	VAL+1
	iny
	lda	(SP),Y
	pha
	txa
	tay
	lda	(VAL),Y
	sta	R0
	iny
	lda	(VAL),Y
	sta	R0+1
	pla
	rts
;
ioctl.c
/* Copyright (C) 1985 by Manx Software Systems, Inc. */

#include	<prodos.h>
#include	<errno.h>
#include	<sgtty.h>
#include	<device.h>


ioctl(fd, cmd, ttp)
struct sgttyb *ttp;
{
	register int err;
	register struct _fil_buf *b;

	if (fd < 0 || fd >= MAXFILES || (b = _fil_tab+fd)->unit == 0 ||
												(b->unit&0xc0) != 0xc0) {
		errno = EBADF;
		return(-1);
	}
	if (cmd == TIOCGETP)
		*ttp = _dev_info->tty;
	else if (cmd == TIOCSETP || cmd == TIOCSETN)
		_dev_info->tty = *ttp;
	else
		return(-1);
	return(0);
}

tmpdev.c
/* Copyright (C) 1985 by Manx Software Systems, Inc. */

#asm
	instxt	<zpage.h>
#endasm

_kb_get(buf, cnt)
register char *buf;
register int cnt;
{
	static char xbuf[256];
	static char *xp = 0;
	register unsigned short i;
	char *index();

	if (xp == 0) {
		*(char *)0x33 = 0xa0;
		(*((void (*)())0xfd6f))();			/* call the GETLN routine */
		movmem((char *)0x200, xbuf, 256);	/* copy to our buffer */
		for (xp=xbuf;*xp!=0x8d;xp++)		/* get rid of high bits */
			*xp &= 0x7f;
		*xp++ = '\n';						/* replace CR with LF */
		*xp = 0;							/* null terminate */
		xp = xbuf;
	}
	if ((i=strlen(xp)) < cnt)
		cnt = i;
	movmem(xp, buf, cnt);
	if (cnt == i)
		xp = 0;
	else
		xp += cnt;
	return(cnt);
}

_kb_put(buf, cnt)
register char *buf;
register int cnt;
{
#asm
	lda	$c000
	cmp	#$83
	bne	nobreak
	lda	$c010
	ldy	#2
	lda	#-1
	sta	(SP),Y
	iny
	sta	(SP),Y
	public	_exit_
	jmp	_exit_
nobreak
	ldy	#0
	lda	REGS+3
	sta	R0+1
	ldx	REGS+2
	stx	R0
	beq	skip
loop
	lda	(REGS),Y
	cmp	#$a
	bne	nolf
	lda	#$d
nolf
	cmp	#$9
	bne	notab
	lda	#$20
notab
	ora	#$80
	jsr	$fded
	iny
	bne	nobump
	inc	REGS+1
nobump
	dex
	bne	loop
skip
	dec	REGS+3
	bpl	loop
#endasm
}

makefile
.SUFFIXES: .c .a65 .r .i

.c.r:
	cg65 +g0,8,80,10 -o $*.r $*.c
	sqz65 $*.r

.c.i:
	cci -ao $*.asm $*.c
	optint65 -ZAP $*.asm
	sqz65 $*.i

.a65.r:
	as65 -o $*.r $*.a65
	sqz65 $*.r

REL=  device.r devtab.r gdev.r ioctl.r tmpdev.r

INT= device.r devtab.i gdev.r ioctl.i

SRC= device.c devtab.c gdev.a65 ioctl.c tmpdev.c

rel: $(REL)
	echo done

int: $(INT)
	echo done
