fldstar.a65
*:ts=8
*
* Copyright (C) 1983,84,85 by Manx Software Systems, Inc.
*
	instxt	<zpage.h>
*
*	on entry:	Acc - field length
*			X   - field pos
*			Y   - pointer to field
*
	public	.ldfldu
.ldfldu
	pha
	lda	0,Y		;get the pointer to the field
	sta	VAL
	lda	1,Y
	sta	VAL+1
	ldy	#0
	lda	(VAL),Y		;get the whole field into R0
	sta	R0
	iny
	lda	(VAL),Y
	sta	R0+1
	txa			;now, shift to the pos
	beq	ldf2
ldf1	lsr	R0+1
	ror	R0
	dex
	bne	ldf1
ldf2	pla			;get back the length
	jsr	setmask		;make the proper mask
	lda	R0		;mask off unwanted bits
	and	R0+2
	sta	R0
	lda	R0+1
	and	R0+3
	sta	R0+1
	lda	#0		;fix registers
	tax
	ldy	#1
	rts			;and all done

	public	.ldfld
.ldfld
	jsr	.ldfldu
	lda	R0+3
	eor	#$ff
	sta	R0+3
	lsr	A
	and	R0+1
	sta	VAL
	lda	R0+2
	eor	#$ff
	sta	R0+2
	ror	A
	and	R0
	ora	VAL
	beq	ldfld1
	lda	R0
	ora	R0+2
	sta	R0
	lda	R0+1
	ora	R0+3
	sta	R0+1
ldfld1	txa
	rts

	public	.stfld
.stfld
	pha
	lda	0,Y		;get the pointer to the field
	sta	VAL
	lda	1,Y
	sta	VAL+1
	pla			;get the mask
	jsr	setmask
	txa			;shift the field
	beq	stf2		;jd 6/18/86
stf1	asl	R0
	rol	R0+1
	asl	R0+2
	rol	R0+3
	dex
	bne	stf1
stf2	lda	R0		;isolate the field
	and	R0+2
	sta	R0
	lda	R0+1
	and	R0+3
	sta	R0+1
	iny
stf3	lda	R0+2,Y		;get mask
	eor	#$ff		;complement
	and	(VAL),Y		;get part of field we need
	ora	R0,Y		;put in field
	sta	(VAL),Y		;and put back
	dey
	bpl	stf3
	txa			;reset registers
	ldy	#1
	rts			;and return


setmask
	tay
	lda	#0
	sta	R0+2
	sta	R0+3
set1	sec
	rol	R0+2
	rol	R0+3
	dey
	bne	set1
	rts

flt.a65
;:ts=8

	public	.fltjmp
.fltjmp
	rts
fstswt.a65
*:ts=8
*
* Copyright (C) 1983,84,85 by Manx Software Systems, Inc.
*
	instxt	<zpage.h>
*
	public	.fstswt
.fstswt	pla
	sta	VAL
	pla
	sta	VAL+1
	ldy	#1
	clc
	lda	(VAL),Y
	adc	R0
	sta	R0
	iny
	lda	(VAL),Y
	adc	R0+1
	sta	R0+1
	iny
	lda	R0
	cmp	(VAL),Y
	iny
	lda	R0+1
	sbc	(VAL),Y
	iny
	bcs	fstswt1
	lda	R0
	asl	A
	rol	R0+1
	adc	VAL
	sta	VAL
	lda	R0+1
	adc	VAL+1
	sta	VAL+1
	ldy	#7
fstswt1	lda	(VAL),Y
	sta	R0
	iny
	lda	(VAL),Y
	sta	R0+1
	jmp	(R0)
*
index.a65
*:ts=8
*
* Copyright (C) 1985 by Manx Software Systems, Inc.
*
	instxt	<zpage.h>
*
*	char *
*	index(str, c)
*	  char *str;
*	  int c;
*
*	returns a pointer to the first occurrence of c in s
*

STR	equ	R0+2
C	equ	R0+4

	public	index_
index_
	ldy	#4		;copy params to zero page
index1	lda	(SP),Y
	sta	R0,Y
	dey
	bne	index1
index2	lda	(STR),Y
	beq	index3
	cmp	C
	beq	index4
	iny
	bne	index2
	inc	STR+1
	bne	index2
index3	lda	#0
	sta	R0
	sta	R0+1
	rts
index4	clc
	tya
	adc	STR
	sta	R0
	lda	#0
	adc	STR+1
	sta	R0+1
	rts

strchr.a65
*:ts=8
*
* Copyright (C) 1985 by Manx Software Systems, Inc.
*
	instxt	<zpage.h>
*
*	char *
*	strchr(str, c)
*	  char *str;
*	  int c;
*
*	returns a pointer to the first occurrence of c in s
*

STR	equ	R0+2
C	equ	R0+4

	public	strchr_
strchr_
	ldy	#4		;copy params to zero page
index1	lda	(SP),Y
	sta	R0,Y
	dey
	bne	index1
index2	lda	(STR),Y
	cmp	C
	beq	index4
	cmp	#0
	beq	index3
	iny
	bne	index2
	inc	STR+1
	bne	index2
index3	lda	#0
	sta	R0
	sta	R0+1
	rts
index4	clc
	tya
	adc	STR
	sta	R0
	lda	#0
	adc	STR+1
	sta	R0+1
	rts

interp.a65
*:ts=8
*
* Copyright (c) 1983,1985 by Manx Software Systems, Inc.
*
	instxt	"zpage.h"
*
	cseg
	public	.interp
.interp	pla			;put return addr in R0
	sta	R0
	pla
	sta	R0+1
	pla
	sta	VAL
	pla
	sta	VAL+1
	ldy	#7		;save old SP and old FRAME
	sec
	lda	SP		;drop SP by frame size
	sbc	#9
	sta	R1		;and save temporarily in R1
	lda	SP+1
	sbc	#0
	sta	R1+1
inter1	lda	VAL,Y
	sta	(R1),Y
	dey
	bpl	inter1
	ldy	#1
	clc
	lda	R1		;drop SP by locals size
	sta	FRAME		;move to FRAME first
	adc	(R0),Y
	sta	SP
	iny
	lda	R1+1
	sta	FRAME+1
	adc	(R0),Y
	sta	SP+1
	clc			;bump return address by 3 and use as PC
	lda	R0
	adc	#3
	sta	PC
	lda	R0+1
	adc	#0
	sta	PC+1
	public	mloop
mloop	ldy	#0		;main interpreter loop
	lda	(PC),Y		;get opcode
	inc	PC		;bump program counter
	bne	mloop1
	inc	PC+1
mloop1	tax
	lda	LTAB,X		;get address
	sta	VAL
	lda	HTAB,X
	sta	VAL+1
	jmp	(VAL)
*
*	short instructions
*
*					load local into primary
*
shldlp0	lda	#-24
	bne	shldlpv
shldlp1	lda	#-22
	bne	shldlpv
shldlp2	lda	#-20
	bne	shldlpv
shldlp3	lda	#-18
	bne	shldlpv
shldlp4	lda	#-16
	bne	shldlpv
shldlp5	lda	#-14
	bne	shldlpv
shldlp6	lda	#-12
	bne	shldlpv
shldlp7	lda	#-10
	bne	shldlpv
shldlp8	lda	#-8
	bne	shldlpv
shldlp9	lda	#-6
	bne	shldlpv
shldlpA	lda	#-4
	bne	shldlpv
shldlpB	lda	#-2
shldlpv	clc
	adc	FRAME
	sta	VAL
	lda	#-1
	adc	FRAME+1
	sta	VAL+1
	lda	(VAL),Y
	sta	R0
	iny
	lda	(VAL),Y
	sta	R0+1
	jmp	mloop
shldlpF	ldy	#$11
	bne	shldlpf
shldlpE	ldy	#$0F
	bne	shldlpf
shldlpD	ldy	#$0D
	bne	shldlpf
shldlpC	ldy	#$0B
shldlpf	lda	(FRAME),Y
	sta	R0
	iny
	lda	(FRAME),Y
	sta	R0+1
	jmp	mloop
*
*					load local into secondary
*
shldls0	lda	#-24
	bne	shldlsv
shldls1	lda	#-22
	bne	shldlsv
shldls2	lda	#-20
	bne	shldlsv
shldls3	lda	#-18
	bne	shldlsv
shldls4	lda	#-16
	bne	shldlsv
shldls5	lda	#-14
	bne	shldlsv
shldls6	lda	#-12
	bne	shldlsv
shldls7	lda	#-10
	bne	shldlsv
shldls8	lda	#-8
	bne	shldlsv
shldls9	lda	#-6
	bne	shldlsv
shldlsA	lda	#-4
	bne	shldlsv
shldlsB	lda	#-2
shldlsv	clc
	adc	FRAME
	sta	VAL
	lda	#-1
	adc	FRAME+1
	sta	VAL+1
	lda	(VAL),Y
	sta	R1
	iny
	lda	(VAL),Y
	sta	R1+1
	jmp	mloop
shldlsF	ldy	#$11
	bne	shldlsf
shldlsE	ldy	#$0F
	bne	shldlsf
shldlsD	ldy	#$0D
	bne	shldlsf
shldlsC	ldy	#$0B
shldlsf	lda	(FRAME),Y
	sta	R1
	iny
	lda	(FRAME),Y
	sta	R1+1
	jmp	mloop
*
*					store primary into local
*
shstl0	lda	#-24
	bne	shstlv
shstl1	lda	#-22
	bne	shstlv
shstl2	lda	#-20
	bne	shstlv
shstl3	lda	#-18
	bne	shstlv
shstl4	lda	#-16
	bne	shstlv
shstl5	lda	#-14
	bne	shstlv
shstl6	lda	#-12
	bne	shstlv
shstl7	lda	#-10
	bne	shstlv
shstl8	lda	#-8
	bne	shstlv
shstl9	lda	#-6
	bne	shstlv
shstlA	lda	#-4
	bne	shstlv
shstlB	lda	#-2
shstlv	clc
	adc	FRAME
	sta	VAL
	lda	#-1
	adc	FRAME+1
	sta	VAL+1
	lda	R0
	sta	(VAL),Y
	iny
	lda	R0+1
	sta	(VAL),Y
	jmp	mloop
shstlF	ldy	#$11
	bne	shstlf
shstlE	ldy	#$0F
	bne	shstlf
shstlD	ldy	#$0D
	bne	shstlf
shstlC	ldy	#$0B
shstlf	lda	R0
	sta	(FRAME),Y
	iny
	lda	R0+1
	sta	(FRAME),Y
	jmp	mloop
*
*					push local onto stack
*
shpshl0	lda	#-24
	bne	shpshlv
shpshl1	lda	#-22
	bne	shpshlv
shpshl2	lda	#-20
	bne	shpshlv
shpshl3	lda	#-18
	bne	shpshlv
shpshl4	lda	#-16
	bne	shpshlv
shpshl5	lda	#-14
	bne	shpshlv
shpshl6	lda	#-12
	bne	shpshlv
shpshl7	lda	#-10
	bne	shpshlv
shpshl8	lda	#-8
	bne	shpshlv
shpshl9	lda	#-6
	bne	shpshlv
shpshlA	lda	#-4
	bne	shpshlv
shpshlB	lda	#-2
shpshlv	clc
	adc	FRAME
	sta	VAL
	lda	#-1
	adc	FRAME+1
	sta	VAL+1
	iny
	lda	(VAL),Y
	tax
	dey
	lda	(VAL),Y
	jmp	pshwrd
shpshlF	ldy	#$12
	bne	shpshlf
shpshlE	ldy	#$10
	bne	shpshlf
shpshlD	ldy	#$0E
	bne	shpshlf
shpshlC	ldy	#$0C
shpshlf	lda	(FRAME),Y
	tax
	dey
	lda	(FRAME),Y
	jmp	pshwrd
*
*					load primary immediate (0-15)
*
shldipF
shldipE
shldipD
shldipC
shldipB
shldipA
shldip9
shldip8
shldip7
shldip6
shldip5
shldip4
shldip3
shldip2
shldip1
	txa
	and	#$0f
	sta	R0
	sty	R0+1
	jmp	mloop
shldip0	sty	R0
	sty	R0+1
	jmp	mloop
*
*					load secondary immediate (0-15)
*
shldisF
shldisE
shldisD
shldisC
shldisB
shldisA
shldis9
shldis8
shldis7
shldis6
shldis5
shldis4
shldis3
shldis2
shldis1
	txa
	and	#$0f
	sta	R1
	sty	R1+1
	jmp	mloop
shldis0	sty	R1
	sty	R1+1
	jmp	mloop
*
*					push immediate (0-15)
*
shpshiF
shpshiE
shpshiD
shpshiC
shpshiB
shpshiA
shpshi9
shpshi8
shpshi7
shpshi6
shpshi5
shpshi4
shpshi3
shpshi2
shpshi1
shpshi0	txa
	and	#$0f
	ldx	#0
	jmp	pshwrd
*
*					add immediate to primary (0-15)
*
shaddiF
shaddiE
shaddiD
shaddiC
shaddiB
shaddiA
shaddi9
shaddi8
shaddi7
shaddi6
shaddi5
shaddi4
shaddi3
shaddi2
shaddi1	txa
	and	#$0f
	clc
	adc	R0
	sta	R0
	bcc	shaddi0
	inc	R0+1
shaddi0	jmp	mloop
*
*	regular instructions
*
ldlpl	jsr	twolcl
	bcc	ldprm
*
ldlps	jsr	onelcl
ldprm	lda	(VAL),Y
	sta	R0
	iny
	lda	(VAL),Y
	sta	R0+1
	jmp	mloop
*
ldgp	jsr	twoval		;load global into primary
	bcc	ldprm
*
ldlss	jsr	onelcl
ldsec	lda	(VAL),Y
	sta	R1
	iny
	lda	(VAL),Y
	sta	R1+1
	jmp	mloop
*
ldlsl	jsr	twolcl
	bcc	ldsec
*
ldgs	jsr	twoval		;load global into secondary
	bcc	ldsec
*
stls	jsr	onelcl
store	lda	R0
	sta	(VAL),Y
	iny
	lda	R0+1
	sta	(VAL),Y
	jmp	mloop
*
stll	jsr	twolcl
	bcc	store
*
stg	jsr	twoval		;store primary into global
	bcc	store
*
pshls	jsr	onelcl
pshval	iny
	lda	(VAL),Y
	tax
	dey
	lda	(VAL),Y
	jmp	pshwrd
*
pshll	jsr	twolcl
	bcc	pshval
*
pshg	jsr	twoval		;push global onto stack
	bcc	pshval
*
leap	jsr	twobyte		;load effective address into primary
	adc	FRAME
	sta	R0
	txa
	adc	FRAME+1
	sta	R0+1
	jmp	mloop
*
leas	jsr	twobyte		;load effective address into secondary
	adc	FRAME
	sta	R1
	txa
	adc	FRAME+1
	sta	R1+1
	jmp	mloop
*
ldips	jsr	onebyte
ldip	sta	R0		;load immediate value into primary
	stx	R0+1
	jmp	mloop
*
ldipl	jsr	twobyte
	bcc	ldip
*
ldiss	jsr	onebyte
ldis	sta	R1		;load immediate value into secondary
	stx	R1+1
	jmp	mloop
*
ldisl	jsr	twobyte
	bcc	ldis
*
pshis	jsr	onebyte		;push immediate value onto the stack
	jmp	pshwrd
*
pshil	jsr	twobyte
	jmp	pshwrd
*
addis	jsr	onebyte
addi	adc	R0		;add immediate value to primary
	sta	R0
	txa
	adc	R0+1
	sta	R0+1
	jmp	mloop
*
addil	jsr	twobyte
	bcc	addi
*
ldlpb	jsr	twolcl
ldpb	lda	(VAL),Y		;load local byte into primary
	sta	R0
	sty	R0+1
	jmp	mloop
*
ldgpb	jsr	twoval		;load primary with global byte
	bcc	ldpb
*
ldlsb	jsr	twolcl
ldsbb	lda	(VAL),Y		;load local byte into secondary
	sta	R1
	sty	R1+1
	jmp	mloop
*
ldgsb	jsr	twoval		;load secondary with global byte
	bcc	ldsbb
*
stlb	jsr	twolcl
stb	lda	R0		;store primary as local byte
	sta	(VAL),Y
	jmp	mloop
*
stgb	jsr	twoval		;store the primary into a global byte
	bcc	stb
*
pshlb	jsr	twolcl
pshb	lda	(VAL),Y		;push a local byte onto the stack
	ldx	#0
	jmp	pshwrd
*
pshgb	jsr	twoval		;push a global byte onto the stack
	bcc	pshb
*
calli	lda	R0		;call through primary and pop args
	sta	VAL
	lda	R0+1
	sta	VAL+1
	jmp	calls1
*
calls	jsr	twoval		;call a subroutine and pop args
calls1	jsr	callit1
	ldy	#0
	jmp	ssps
*
callind	lda	R0		;call through primary
	sta	VAL
	lda	R0+1
	sta	VAL+1
	jmp	callsu1
*
callsub	jsr	twoval		;call a subroutine
callsu1	jsr	callit1
	jmp	mloop
*
callit1	sec
	lda	SP
	sbc	#2
	sta	SP
	bcs	callit2
	dec	SP+1
callit2	lda	PC
	sta	(SP),Y
	iny
	lda	PC+1
	sta	(SP),Y
	jsr	callit4
	clc
	lda	SP
	adc	#2
	sta	SP
	bcc	callit3
	inc	SP+1
callit3
	rts
callit4	jmp	(VAL)
*
move	jsr	twobyte		;move size bytes from R0 to R1
	ldy	#0
	stx	VAL
	tax
	bne	move1
move0	dec	VAL
	bpl	move1
	jmp	mloop
move1	lda	(R0),Y
	sta	(R1),Y
	iny
	bne	move2
	inc	R0+1
	inc	R1+1
move2	dex
	beq	move0
	bne	move1
*
ssps	jsr	onebyte
	adc	SP
	sta	SP
	bcc	ssps1
	inc	SP+1
ssps1	jmp mloop
*
sspl	jsr	twobyte		;modify stack pointer
	adc	SP
	sta	SP
	txa
	adc	SP+1
	sta	SP+1
	jmp	mloop
*
brn	jsr	twobyte		;branch always
	sta	PC
	stx	PC+1
	jmp	mloop
*
btrue	lda	R0		;branch if true
	ora	R0+1
	bne	brn
brn1	jsr	twobyte
	jmp	mloop
*
bfalse	lda	R0		;branch if false
	ora	R0+1
	beq	brn
	bne	brn1
*
brnb	jsr	onebyte		;branch always back
	adc	PC
	sta	PC
	bcs	brnb1
	dec	PC+1
brnb1	jmp	mloop
*
btb	lda	R0		;branch back if true
	ora	R0+1
	bne	brnb
btb1	jsr	onebyte
	jmp	mloop
*
bfb	lda	R0		;branch back if false
	ora	R0+1
	beq	brnb
	bne	btb1
*
brnf	jsr	onebyte		;branch always forward
	adc	PC
	sta	PC
	bcc	brnf1
	inc	PC+1
brnf1	jmp	mloop
*
btf	lda	R0		;branch forward if true
	ora	R0+1
	bne	brnf
btf1	jsr	onebyte
	jmp	mloop
*
bff	lda	R0		;branch forward if false
	ora	R0+1
	beq	brnf
	bne	btf1
*
switch	lda	(PC),Y
	tax
	iny
	lda	(PC),Y
	sta	R1
	clc
	lda	PC
	adc	#2
	sta	PC
	bcc	switch1
	inc	PC+1
switch1	ldy	#0
	txa
	bne	switch2
	dec	R1
	bpl	switch2
	dey
	bne	switch4
switch2	dex
	lda	(PC),Y
	cmp	R0
	bne	switch3
	iny
	lda	(PC),Y
	cmp	R0+1
	beq	switch4
switch3	clc
	lda	PC
	adc	#4
	sta	PC
	bcc	switch1
	inc	PC+1
	bcs	switch1
switch4	iny
	lda	(PC),Y
	tax
	iny
	lda	(PC),Y
	sta	PC+1
	stx	PC
	jmp	mloop
*
fstswt	clc			;fast switch code
	lda	(PC),Y
	adc	R0
	sta	R0
	iny
	lda	(PC),Y
	adc	R0+1
	sta	R0+1
	iny
	lda	R0
	cmp	(PC),Y
	iny
	lda	R0+1
	sbc	(PC),Y
	iny
	bcs	fstswt1
	lda	R0
	asl	A
	rol	R0+1
	adc	PC
	sta	PC
	lda	R0+1
	adc	PC+1
	sta	PC+1
	ldy	#6
fstswt1	lda	(PC),Y
	tax
	iny
	lda	(PC),Y
	sta	PC+1
	stx	PC
	jmp	mloop
*
lds	lda	(R0),Y		;load the primary through the primary
	tax
	iny
	lda	(R0),Y
	stx	R0
	sta	R0+1
	jmp mloop
*
ldsb	lda	(R0),Y		;load a byte value through the primary
	sta	R0
	sty	R0+1
	jmp	mloop
*
sts	jsr	pul0		;store the primary through the stack
	lda	R0+1
	sta	(R1),Y
	dey
	lda	R0
	sta	(R1),Y
	jmp	mloop
*
stsb	jsr	pul0		;store a byte primary through the stack
	dey
	lda	R0
	sta	(R1),Y
	jmp	mloop
*
psh	lda	R0		;push the primary on the stack
	ldx	R0+1
	jmp	pshwrd
*
pul	jsr	pul0		;pull the secondary from the stack
	jmp	mloop
*
	public	pul0
pul0	lda	(SP),Y
	sta	R1
	iny
	lda	(SP),Y
	sta	R1+1
	clc
	lda	SP
	adc	#2
	sta	SP
	bcc	pul1
	inc	SP+1
pul1	rts
*
mult	ldy	#0		;multiply the primary by the secondary
	sty	VAL
	sty	VAL+1
	ldy	#$10
.ml1	lda	R0
	lsr	A
	bcc	.ml2
	clc
	lda	VAL
	adc	R1
	sta	VAL
	lda	VAL+1
	adc	R1+1
	sta	VAL+1
.ml2	ror	VAL+1
	ror	VAL
	ror	R0+1
	ror	R0
	dey
	bne	.ml1
	jmp	mloop
*
udiv	jsr	.dv		;divide the primary by the secondary
	jmp	mloop
*
div	jsr	.sign		;divide the primary by the secondary
	jsr	.dv
	lda	R0+2
	bpl	div1
	jmp	neg
div1	jmp	mloop
*
.dv	ldy	#0		;divide the primary by the secondary
	sty	VAL
	sty	VAL+1
	ldy	#$10
.dv1	asl	R0
	rol	R0+1
	rol	VAL
	rol	VAL+1
	sec
	lda	VAL
	sbc	R1
	tax
	lda	VAL+1
	sbc	R1+1
	bcc	.dv2
	stx	VAL
	sta	VAL+1
	inc	R0
.dv2	dey
	bne	.dv1
	rts
*
mod	jsr	.sign		;primary % secondary
	jsr	.dv
	lda	VAL
	sta	R0
	lda	VAL+1
	sta	R0+1
	lda	R0+3
	bpl	mod1
	jmp	neg
mod1	jmp	mloop
*
umod	jsr	.dv		;primary % secondary
	lda	VAL
	sta	R0
	lda	VAL+1
	sta	R0+1
	jmp	mloop
*
.sign	lda	R0+1		;get sign of primary and secondary
	sta	R0+3
	eor	R1+1
	sta	R0+2
	lda	R0+1
	bpl	.sign1
	sec
	tya
	sbc	R0
	sta	R0
	tya
	sbc	R0+1
	sta	R0+1
.sign1	lda	R1+1
	bpl	.sign2
	sec
	tya
	sbc	R1
	sta	R1
	tya
	sbc	R1+1
	sta	R1+1
.sign2	rts
*
addps	clc			;add the secondary to the primary
	lda	R0
	adc	R1
	sta	R0
	lda	R0+1
	adc	R1+1
	sta	R0+1
	jmp	mloop
*
subps	sec			;subtract the secondary from the primary
	lda	R0
	sbc	R1
	sta	R0
	lda	R0+1
	sbc	R1+1
	sta	R0+1
	jmp	mloop
*
lshift	ldx	R1		;primary << secondary
	bne	.ls2
.ls0	dec	R1+1
.ls1	bpl	.ls2
	jmp	mloop
.ls2	asl	R0
	rol	R0+1
	dex
	beq	.ls0
	bne	.ls2
*
rshift	lda	R0+1		;primary >> secondary
	bpl	urshift
	ldx	R1
	bne	.rs2
.rs0	dec	R1+1
.rs1	bpl	.rs2
	jmp	mloop
.rs2	sec
	ror	R0+1
	ror	R0
	dex
	beq	.rs0
	bne	.rs2
*
urshift	ldx	R1		;primary >> secondary
	bne	.ur2
.ur0	dec	R1+1
.ur1	bpl	.ur2
	jmp	mloop
.ur2	lsr	R0+1
	ror	R0
	dex
	beq	.ur0
	bne	.ur2
*
andd	lda	R0		;primary & secondary -> primary
	and	R1
	sta	R0
	lda	R0+1
	and	R1+1
	sta	R0+1
	jmp	mloop
*
orr	lda	R0		;primary | secondary -> primary
	ora	R1
	sta	R0
	lda	R0+1
	ora	R1+1
	sta	R0+1
	jmp	mloop
*
xorr	lda	R0		;primary ^ secondary -> primary
	eor	R1
	sta	R0
	lda	R0+1
	eor	R1+1
	sta	R0+1
	jmp	mloop
*
eq	lda	R0+1		;primary == secondary
	cmp	R1+1
	sty	R0+1
	bne	.eq1
	lda	R0
	cmp	R1
	bne	.eq1
	iny
.eq1	sty	R0
	jmp	mloop
*
ne	lda	R0+1		;primary != secondary
	cmp	R1+1
	sty	R0+1
	bne	.ne1
	lda	R0
	cmp	R1
	beq	.ne2
.ne1	iny
.ne2	sty	R0
	jmp	mloop
*
lt	lda	R0		;primary < secondary
	cmp	R1
	lda	R0+1
	sbc	R1+1
	sty	R0+1
	bpl	.lt1
	iny
.lt1	tya
	bvc	.lt2
	eor	#1
.lt2	sta	R0
	jmp	mloop
*
gt	lda	R1		;primary > secondary
	cmp	R0
	lda	R1+1
	sbc	R0+1
	sty	R0+1
	bpl	.gt1
	iny
.gt1	tya
	bvc	.gt2
	eor	#1
.gt2	sta	R0
	jmp	mloop
*
le	lda	R1		;primary <= secondary
	cmp	R0
	lda	R1+1
	sbc	R0+1
	sty	R0+1
	bmi	.le1
	iny
.le1	tya
	bvc	.le2
	eor	#1
.le2	sta	R0
	jmp	mloop
*
ge	lda	R0		;primary >= secondary
	cmp	R1
	lda	R0+1
	sbc	R1+1
	sty	R0+1
	bmi	.ge1
	iny
.ge1	tya
	bvc	.ge2
	eor	#1
.ge2	sta	R0
	jmp	mloop
*
ult	lda	R0		;primary < secondary
	cmp	R1
	lda	R0+1
	sbc	R1+1
	sty	R0+1
	bcs	.ul1
	iny
.ul1	sty	R0
	jmp	mloop
*
ugt	lda	R1		;primary > secondary
	cmp	R0
	lda	R1+1
	sbc	R0+1
	sty	R0+1
	bcs	.ug1
	iny
.ug1	sty	R0
	jmp	mloop
*
ule	lda	R1		;primary <= secondary
	cmp	R0
	lda	R1+1
	sbc	R0+1
	sty	R0+1
	bcc	.ue1
	iny
.ue1	sty	R0
	jmp	mloop
*
uge	lda	R0		;primary >= secondary
	cmp	R1
	lda	R0+1
	sbc	R1+1
	sty	R0+1
	bcc	.uf1
	iny
.uf1	sty	R0
	jmp	mloop
*
not	lda	R0+1		;!primary -> primary
	sty	R0+1
	ora	R0
	bne	not1
	iny
not1	sty	R0
	jmp	mloop
*
neg	sec			;-primary -> primary
	tya
	sbc	R0
	sta	R0
	tya
	sbc	R0+1
	sta	R0+1
	jmp	mloop
*
com	lda	R0		;~primary -> primary
	eor	#$ff
	sta	R0
	lda	R0+1
	eor	#$ff
	sta	R0+1
	jmp	mloop
*
swap	lda	R0		;exchange primary and secondary
	ldx	R1
	stx	R0
	sta	R1
	lda	R0+1
	ldx	R1+1
	stx	R0+1
	sta	R1+1
	jmp	mloop
*
incr	inc	R0		;increment the primary
	bne	incr1
	inc	R0+1
incr1	jmp	mloop
*
decr	lda	R0		;decrement the primary
	bne	decr1
	dec	R0+1
decr1	dec	R0
	jmp	mloop
*
double	asl	R0		;double the primary register
	rol	R0+1
	jmp	mloop
*
ldfld	jsr	twobyte
	ldy	#R0
	jsr	.ldfld#
	jmp	mloop
*
ldfldu	jsr	twobyte
	ldy	#R0
	jsr	.ldfldu#
	jmp	mloop
*
stfld	jsr	twobyte
	ldy	#R1
	jsr	.stfld#
	jmp	mloop
*
return	ldy	#7		;clean up stack and return
	lda	FRAME
	sta	R1
	lda	FRAME+1
	sta	R1+1
return1	lda	(R1),Y
	sta	VAL,Y
	dey
	bpl	return1
	inc	VAL
	bne	return2
	inc	VAL+1
	ldx	#0
return2	jmp	(VAL)
*
	public	.unknown
.unknown	brk
*
	public	brkpnt
brkpnt	brk
	jmp	mloop
*
*		support routines
*
onebyte	ldx	#0		;fetch and sign extend one byte operand
	lda	(PC),Y
	bpl	onebyt1
	dex
onebyt1	inc	PC
	bne	onebyt2
	inc	PC+1
onebyt2	clc
	rts
*
onelcl	clc			;fetch local address
	ldx	#0
	lda	(PC),Y
	bpl	onelcl1
	dex
onelcl1	adc	FRAME
	sta	VAL
	txa
	adc	FRAME+1
	sta	VAL+1
	inc	PC
	bne	onelcl2
	inc	PC+1
onelcl2	clc
	rts
*
twobyte	iny			;fetch two byte operand
	lda	(PC),Y
	tax
	dey
	lda	(PC),Y
	pha
	clc
	lda	PC
	adc	#2
	sta	PC
	bcc	twobyt1
	inc	PC+1
	clc
twobyt1	pla
	rts
*
	public	twoval
twoval	lda	(PC),Y		;fetch two byte operand into VAL
	sta	VAL
	iny
	lda	(PC),Y
	sta	VAL+1
	dey
	clc
	lda	PC
	adc	#2
	sta	PC
	bcc	twoval1
	inc	PC+1
	clc
twoval1	rts
*
	public	twolcl
twolcl	clc			;fetch two byte local address into VAL
	lda	(PC),Y
	adc	FRAME
	sta	VAL
	iny
	lda	(PC),Y
	adc	FRAME+1
	sta	VAL+1
	dey
	clc
	lda	PC
	adc	#2
	sta	PC
	bcc	twolcl1
	inc	PC+1
	clc
twolcl1	rts
*
pshwrd	tay
	sec
	lda	SP
	sbc	#2
	sta	SP
	bcs	pshwrd1
	dec	SP+1
pshwrd1	tya
	ldy	#0
	sta	(SP),Y
	iny	
	txa
	sta	(SP),Y
	jmp	mloop
*
*
*
jmpflt	jsr	.fltjmp#
	jmp	mloop
*
*
*
*
	public	LTAB
LTAB
	fcb	<shldlp0	;10
	fcb	<shldlp1
	fcb	<shldlp2
	fcb	<shldlp3
	fcb	<shldlp4
	fcb	<shldlp5
	fcb	<shldlp6
	fcb	<shldlp7
	fcb	<shldlp8
	fcb	<shldlp9
	fcb	<shldlpA
	fcb	<shldlpB
	fcb	<shldlpC
	fcb	<shldlpD
	fcb	<shldlpE
	fcb	<shldlpF
	fcb	<shldls0	;10
	fcb	<shldls1
	fcb	<shldls2
	fcb	<shldls3
	fcb	<shldls4
	fcb	<shldls5
	fcb	<shldls6
	fcb	<shldls7
	fcb	<shldls8
	fcb	<shldls9
	fcb	<shldlsA
	fcb	<shldlsB
	fcb	<shldlsC
	fcb	<shldlsD
	fcb	<shldlsE
	fcb	<shldlsF
	fcb	<shstl0		;20
	fcb	<shstl1
	fcb	<shstl2
	fcb	<shstl3
	fcb	<shstl4
	fcb	<shstl5
	fcb	<shstl6
	fcb	<shstl7
	fcb	<shstl8
	fcb	<shstl9
	fcb	<shstlA
	fcb	<shstlB
	fcb	<shstlC
	fcb	<shstlD
	fcb	<shstlE
	fcb	<shstlF
	fcb	<shpshl0	;30
	fcb	<shpshl1
	fcb	<shpshl2
	fcb	<shpshl3
	fcb	<shpshl4
	fcb	<shpshl5
	fcb	<shpshl6
	fcb	<shpshl7
	fcb	<shpshl8
	fcb	<shpshl9
	fcb	<shpshlA
	fcb	<shpshlB
	fcb	<shpshlC
	fcb	<shpshlD
	fcb	<shpshlE
	fcb	<shpshlF
	fcb	<shldip0	;40
	fcb	<shldip1
	fcb	<shldip2
	fcb	<shldip3
	fcb	<shldip4
	fcb	<shldip5
	fcb	<shldip6
	fcb	<shldip7
	fcb	<shldip8
	fcb	<shldip9
	fcb	<shldipA
	fcb	<shldipB
	fcb	<shldipC
	fcb	<shldipD
	fcb	<shldipE
	fcb	<shldipF
	fcb	<shldis0	;50
	fcb	<shldis1
	fcb	<shldis2
	fcb	<shldis3
	fcb	<shldis4
	fcb	<shldis5
	fcb	<shldis6
	fcb	<shldis7
	fcb	<shldis8
	fcb	<shldis9
	fcb	<shldisA
	fcb	<shldisB
	fcb	<shldisC
	fcb	<shldisD
	fcb	<shldisE
	fcb	<shldisF
	fcb	<shpshi0	;60
	fcb	<shpshi1
	fcb	<shpshi2
	fcb	<shpshi3
	fcb	<shpshi4
	fcb	<shpshi5
	fcb	<shpshi6
	fcb	<shpshi7
	fcb	<shpshi8
	fcb	<shpshi9
	fcb	<shpshiA
	fcb	<shpshiB
	fcb	<shpshiC
	fcb	<shpshiD
	fcb	<shpshiE
	fcb	<shpshiF
	fcb	<shaddi0	;70
	fcb	<shaddi1
	fcb	<shaddi2
	fcb	<shaddi3
	fcb	<shaddi4
	fcb	<shaddi5
	fcb	<shaddi6
	fcb	<shaddi7
	fcb	<shaddi8
	fcb	<shaddi9
	fcb	<shaddiA
	fcb	<shaddiB
	fcb	<shaddiC
	fcb	<shaddiD
	fcb	<shaddiE
	fcb	<shaddiF
	fcb	<.unknown			;80
	fcb	<ldlps				;81
	fcb	<ldlpl
	fcb	<ldlss
	fcb	<ldlsl
	fcb	<stls
	fcb	<stll
	fcb	<pshls
	fcb	<pshll
	fcb	<ldips
	fcb	<ldipl
	fcb	<ldiss
	fcb	<ldisl
	fcb	<pshis
	fcb	<pshil
	fcb	<addis
	fcb	<addil			;90
	fcb	<.unknown
	fcb	<.unknown
	fcb	<.unknown
	fcb	<.unknown			;20
	fcb	<.unknown
	fcb	<.unknown
	fcb	<.unknown
	fcb	<.unknown
	fcb	<.unknown
	fcb	<.unknown
	fcb	<.unknown
	fcb	<.unknown
	fcb	<.unknown
	fcb	<.unknown
	fcb	<.unknown
	fcb	<ldlpb			;A0
	fcb	<ldlsb
	fcb	<stlb
	fcb	<pshlb
	fcb	<ldgp
	fcb	<ldgpb
	fcb	<ldgs
	fcb	<ldgsb
	fcb	<stg
	fcb	<stgb
	fcb	<pshg
	fcb	<pshgb
	fcb	<callsub
	fcb	<move
	fcb	<ssps
	fcb	<sspl
	fcb	<lds			;B0
	fcb	<sts
	fcb	<jmpflt
	fcb	<psh
	fcb	<pul
	fcb	<mult
	fcb	<div
	fcb	<.jmplng#
	fcb	<udiv
	fcb	<mod
	fcb	<umod
	fcb	<addps
	fcb	<subps
	fcb	<lshift
	fcb	<urshift
	fcb	<rshift
	fcb	<eq				;C0
	fcb	<ne
	fcb	<lt
	fcb	<le
	fcb	<gt
	fcb	<ge
	fcb	<ult				;70
	fcb	<ule
	fcb	<ugt
	fcb	<uge
	fcb	<not
	fcb	<neg
	fcb	<com
	fcb	<swap
	fcb	<.unknown
	fcb	<return
	fcb	<incr				;D0
	fcb	<decr
	fcb	<double
	fcb	<ldsb
	fcb	<stsb
	fcb	<fstswt
	fcb	<brn
	fcb	<btrue
	fcb	<bfalse
	fcb	<switch
	fcb	<andd
	fcb	<orr
	fcb	<xorr
	fcb	<callind
	fcb	<leap
	fcb	<leas
	fcb	<ldfld					;E0
	fcb	<ldfldu
	fcb	<stfld
	fcb	<brnb
	fcb	<btb				;100
	fcb	<bfb
	fcb	<brnf
	fcb	<btf
	fcb	<bff
	fcb	<calls
	fcb	<calli
	fcb	<.unknown
	fcb	<.unknown
	fcb	<.unknown
	fcb	<.unknown
	fcb	<.unknown
	fcb	<.unknown				;F0
	fcb	<.unknown
	fcb	<.unknown
	fcb	<.unknown
	fcb	<.unknown
	fcb	<.unknown
	fcb	<.unknown
	fcb	<.unknown
	fcb	<.unknown
	fcb	<.unknown
	fcb	<.unknown
	fcb	<.unknown
	fcb	<.unknown
	fcb	<.unknown
	fcb	<.unknown
	fcb	<brkpnt				;FF
*
*
*
HTAB
	fcb	>shldlp0
	fcb	>shldlp1
	fcb	>shldlp2
	fcb	>shldlp3
	fcb	>shldlp4
	fcb	>shldlp5
	fcb	>shldlp6
	fcb	>shldlp7
	fcb	>shldlp8
	fcb	>shldlp9
	fcb	>shldlpA
	fcb	>shldlpB
	fcb	>shldlpC
	fcb	>shldlpD
	fcb	>shldlpE
	fcb	>shldlpF
	fcb	>shldls0
	fcb	>shldls1
	fcb	>shldls2
	fcb	>shldls3
	fcb	>shldls4
	fcb	>shldls5
	fcb	>shldls6
	fcb	>shldls7
	fcb	>shldls8
	fcb	>shldls9
	fcb	>shldlsA
	fcb	>shldlsB
	fcb	>shldlsC
	fcb	>shldlsD
	fcb	>shldlsE
	fcb	>shldlsF
	fcb	>shstl0
	fcb	>shstl1
	fcb	>shstl2
	fcb	>shstl3
	fcb	>shstl4
	fcb	>shstl5
	fcb	>shstl6
	fcb	>shstl7
	fcb	>shstl8
	fcb	>shstl9
	fcb	>shstlA
	fcb	>shstlB
	fcb	>shstlC
	fcb	>shstlD
	fcb	>shstlE
	fcb	>shstlF
	fcb	>shpshl0
	fcb	>shpshl1
	fcb	>shpshl2
	fcb	>shpshl3
	fcb	>shpshl4
	fcb	>shpshl5
	fcb	>shpshl6
	fcb	>shpshl7
	fcb	>shpshl8
	fcb	>shpshl9
	fcb	>shpshlA
	fcb	>shpshlB
	fcb	>shpshlC
	fcb	>shpshlD
	fcb	>shpshlE
	fcb	>shpshlF
	fcb	>shldip0
	fcb	>shldip1
	fcb	>shldip2
	fcb	>shldip3
	fcb	>shldip4
	fcb	>shldip5
	fcb	>shldip6
	fcb	>shldip7
	fcb	>shldip8
	fcb	>shldip9
	fcb	>shldipA
	fcb	>shldipB
	fcb	>shldipC
	fcb	>shldipD
	fcb	>shldipE
	fcb	>shldipF
	fcb	>shldis0
	fcb	>shldis1
	fcb	>shldis2
	fcb	>shldis3
	fcb	>shldis4
	fcb	>shldis5
	fcb	>shldis6
	fcb	>shldis7
	fcb	>shldis8
	fcb	>shldis9
	fcb	>shldisA
	fcb	>shldisB
	fcb	>shldisC
	fcb	>shldisD
	fcb	>shldisE
	fcb	>shldisF
	fcb	>shpshi0
	fcb	>shpshi1
	fcb	>shpshi2
	fcb	>shpshi3
	fcb	>shpshi4
	fcb	>shpshi5
	fcb	>shpshi6
	fcb	>shpshi7
	fcb	>shpshi8
	fcb	>shpshi9
	fcb	>shpshiA
	fcb	>shpshiB
	fcb	>shpshiC
	fcb	>shpshiD
	fcb	>shpshiE
	fcb	>shpshiF
	fcb	>shaddi0
	fcb	>shaddi1
	fcb	>shaddi2
	fcb	>shaddi3
	fcb	>shaddi4
	fcb	>shaddi5
	fcb	>shaddi6
	fcb	>shaddi7
	fcb	>shaddi8
	fcb	>shaddi9
	fcb	>shaddiA
	fcb	>shaddiB
	fcb	>shaddiC
	fcb	>shaddiD
	fcb	>shaddiE
	fcb	>shaddiF
	fcb	>.unknown			;0
	fcb	>ldlps			;1
	fcb	>ldlpl
	fcb	>ldlss
	fcb	>ldlsl
	fcb	>stls
	fcb	>stll
	fcb	>pshls
	fcb	>pshll
	fcb	>ldips
	fcb	>ldipl			;10
	fcb	>ldiss
	fcb	>ldisl
	fcb	>pshis
	fcb	>pshil
	fcb	>addis
	fcb	>addil
	fcb	>.unknown
	fcb	>.unknown
	fcb	>.unknown
	fcb	>.unknown			;20
	fcb	>.unknown
	fcb	>.unknown
	fcb	>.unknown
	fcb	>.unknown
	fcb	>.unknown
	fcb	>.unknown
	fcb	>.unknown
	fcb	>.unknown
	fcb	>.unknown
	fcb	>.unknown			;30
	fcb	>.unknown			;31
	fcb	>ldlpb			;32
	fcb	>ldlsb
	fcb	>stlb
	fcb	>pshlb
	fcb	>ldgp
	fcb	>ldgpb
	fcb	>ldgs
	fcb	>ldgsb
	fcb	>stg				;40
	fcb	>stgb
	fcb	>pshg
	fcb	>pshgb
	fcb	>callsub
	fcb	>move
	fcb	>ssps
	fcb	>sspl
	fcb	>lds
	fcb	>sts
	fcb	>jmpflt
	fcb	>psh
	fcb	>pul
	fcb	>mult
	fcb	>div
	fcb	>.jmplng#
	fcb	>udiv
	fcb	>mod
	fcb	>umod
	fcb	>addps
	fcb	>subps				;60
	fcb	>lshift
	fcb	>urshift
	fcb	>rshift
	fcb	>eq
	fcb	>ne
	fcb	>lt
	fcb	>le
	fcb	>gt
	fcb	>ge
	fcb	>ult				;70
	fcb	>ule
	fcb	>ugt
	fcb	>uge
	fcb	>not
	fcb	>neg
	fcb	>com
	fcb	>swap
	fcb	>.unknown
	fcb	>return
	fcb	>incr				;80
	fcb	>decr
	fcb	>double
	fcb	>ldsb
	fcb	>stsb
	fcb	>fstswt
	fcb	>brn
	fcb	>btrue
	fcb	>bfalse
	fcb	>switch
	fcb	>andd				;90
	fcb	>orr
	fcb	>xorr
	fcb	>callind
	fcb	>leap
	fcb	>leas				;95
	fcb	>ldfld
	fcb	>ldfldu
	fcb	>stfld
	fcb	>brnb
	fcb	>btb				;100
	fcb	>bfb
	fcb	>brnf
	fcb	>btf
	fcb	>bff
	fcb	>calls
	fcb	>calli
	fcb	>.unknown
	fcb	>.unknown
	fcb	>.unknown
	fcb	>.unknown				;110
	fcb	>.unknown
	fcb	>.unknown
	fcb	>.unknown
	fcb	>.unknown
	fcb	>.unknown
	fcb	>.unknown
	fcb	>.unknown
	fcb	>.unknown
	fcb	>.unknown
	fcb	>.unknown				;120
	fcb	>.unknown
	fcb	>.unknown
	fcb	>.unknown
	fcb	>.unknown
	fcb	>.unknown
	fcb	>.unknown
	fcb	>brkpnt				;127
*
*
istack.a65
*:ts=8
*
* Copyright (C) 1983,84,85 by Manx Software Systems, Inc.
*
*	This routine copies args from the machine stack to the
*	pseudo-stack. It also makes the call to the subroutine.
*	Upon return, it pops the args back off the stack.
*
*
*	The stack looks as follows:
*
*	ARG n
*	ARG n-1
*	...
*	ARG 1
*	ARG 0
*	Return address to calling routine
*

	instxt	<zpage.h>
*
	public	.cpystk2
.cpystk2
	pla			;get pointer to in-line values
	sta	VAL
	pla
	sta	VAL+1
	sec			;drop stack pointer by appropriate amount
	ldy	#1
	lda	SP
	sbc	(VAL),Y
	sta	SP
	bcs	drop1
	dec	SP+1
drop1	lda	(VAL),Y		;save count of items
	tax
	ldy	#0		;set up to save return address
	clc
	lda	VAL
	adc	#1		;bump to skip in-line values
	sta	(SP),Y
	tya
	iny
	dex
	adc	VAL+1
	sta	(SP),Y		;save return address on pseudo-stack
	bne	drop3
drop2	pla			;get real arguments
	sta	(SP),Y		;save on pseudo-stack
drop3	iny
	dex
	bne	drop2
	lda	#>.modstk#-1	;set up to return to modstk routine
	pha
	lda	#<.modstk#-1
	pha
	lda	#0
	jmp	(R0)

lmath.a65
*:ts=8
*
* Copyright (C) 1983,84,85 by Manx Software Systems, Inc.
*
	instxt	<zpage.h>
*
T0	equ	TMP+4
T1	equ	TMP+8
*
	public	.mulx		; x * y -> a (long)
.mulx	jsr	cpyx
	pha
	sty	TMP
	sty	TMP+1
	sty	TMP+2
	sty	TMP+3
	ldy	#$20
lm1	lda	T1
	lsr	A
	bcc	lm3
	sty	VAL
	clc
	ldy	#4
	ldx	#0
lm2	lda	TMP,X
	adc	T0,X
	sta	TMP,X
	inx
	dey
	bne	lm2
	ldy	VAL
lm3	lsr	TMP+3
	ror	TMP+2
	ror	TMP+1
	ror	TMP
	ror	T1+3
	ror	T1+2
	ror	T1+1
	ror	T1
	dey
	bne	lm1
	pla
	tax
	ldy	#4
lm4	lda	T1-1,Y
	sta	3,X
	dex
	dey
	bne	lm4

restor	ldx	#11
rest1	pla
	sta	TMP,X
	dex
	bpl	rest1
	inx
	txa
	ldy	#1
	rts

	public	.udvx		; unsigned y / x -> a
.udvx	jsr	cpyx		; jd 6/16/86 - added .udvx routine
	jsr	ldv
	tax
	lda	#0
	sta	VAL
	php			
	jmp	divx1

	public	.divx		; y / x  -> a
.divx	jsr	cpyx
	jsr	ldv
	tax
	sec
	php			;jd 6/16/86 save C flag

divx1	lda	VAL
	bpl	divx2
	plp			;jd 6/16/86 get C flag from last subtract
	lda	#0
	sbc	T1,Y
	php			;jd 6/16/86 save C flag
	bvc	divx3
divx2	lda	T1,Y
divx3	sta	0,X
	inx
	iny
	cpy	#4
	bne	divx1
	plp			;jd 6/16/86 get rid of last C flag
	jmp	restor

	public	.umdx		;unsigned y % x -> a
.umdx	jsr	cpyx		;jd 6/16/86 - added .umdx routine
	jsr	ldv
	tax
	lda	#0
	sta	VAL
	php
	jmp	modx1

	public	.modx		; y % x -> a
.modx	jsr	cpyx
	jsr	ldv
	tax
	sec
	php			;jd 6/16/86 save C flag

modx1	lda	VAL+1
	bpl	modx2
	plp			;jd 6/16/86 get last C flag
	lda	#0
	sbc	TMP,Y
	php			;jd 6/16/86 save C flag
	bvc	modx3
modx2	lda	TMP,Y
modx3	sta	0,X
	inx
	iny
	cpy	#4
	bne	modx1
	plp			;jd 6/16/86 get rid of last C flag
	jmp	restor

ldv	pha
	sty	TMP
	sty	TMP+1
	sty	TMP+2
	sty	TMP+3
	lda	T1+3
	sta	VAL+1
	eor	T0+3
	sta	VAL
	lda	T0+3
	bpl	ldv2
	sec
	ldy	#4
	ldx	#0
ldv1	lda	#0
	sbc	T0,X
	sta	T0,X
	inx
	dey
	bne	ldv1
ldv2	lda	T1+3
	bpl	ldv4
	sec
	ldy	#4
	ldx	#0
ldv3	lda	#0
	sbc	T1,X
	sta	T1,X
	inx
	dey
	bne	ldv3
ldv4	ldy	#$20
ld1	asl	T1
	rol	T1+1
	rol	T1+2
	rol	T1+3
	rol	TMP
	rol	TMP+1
	rol	TMP+2
	rol	TMP+3
	sec
	lda	TMP
	sbc	T0
	pha
	lda	TMP+1
	sbc	T0+1
	pha
	lda	TMP+2
	sbc	T0+2
	tax
	lda	TMP+3
	sbc	T0+3
	bcc	ld2
	sta	TMP+3
	stx	TMP+2
	pla
	sta	TMP+1
	pla
	sta	TMP
	inc	T1
	bne	ld3
ld2	pla
	pla
ld3	dey
	bne	ld1
	pla
	rts

cpyx	
	stx	VAL
	sta	VAL+1
	tax
	pla
	sta	0,X
	pla
	sta	1,X
	ldx	#0
cpyx0	lda	TMP,X
	pha
	inx
	cpx	#12
	bne	cpyx0
	ldx	#4
cpyx1	lda	3,Y
	sta	T1-1,X
	dey
	dex
	bne	cpyx1
	ldx	VAL
	ldy	#4
cpyx2	lda	3,X
	sta	T0-1,Y
	dex
	dey
	bne	cpyx2
	ldx	VAL+1
	lda	1,X
	pha
	lda	0,X
	pha
	txa
	rts

longs.a65
*:ts=8
*
* Copyright (c) 1983,85 by Manx Software Systems, Inc.
*
	instxt	"zpage.h"
*
	public	.lngused
.lngused
	public	.jmplng
.jmplng	lda	(PC),Y
	inc	PC
	bne	jmplng1
	inc	PC+1
jmplng1	asl	A
	tax
	lda	LTAB-2,X
	sta	VAL
	lda	LTAB-1,X
	sta	VAL+1
	lda	#>mloop#-1
	pha
	lda	#<mloop#-1
	pha
	jmp	(VAL)
*

LTAB	fdb	.mulx
	fdb	.divx
	fdb	.addx
	fdb	.subx
	fdb	.negx
	fdb	.eqx
	fdb	.nex
	fdb	.ltx
	fdb	.lex
	fdb	.gtx
	fdb	.gex
	fdb	.ldlpx
	fdb	.ldlsx
	fdb	.stlx
	fdb	.pshlx
	fdb	.ldgpx
	fdb	.ldgsx
	fdb	.stgx
	fdb	.pshgx
	fdb	.pshx
	fdb	.pulx
	fdb	.ldsx
	fdb	.stsx
	fdb	.ldipx
	fdb	.ldisx
	fdb	.swapx
	fdb	.inrx
	fdb	.dcrx
	fdb	.tstx
	fdb	.modx
	fdb	.shlx
	fdb	.asrx
	fdb	.cmlx
	fdb	.ndx
	fdb	.orx
	fdb	.xorx
	fdb	.itox
	fdb	.utox
	fdb	.xtoi
	fdb	.notx
	fdb	.ultx
	fdb	.ulex
	fdb	.ugtx
	fdb	.ugex
	fdb	.shrx
	fdb	.udvx
	fdb	.umdx

*
.mulx	sty	R2
	sty	R2+1
	sty	R2+2
	sty	R2+3
	ldy	#$20
.lm1	lda	R0
	lsr	A
	bcc	.lm3
	clc
	ldx	#-4
.lm2	lda	R2+4,X
	adc	R1+4,X
	sta	R2+4,X
	inx
	bne	.lm2
.lm3	lsr	R2+3
	ror	R2+2
	ror	R2+1
	ror	R2
	ror	R0+3
	ror	R0+2
	ror	R0+1
	ror	R0
	dey
	bne	.lm1
	rts
*
.divx	jsr	.ldv		;divide primary by secondary (long)
	lda	TMP
	bpl	.divx1
	jmp	.negx
.divx1	rts
*
.udvx	jmp	.ldv3		;divide primary by secondary (unsigned long)
*
.ldv	lda	R0+3
	sta	TMP+1
	eor	R1+3
	sta	TMP
	lda	R0+3
	bpl	.ldv1
	jsr	.negx
.ldv1	lda	R1+3
	bpl	.ldv3
	ldx	#-4
.ldv2	lda	#0
	sbc	R1+4,X
	sta	R1+4,X
	inx
	bne	.ldv2
.ldv3	lda	#0
	sta	R2
	sta	R2+1
	sta	R2+2
	sta	R2+3
	ldy	#$20
.ld1	asl	R0
	rol	R0+1
	rol	R0+2
	rol	R0+3
	rol	R2
	rol	R2+1
	rol	R2+2
	rol	R2+3
	sec
	lda	R2
	sbc	R1
	sta	VAL
	lda	R2+1
	sbc	R1+1
	sta	VAL+1
	lda	R2+2
	sbc	R1+2
	tax
	lda	R2+3
	sbc	R1+3
	bcc	.ld2
	stx	R2+2
	sta	R2+3
	lda	VAL
	sta	R2
	lda	VAL+1
	sta	R2+1
	inc	R0
.ld2	dey
	bne	.ld1
	rts
*
.umdx	jsr	.ldv3		;modulo primary by secondary (unsigned long)
	sty	TMP+1
	ldx	#3
	bne	modx1
*
.modx	jsr	.ldv		;modulo primary by secondary (long)
	ldx	#3
modx1	lda	R2,X
	sta	R0,X
	dex
	bpl	modx1
	lda	TMP+1
	bmi	modx2
	rts
modx2	jmp	.negx
*
.addx	clc			;add primary and secondary (long)
	ldx	#-4
addx1	lda	R0+4,X
	adc	R1+4,X
	sta	R0+4,X
	inx
	bne	addx1
	rts
*
.subx	sec			;subtract secondary from primary (long)
	ldx	#-4
subx1	lda	R0+4,X
	sbc	R1+4,X
	sta	R0+4,X
	inx
	bne	subx1
	rts
*
.shlx	clc			;shift R0 left R1 times (long)
	ldy	#-1
	ldx	#-4
shlx1	tya
	adc	R1+4,X
	sta	R1+4,X
	inx
	bne	shlx1
	tax
	bpl	shlx2
	rts
shlx2	asl	R0
	rol	R0+1
	rol	R0+2
	rol	R0+3
	jmp	.shlx
*
.asrx	clc			;rotate R0 right R1 times (long)
	lda	R0+3
	bpl	asrx1
	sec
asrx1	php
asrx2	clc
	ldy	#-1
	ldx	#-4
asrx3	tya
	adc	R1+4,X
	sta	R1+4,X
	inx
	bne	asrx3
	tax
	bpl	asrx4
	plp
	rts
asrx4	plp
	php
	ror	R0+3
	ror	R0+2
	ror	R0+1
	ror	R0
	jmp	asrx2
*
.shrx	clc			;shift R0 right R1 times (unsigned long)
	ldy	#-1
	ldx	#-4
shrx1	tya
	adc	R1+4,X
	sta	R1+4,X
	inx
	bne	shrx1
	tax
	bpl	shrx2
	rts
shrx2	lsr	R0+3
	ror	R0+2
	ror	R0+1
	ror	R0
	jmp	.shrx
*
.cmlx	ldx	#3		;complement the primary (long)
cmlx1	lda	R0,X
	eor	#$FF
	sta	R0,X
	dex
	bpl	cmlx1
	rts
*
.ndx	ldx	#3		;and primary and secondary (long)
ndx1	lda	R0,X
	and	R1,X
	sta	R0,X
	dex
	bpl	ndx1
	rts
*
.orx	ldx	#3		;or primary and secondary (long)
orx1	lda	R0,X
	ora	R1,X
	sta	R0,X
	dex
	bpl	orx1
	rts
*
.xorx	ldx	#3		;xor primary and secondary (long)
xorx1	lda	R0,X
	eor	R1,X
	sta	R0,X
	dex
	bpl	xorx1
	rts
*
.negx	sec			;negate primary (long)
	ldx	#-4
negx1	tya
	sbc	R0+4,X
	sta	R0+4,X
	inx
	bne	negx1
	rts
*
.notx	jsr	.tstx		;logical not (long)
	lda	R0
	eor	#1		;reverse sense
	rts
*
.tstx	ldx	#3		;test primary against 0
tstx1	lda	R0,X
	bne	.true
	dex
	bpl	tstx1
	bmi	.false
*
.eqx	ldx	#3		;primary == secondary (long)
eqx1	lda	R0,X
	cmp	R1,X
	bne	.false
	dex
	bpl	eqx1
.true	sty	R0+1
	iny
	sty	R0
	rts
*
.nex	ldx	#3		;primary != secondary (long)
nex1	lda	R0,X
	cmp	R1,X
	bne	.true
	dex
	bpl	nex1
.false	sty	R0+1
	sty	R0
	rts
*
.ltx	jsr	r0r1		;primary < secondary (long)
	bpl	.ltx1
	iny
.ltx1	tya
	bvc	.ltx2
	eor	#1
.ltx2	sta	R0
	rts
*
.ultx	jsr	r0r1		;primary < secondary (unsigned long)
	bcs	.ultx1
	iny
.ultx1	sty	R0
	rts
*
.gtx	jsr	r1r0		;primary > secondary (long)
	bpl	.gtx1
	iny
.gtx1	tya
	bvc	.gtx2
	eor	#1
.gtx2	sta	R0
	rts
*
.ugtx	jsr	r1r0		;primary > secondary (unsigned long)
	bcs	.ugtx1
	iny
.ugtx1	sty	R0
	rts
*
.lex	jsr	r1r0		;primary <= secondary (long)
	bmi	.lex1
	iny
.lex1	tya
	bvc	.lex2
	eor	#1
.lex2	sta	R0
	rts
*
.ulex	jsr	r1r0		;primary <= secondary (unsigned long)
	bcc	.ulex1
	iny
.ulex1	sty	R0
	rts
*
.gex	jsr	r0r1		;primary >= secondary (long)
	bmi	.gex1
	iny
.gex1	tya
	bvc	.gex2
	eor	#1
.gex2	sta	R0
	rts
*
.ugex	jsr	r0r1		;primary >= secondary (unsigned long)
	bcc	.ugex1
	iny
.ugex1	sty	R0
	rts
*
r0r1	lda	R0		;compare primary and secondary (long)
	cmp	R1
	lda	R0+1
	sbc	R1+1
	sty	R0+1
	lda	R0+2
	sbc	R1+2
	lda	R0+3
	sbc	R1+3
	rts
*
r1r0	lda	R1		;compare secondary and primary (long)
	cmp	R0
	lda	R1+1
	sbc	R0+1
	sty	R0+1
	lda	R1+2
	sbc	R0+2
	lda	R1+3
	sbc	R0+3
	rts
*
.itox	lda	R0+1		;cast integer to long
	bpl	.utox
	ldy	#-1
.utox	sty	R0+2		;cast unsigned to long
	sty	R0+3
.xtoi	rts			;cast long to integer
*
*
.ldipx	lda	(PC),Y		;load primary immediate (long)
	sta	R0,Y
	iny
	cpy	#4
	bne	.ldipx
	beq	ldisx1
*
.ldisx	lda	(PC),Y		;load secondary immediate (long)
	sta	R1,Y
	iny
	cpy	#4
	bne	.ldisx
ldisx1	lda	PC
	adc	#3
	sta	PC
	bcc	ldisx3
	inc	PC+1
ldisx3	rts
*
.dcrx	ldy	#-1		; decrement primary (long)
	tya
	bne	inrx1
*
.inrx	lda	#1		;increment primary (long)
inrx1	clc
	ldx	#1
	adc	R0
	sta	R0
	ror	A			;save carry
inrx2	rol	A		;get carry back
	tya
	adc	R0,X
	sta	R0,X
	ror	A			;save carry
	inx
	cpx	#4
	bne	inrx2
	rts
*
.stsx	jsr	pul0#		;store primary through secondary (long)
	ldy	#3
stsx1	lda	R0,Y
	sta	(R1),Y
	dey
	bpl	stsx1
	rts
*
.swapx	ldx	#3		; swap primary and secondary (long)
swapx1	lda	R0,X
	ldy	R1,X
	sta	R1,X
	sty	R0,X
	dex
	bpl	swapx1
	rts
*
.ldlpx	jsr	twolcl#		;load local into primary (long)
ldpx	ldy	#3
ldpx1	lda	(VAL),Y
	sta	R0,Y
	dey
	bpl	ldpx1
	rts
*
.ldlsx	jsr	twolcl#		;load local into secondary (long)
ldlsx1	ldy	#3
ldlsx2	lda	(VAL),Y
	sta	R1,Y
	dey
	bpl	ldlsx2
	rts
*
.stlx	jsr	twolcl#		;store local from primary (long)
stpx	ldy	#3
stpx1	lda	R0,Y
	sta	(VAL),Y
	dey
	bpl	stpx1
	rts
*
.pshlx	jsr	twolcl#		;psh local (long)
	bcc	pshgx1
*
.ldgpx	jsr	twoval#		;load global into primary (long)
	bcc	ldpx
*
.ldgsx	jsr	twoval#		;load global into secondary (long)
	bcc	ldlsx1
*
.stgx	jsr	twoval#		;store global from primary (long)
	bcc	stpx
*
.pshgx	jsr	twoval#		;push global (long)
pshgx1	sec
	lda	SP
	sbc	#4
	sta	SP
	bcs	pshgx2
	dec	SP+1
pshgx2	ldy	#3
pshgx3	lda	(VAL),Y
	sta	(SP),Y
	dey
	bpl	pshgx3
	rts
*
.pshx	lda	#<R0		;push primary onto stack (long)
	sta	VAL
	sty	VAL+1
	jmp	pshgx1
*
.pulx	ldy	#3		;pull secondary from stack
pulx1	lda	(SP),Y
	sta	R1,Y
	dey
	bpl	pulx1
	clc
	lda	SP
	adc	#4
	sta	SP
	bcc	pulx2
	inc	SP+1
pulx2	rts
*
.ldsx	lda	R0		;load primary through primary (long)
	sta	VAL
	lda	R0+1
	sta	VAL+1
	jmp	ldpx
*
*
	cseg
lshift.a65
*:ts=8
*
* Copyright (C) 1983,84,85 by Manx Software Systems, Inc.
*
	instxt	<zpage.h>
*
	public	.shlx
.shlx	jsr	copy		;y << x -> a (long)
	tya
	beq	shl2
shl1	asl	0,X
	rol	1,X
	rol	2,X
	rol	3,X
	dey
	bne	shl1
	tya
shl2	tax
	iny
	rts

	public	.asrx
.asrx	jsr	copy		;y >> x -> a
	bpl	lsr1
	tya
	beq	asr2
asr1	sec
	ror	3,X
	ror	2,X
	ror	1,X
	ror	0,X
	dey
	bne	asr1
	tya
asr2	tax
	iny
	rts

	public	.lsrx
.lsrx	jsr	copy		;y >> x -> a
lsr1	tya
	beq	lsr3
lsr2	lsr	3,X
	ror	2,X
	ror	1,X
	ror	0,X
	dey
	bne	lsr2
	tya
lsr3	tax
	iny
	rts

copy	stx	VAL
	tax
	lda	0,Y
	sta	0,X
	lda	1,Y
	sta	1,X
	lda	2,Y
	sta	2,X
	lda	3,Y
	sta	3,X
	php
	ldy	VAL
	lda	1,Y
	ora	2,Y
	ora	3,Y
	beq	copy1
	ldy	#32
	plp
	rts
copy1	lda	0,Y
	tay
	plp
	rts

math.a65
*:ts=8
*
* Copyright (C) 1983,84,85 by Manx Software Systems, Inc.
*
	instxt	<zpage.h>
*
T0	equ	TMP+2
T1	equ	TMP+4
*
	public	.mul		; x * y -> a
.mul	jsr	cpyx
	pha
	sty	TMP
	sty	TMP+1
	ldy	#16
lm1	lda	T1
	lsr	A
	bcc	lm2
	clc
	lda	TMP
	adc	T0
	sta	TMP
	lda	TMP+1
	adc	T0+1
	sta	TMP+1
lm2	lsr	TMP+1
	ror	TMP
	ror	T1+1
	ror	T1
	dey
	bne	lm1
	pla
	tax
	lda	T1
	sta	0,X
	lda	T1+1
	sta	1,X

restor	ldx	#5		;put back the six bytes we saved
rest1	pla
	sta	TMP,X
	dex
	bpl	rest1
	inx			;set registers
	txa
	ldy	#1
	rts			;and return

	public	.div		; y / x  -> a
.div	jsr	cpyx
	jsr	ldv
	tax
	sec
	php			;jd 6/16/86

divx1	lda	VAL
	bpl	divx2
	plp			;jd 6/16/86 get C flag from last subtract
	lda	#0
	sbc	T1,Y
	php			;jd 6/16/86 save C flag of this subtract
	bvc	divx3
divx2	lda	T1,Y
divx3	sta	0,X
	inx
	iny
	cpy	#2
	bne	divx1
	plp			;jd 6/16/86 get rid of last saved flags byte
	jmp	restor

	public	.udv		; y / x  -> a
.udv	jsr	cpyx
	jsr	uldv
	tax
	lda	T1
	sta	0,X
	lda	T1+1
	sta	1,X
	jmp	restor

	public	.umd		; y % x -> a
.umd	jsr	cpyx
	jsr	uldv
	tax
	lda	TMP
	sta	0,X
	lda	TMP+1
	sta	1,X
	jmp	restor


	public	.mod		; y % x -> a
.mod	jsr	cpyx
	jsr	ldv
	tax
	sec
	php			;jd 6/16/86

modx1	lda	VAL+1
	bpl	modx2
	plp			;jd 6/16/86 get C flag from last subtract
	lda	#0
	sbc	TMP,Y
	php			;jd 6/16/86 save C flag
	bvc	modx3
modx2	lda	TMP,Y
modx3	sta	0,X
	inx
	iny
	cpy	#2
	bne	modx1
	plp			;jd 6/16/86 get rid of saved flags
	jmp	restor

uldv	pha			;save result pointer
	jmp	ldv2

ldv	pha
	lda	T1+1
	sta	VAL+1
	eor	T0+1
	sta	VAL
	lda	T0+1
	bpl	ldv1
	sec
	tya
	sbc	T0
	sta	T0
	tya
	sbc	T0+1
	sta	T0+1
ldv1	lda	T1+1
	bpl	ldv2
	sec
	tya
	sbc	T1
	sta	T1
	tya
	sbc	T1+1
	sta	T1+1

ldv2	ldy	#0		;init TMP to 0
	sty	TMP
	sty	TMP+1
	ldy	#16		;do 16 bit divide
ld1	asl	T1
	rol	T1+1
	rol	TMP
	rol	TMP+1
	sec
	lda	TMP
	sbc	T0
	tax
	lda	TMP+1
	sbc	T0+1
	bcc	ld2
	sta	TMP+1
	stx	TMP
	inc	T1
ld2	dey
	bne	ld1
	pla			;restore pointer to result
	rts

	dseg
ret	rmb	2		;place to save return for a moment

	cseg
;	save registers and set up for operations
cpyx	
	stx	VAL
	sta	VAL+1
	pla
	sta	ret
	pla
	sta	ret+1	;save the return address
	ldx	#0
cpyx0	lda	TMP,X	;save six bytes of temporary space
	pha
	inx
	cpx	#6
	bne	cpyx0
	lda	0,Y	;copy Y value to T1
	sta	T1
	lda	1,Y
	sta	T1+1
	ldx	VAL	;copy X value to T0
	lda	0,X
	sta	T0
	lda	1,X
	sta	T0+1
	lda	ret+1	;put back return address
	pha
	lda	ret
	pha
	lda	VAL+1	;get back result pointer
	ldy	#0
	rts		;and return

move.a65
*:ts=8
*
* Copyright (C) 1983,84,85 by Manx Software Systems, Inc.
*
	instxt	<zpage.h>
*
	public	.move
.move	stx	VAL		;move size bytes from R1 to R0
	ldy	#0
	tax
	bne	move1
move0	dec	VAL
	bpl	move1
	ldx	#0
	ldy	#1
	rts
move1	lda	(R1),Y
	sta	(R0),Y
	iny
	bne	move2
	inc	R0+1
	inc	R1+1
move2	dex
	beq	move0
	bne	move1
*
movmem.a65
*:ts=8
*
* Copyright (C) 1985 by Manx Software Systems, Inc.
*
	instxt	<zpage.h>
*
*	void
*	movmem(src, dst, n)
*	  char *src, *dst;
*	  int n;
*
*	move n chars from src to dst
*

SRC	equ	R0+2
DST	equ	R0+4
N	equ	R0+6

	public	movmem_
movmem_
	ldy	#7		;copy the params to zero page
block1	lda	(SP),Y
	sta	R0,Y
	dey
	bpl	block1
	iny
	lda	SRC
	cmp	DST
	lda	SRC+1
	sbc	DST+1
	bcs	forw		;if src >= dst copy from beginning

	clc
	lda	SRC
	adc	N
	sta	SRC
	lda	SRC+1
	adc	N+1
	sta	SRC+1
	clc
	lda	DST
	adc	N
	sta	DST
	lda	DST+1
	adc	N+1
	sta	DST+1
	ldx	N
	beq	rvrs3
rvrs1	tya
	bne	rvrs2
	dec	SRC+1
	dec	DST+1
rvrs2	dey
	lda	(SRC),Y
	sta	(DST),Y
	dex
	bne	rvrs1
rvrs3	dec	N+1
	bpl	rvrs1
	rts

forw	ldx	N
	beq	forw3
forw1	lda	(SRC),Y
	sta	(DST),Y
	iny
	bne	forw2
	inc	SRC+1
	inc	DST+1
forw2	dex
	bne	forw1
forw3	dec	N+1
	bpl	forw1
	rts
*
rindex.a65
*:ts=8
*
* Copyright (C) 1985 by Manx Software Systems, Inc.
*
	instxt	<zpage.h>
*
*	char *
*	rindex(str, c)
*	  char *str;
*	  int c;
*
*	returns a pointer to the last occurrence of c in str
*

STR	equ	R0+2
C	equ	R0+4

	public	rindex_
rindex_
	ldy	#4
load	lda	(SP),Y		;copy params into registers
	sta	R0,Y
	dey
	bne	load
	sty	R0		;init return to 0
	sty	R0+1
loop	lda	(STR),Y		;get next char
	beq	end		;if zero, all done
	cmp	C		;is it the one we want?
	bne	next		;no, skip

	clc			;yes, set return to address
	tya
	adc	STR
	sta	R0
	lda	#0
	adc	STR+1
	sta	R0+1

next	iny			;bump to next char
	bne	loop
	inc	STR+1
	bne	loop

end	rts			;return, if found address already set

strrchr.a65
*:ts=8
*
* Copyright (C) 1985 by Manx Software Systems, Inc.
*
	instxt	<zpage.h>
*
*	char *
*	strrchr(str, c)
*	  char *str;
*	  int c;
*
*	returns a pointer to the last occurrence of c in str
*

STR	equ	R0+2
C	equ	R0+4

	public	strrchr_
strrchr_
	ldy	#4
load	lda	(SP),Y		;copy params into registers
	sta	R0,Y
	dey
	bne	load
	sty	R0		;init return to 0
	sty	R0+1
loop	lda	(STR),Y		;get next char
	cmp	C		;is it the one we want?
	bne	next		;no, skip

	pha
	clc			;yes, set return to address
	tya
	adc	STR
	sta	R0
	lda	#0
	adc	STR+1
	sta	R0+1
	pla

next
	cmp	#0
	beq	end		;if zero, all done
	iny			;bump to next char
	bne	loop
	inc	STR+1
	bne	loop

end	rts			;return, if found address already set

setjmp.a65
; Copyright (C) 1985 by Manx Software Systems, Inc.
; :ts=8
;
	instxt	<zpage.h>

	public setjmp_
setjmp_
	clc
	pla				;save real return address
	adc	#1
	sta	R0
	sta	VAL
	pla
	bcc	set0
	adc	#1
set0
	sta	R0+1
	sta	VAL+1
	ldy	#3
set1	lda	(SP),Y			;save fake return and buf ptr
	sta	R0+2,Y
	dey
	bpl	set1
	ldy	#25			;save frame stuff and returns
	ldx	#9
set2	lda	SP,X
	sta	(R1),Y
	dey
	dex
	bpl	set2
	ldy	#15
set3	lda	REGS,Y			;save register variables
	sta	(R1),Y
	dey
	bpl	set3
	lda	#0
	sta	R0
	sta	R0+1
	jmp	(VAL)			;and return

;
	public	longjmp_
longjmp_
	pla				;discard return address
	pla
	ldy	#5
long1	lda	(SP),Y			;get buf pointer and return value
	sta	R0+2,Y
	dey
	bpl	long1
	ldy	#25
	ldx	#9
long2	lda	(R1),Y			;get frame and returns
	sta	SP,X
	dey
	dex
	bpl	long2
long3	lda	(R1),Y			;get registers back
	sta	REGS,Y
	dey
	bpl	long3
	iny
	lda	R0+2			;set fake return
	sta	(SP),Y
	iny
	lda	R0+3
	sta	(SP),Y
	lda	R0			;swap return address and return value
	ldy	R1+2
	sta	R1+2
	sty	R0
	lda	R0+1
	ldy	R1+3
	sta	R1+3
	sty	R0+1
	jmp	(R1+2)			;and return
;
setmem.a65
*:ts=8
*
* Copyright (C) 1985 by Manx Software Systems, Inc.
*
	instxt	<zpage.h>
*
*	void
*	setmem(start, len, value);
*	  char *start;
*	  int len, value;
*
*	set memory block to a fixed value
*

START	equ	R0+2
CNT	equ	R0+4
VALUE	equ	R0+6

	public	setmem_
setmem_	ldy	#6		;copy params to zero page
load	lda	(SP),Y
	sta	R0,Y
	dey
	bpl	load
	iny
	lda	VALUE
	ldx	CNT
	beq	skip2
loop	sta	(START),Y
	iny
	bne	skip
	inc	START+1
skip	dex
	bne	loop
skip2	dec	CNT+1
	bpl	loop
	rts

shift.a65
*:ts=8
*
* Copyright (C) 1983,84,85 by Manx Software Systems, Inc.
*
	instxt	<zpage.h>
*
	public	.shl
.shl	jsr	copy		;y << x -> a
	tya
	beq	shl2
shl1	asl	0,X
	rol	1,X
	dey
	bne	shl1
	tya
shl2	tax
	iny
	rts

	public	.asr
.asr	jsr	copy		;y >> x -> a
	bpl	lsr1
	tya
	beq	asr2
asr1	sec
	ror	1,X
	ror	0,X
	dey
	bne	asr1
	tya
asr2	tax
	iny
	rts

	public	.lsr
.lsr	jsr	copy		;y >> x -> a
lsr1	tya
	beq	lsr3
lsr2	lsr	1,X
	ror	0,X
	dey
	bne	lsr2
	tya
lsr3	tax
	iny
	rts

copy	stx	VAL
	tax
	lda	0,Y
	sta	0,X
	lda	1,Y
	sta	1,X
	php
	ldy	VAL
	lda	1,Y
	beq	copy1
	ldy	#16
	plp
	rts
copy1	lda	0,Y
	tay
	plp
	rts

stack.a65
*:ts=8
*
* Copyright (C) 1983,84,85 by Manx Software Systems, Inc.
*
*	This routine copys args from the machine stack to the
*	pseudo-stack. It also makes the call to the subroutine.
*	Upon return, it pops the args back off the stack.
*
*
*	The stack looks as follows:
*
*	ARG n
*	ARG n-1
*	...
*	ARG 1
*	ARG 0
*	Return address to calling routine
*

	instxt	<zpage.h>
*
	public	.cpystk
.cpystk	pla			;get pointer to in-line values
	sta	VAL
	pla
	sta	VAL+1
	sec			;drop stack pointer by appropriate amount
	ldy	#3
	lda	SP
	sbc	(VAL),Y
	sta	SP
	bcs	drop1
	dec	SP+1
drop1	lda	(VAL),Y		;save count of items
	tax
	ldy	#0		;set up to save return address
	clc
	lda	VAL
	adc	#3		;bump to skip in-line values
	sta	(SP),Y
	tya
	iny
	dex
	adc	VAL+1
	sta	(SP),Y		;save return address on pseudo-stack
	bne	drop3
drop2	pla			;get real arguments
	sta	(SP),Y		;save on pseudo-stack
drop3	iny
	dex
	bne	drop2
	ldy	#1		;get address of functions to call
	lda	(VAL),Y
	sta	R0
	iny
	lda	(VAL),Y
	sta	R0+1
	jsr	indjmp		;call the function
*
	public	.modstk
.modstk	ldy	#1
getbak	lda	(SP),Y		;get back return address
	sta	VAL,Y
	pha
	dey
	bpl	getbak
	clc
	iny
	lda	SP		;discard arguments and return address
	adc	(VAL),Y
	sta	SP
	bcc	mod1
	inc	SP+1
mod1	lda	#0		;set up registers
	tax
	ldy	#1
	rts			;and return
*
indjmp	jmp	(R0)
*

strcat.a65
*:ts=8
*
* Copyright (C) 1985 by Manx Software Systems, Inc.
*
	instxt	<zpage.h>
*
*	char *
*	strcat(s1, s2)
*	  char *s1, *s2;
*
*	concatenate chars from s2 onto s1
*

S1	equ	R0+2
S2	equ	R0+4

	public	strcat_
strcat_
	ldy	#5		;copy args to regs
load	lda	(SP),Y
	sta	R0,Y
	dey
	bne	load
	lda	R0+2		;copy s1 for return
	sta	R0
	lda	R0+3
	sta	R0+1
loop	lda	(S1),Y		;get char
	beq	eloop		;got to end
	iny
	bne	loop
	inc	S1+1
	bne	loop

eloop	clc
	tya			;now update s1 to end of string
	adc	S1
	sta	S1
	bcc	skip
	inc	S1+1
skip	ldy	#0
copy	lda	(S2),Y		;get char from s2
	sta	(S1),Y		;copy to s1
	beq	done		;null byte, all done
	iny
	bne	copy
	inc	S1+1
	inc	S2+1
	bne	copy

done	rts			;all done

strcmp.a65
*:ts=8
*
* Copyright (C) 1983,84,85 by Manx Software Systems, Inc.
*
	instxt	<zpage.h>
*
*	int
*	strcmp(s1, s2)
*	  char *s1, *s2;
*
*	compare str1 with str2
*

S1	equ	R0+2
S2	equ	R0+4

	public	strcmp_
strcmp_
	ldy	#5
load	lda	(SP),Y		;copy args to registers
	sta	R0,Y
	dey
	bne	load
	beq	skip
mainlp	iny			;main loop
	bne	skip
	inc	S1+1
	inc	S2+1
skip	lda	(S1),Y		;get next char from s1
	bne	compare		;non-zero, go compare it
	lda	(S2),Y		;check if both zero
	bne	less		;no, must be less

equal	ldy	#0		;equal case
	beq	done
less	ldy	#-1		;return -1
done	sty	R0
	sty	R0+1
	rts

compare	cmp	(S2),Y		;compare to other string
	beq	mainlp		;same, continue
	bcc	less		;less, return it
	ldy	#0		;else must be greater
	sty	R0+1
	iny			;return 1
	sty	R0
	rts

strcpy.a65
*:ts=8
*
* Copyright (C) 1983,84,85 by Manx Software Systems, Inc.
*

	instxt	<zpage.h>

*
*	char *
*	strcpy(s1, s2)
*	  char *s1, *s2;
*
*	copy str2 to str1
*

S1	equ	R0+2
S2	equ	R0+4

	public	strcpy_
strcpy_
	ldy	#5
load	lda	(SP),Y		;copy args to registers
	sta	R0,Y
	dey
	bne	load
	lda	S1		;copy address of s1 for return
	sta	R0
	lda	S1+1
	sta	R0+1
loop	lda	(S2),Y		;get byte from s2
	sta	(S1),Y		;copy to s1
	beq	done		;if null, end of string
	iny
	bne	loop
	inc	S1+1
	inc	S2+1
	bne	loop
done	rts

strequ.a65
*:ts=8
*
* Copyright (C) 1985 by Manx Software Systems, Inc.
*
	instxt	<zpage.h>
*
*	int
*	strequ(s1, s2)
*	  char *s1, *s2;
*
*	compare str1 with str2 regardless of case
*

S1	equ	R0+2
S2	equ	R0+4

	public	strequ_
strequ_
	ldy	#5
load	lda	(SP),Y		;copy args to registers
	sta	R0,Y
	dey
	bne	load
	beq	skip
mainlp	iny			;main loop
	bne	skip
	inc	S1+1
	inc	S2+1
skip	lda	(S1),Y		;get next char from s1
	bne	compare		;non-zero, go compare it
	lda	(S2),Y		;check if both zero
	bne	less		;no, must be less

equal	ldy	#0		;equal case
	beq	done
less	ldy	#-1		;return -1
done	sty	R0
	sty	R0+1
	rts

compare	cmp	#'A		;compare to A
	bcc	comp1
	cmp	#'Z+1
	bcs	comp1
	adc	#'a-'A
comp1	sta	R0
	lda	(S2),Y		;compare to other string
	cmp	#'A		;compare to A
	bcc	comp2
	cmp	#'Z+1
	bcs	comp2
	adc	#'a-'A
comp2	cmp	R0
	beq	mainlp		;same, continue
	bcs	less		;less, return it
	ldy	#0		;else must be greater
	sty	R0+1
	iny			;return 1
	sty	R0
	rts

strlen.a65
*:ts=8
*
* Copyright (C) 1983,84,85 by Manx Software Systems, Inc.
*

	instxt	<zpage.h>

*
*	int
*	strlen(str)
*	  char *str;
*
*	number of non-null characters
*

STR	equ	R0+2

	public	strlen_
strlen_
	ldy	#2		;copy args to registers
	lda	(SP),Y
	sta	STR
	iny
	lda	(SP),Y
	sta	STR+1
	ldy	#0
	sty	R0+1		;init high byte of len to zero

loop	lda	(STR),Y		;get byte
	beq	done		;if null, done
	iny			;bump to next
	bne	loop
	inc	STR+1		;crossed 256 byte boundary
	inc	R0+1		;so bump high byte of count too
	bne	loop

done	sty	R0		;save low byte of count
	rts

strncat.a65
*:ts=8
*
* Copyright (C) 1985 by Manx Software Systems, Inc.
*
	instxt	<zpage.h>
*
*	char *
*	strncat(s1, s2, n)
*	  char *s1, *s2;
*
*	concatenate at most n chars from s2 onto s1
*

S1	equ	R0+2
S2	equ	R0+4
N	equ	R0+6

	public	strncat_
strncat_
	ldy	#7		;copy args to regs
load	lda	(SP),Y
	sta	R0,Y
	dey
	bne	load
	lda	R0+2		;copy s1 for return
	sta	R0
	lda	R0+3
	sta	R0+1
loop	lda	(S1),Y		;get char
	beq	eloop		;got to end
	iny
	bne	loop
	inc	S1+1
	bne	loop

eloop	clc
	tya			;now update s1 to end of string
	adc	S1
	sta	S1
	bcc	skip
	inc	S1+1
skip	ldy	#0
	ldx	N
	beq	decN
copy	lda	(S2),Y		;get char from s2
	sta	(S1),Y		;copy to s1
	beq	done		;null byte, all done
	iny
	bne	decX
	inc	S1+1
	inc	S2+1
decX	dex
	bne	copy
decN	dec	N+1
	bpl	copy

done	lda	#0		;null terminate
	sta	(S1),Y
	rts			;all done

strncmp.a65
*:ts=8
*
* Copyright (C) 1983,84,85 by Manx Software Systems, Inc.
*
	instxt	<zpage.h>
*
*	int
*	strncmp(s1, s2, n)
*	  char *s1, *s2;
*	  int n;
*
*	compare at most n chars of str1 with str2
*

S1	equ	R0+2
S2	equ	R0+4
N	equ	R0+6

	public	strncmp_
strncmp_
	ldy	#7
load	lda	(SP),Y		;copy args to registers
	sta	R0,Y
	dey
	bne	load
	ldx	N
	beq	decN
	bne	skip
mainlp	dex			;main loop
	bne	ndec
decN	dec	N+1
	bmi	equal		;end of N, must be equal
ndec	iny
	bne	skip
	inc	S1+1
	inc	S2+1
skip	lda	(S1),Y		;get next char from s1
	bne	compare		;non-zero, go compare it
	lda	(S2),Y		;check if both zero
	bne	less		;no, must be less

equal	ldy	#0		;equal case
	beq	done
less	ldy	#-1		;return -1
done	sty	R0
	sty	R0+1
	rts

compare	cmp	(S2),Y		;compare to other string
	beq	mainlp		;same, continue
	bcc	less		;less, return it
	ldy	#0		;else must be greater
	sty	R0+1
	iny			;return 1
	sty	R0
	rts

strncpy.a65
*:ts=8
*
* Copyright (C) 1983,84,85 by Manx Software Systems, Inc.
*

	instxt	<zpage.h>

*
*	char *
*	strncpy(s1, s2, n)
*	  char *s1, *s2;
*	  int n;
*
*	copy at most n chars from s2 to s1
*

S1	equ	R0+2
S2	equ	R0+4
N	equ	R0+6

	public	strncpy_
strncpy_
	ldy	#7
load	lda	(SP),Y		;copy args to registers
	sta	R0,Y
	dey
	bne	load

	lda	S1		;copy address of s1 for return
	sta	R0
	lda	S1+1
	sta	R0+1

	ldx	N		;get N in X for count
	beq	decN		;zero, dec the high part
loop	lda	(S2),Y		;get byte from s2
	sta	(S1),Y		;copy to s1
	beq	done		;if null, end of string
	iny
	bne	decX
	inc	S1+1
	inc	S2+1
decX	dex
	bne	loop
decN	dec	N+1		;dec high byte
	bpl	loop		;more to do

done	txa			;check count
	beq	decN2		;skip to dec
fill	lda	#0		;get a null byte
	sta	(S1),Y		;null pad the field
	iny
	bne	decX2
	inc	S1+1
decX2	dex
	bne	fill
decN2	dec	N+1
	bpl	fill
	rts

sup.a65
*:ts=8
*
* Copyright (C) 1983,84,85 by Manx Software Systems, Inc.
*
	instxt	<zpage.h>
*
	public	.csav
.csav	pla			;put return addr in R0
	sta	R0
	pla
	sta	R0+1
	clc
	pla
	adc	#1
	sta	VAL
	pla
	adc	#0
	sta	VAL+1
	ldy	#7		;save old SP and old FRAME
	sec
	lda	SP		;drop SP by frame size
	sbc	#9
	sta	R1		;and save temporarily in R1
	lda	SP+1
	sbc	#0
	sta	R1+1
csav1	lda	VAL,Y
	sta	(R1),Y
	dey
	bpl	csav1
	ldy	#1
	sec
	lda	R1		;drop SP by register size
	sta	AFRAME		;move to AFRAME first
	sbc	(R0),Y
	sta	LFRAME
	lda	R1+1
	sta	AFRAME+1
	sbc	#0
	sta	LFRAME+1
	lda	(R0),Y
	ldy	#8
	sta	(AFRAME),Y
	tay
	beq	csav3
	dey
csav2	lda	REGS,Y
	sta	(LFRAME),Y
	dey
	bpl	csav2
csav3	ldy	#2		;now adjust SP for locals
	clc
	lda	LFRAME
	adc	(R0),Y
	sta	SP
	iny
	lda	LFRAME+1
	adc	(R0),Y
	sta	SP+1
	dec	LFRAME+1
	clc
	lda	R0
	adc	#4
	sta	R0
	bcc	csav4
	inc	R0+1
csav4	lda	#>.cret-1
	pha
	lda	#<.cret-1
	pha
	lda	#0
	tax
	ldy	#1
	jmp	(R0)
*
	public	.cret
.cret	inc	LFRAME+1
	ldy	#8
	lda	(AFRAME),Y
	tay
	beq	cret2
	dey
cret1	lda	(LFRAME),Y
	sta	REGS,Y
	dey
	bpl	cret1
cret2	lda	AFRAME
	sta	R1
	lda	AFRAME+1
	sta	R1+1
	ldy	#7
cret3	lda	(R1),Y
	sta	VAL,Y
	dey
	bpl	cret3
	jmp	(VAL)
*
swapmem.a65
*:ts=8
*
* Copyright (C) 1985 by Manx Software Systems, Inc.
*
	instxt	<zpage.h>
*
*	void
*	swapmem(s1, s2, len);
*	  char *s1, *s2;
*	  int len;
*
*	swap blocks of memory
*

S1	equ	R0+2
S2	equ	R0+4
LEN	equ	R0+6

	public	swapmem_
swapmem_
	ldy	#7		;copy params to zero page
load	lda	(SP),Y
	sta	R0,Y
	dey
	bpl	load

	iny
	ldx	LEN
	beq	skip2
loop	lda	(S1),Y
	pha
	lda	(S2),Y
	sta	(S1),Y
	pla
	sta	(S2),Y
	iny
	bne	skip
	inc	S1+1
	inc	S2+1
skip	dex
	bne	loop
skip2	dec	LEN+1
	bpl	loop
	rts

swit.a65
*:ts=8
*
* Copyright (C) 1983,84,85 by Manx Software Systems, Inc.
*
	instxt	<zpage.h>
*
	public	.swit
.swit	pla
	sta	VAL
	pla
	sta	VAL+1
	ldy	#1
	lda	(VAL),Y
	tax
	iny
	lda	(VAL),Y
	sta	TMP
	clc
	lda	VAL
	adc	#3
	sta	VAL
	bcc	switch1
	inc	VAL+1
switch1	ldy	#0
	txa
	bne	switch2
	dec	TMP
	bpl	switch2
	dey
	bne	switch4
switch2	dex
	lda	(VAL),Y
	cmp	R0
	bne	switch3
	iny
	lda	(VAL),Y
	cmp	R0+1
	beq	switch4
switch3	clc
	lda	VAL
	adc	#4
	sta	VAL
	bcc	switch1
	inc	VAL+1
	bcs	switch1
switch4	iny
	lda	(VAL),Y
	sta	R0
	iny
	lda	(VAL),Y
	sta	R0+1
	ldx	#0
	jmp	(R0)
*
tmpsav.a65
*:ts=8
*
* Copyright (C) 1983,84,85 by Manx Software Systems, Inc.
*
	instxt	<zpage.h>
*
	public	.rpush
.rpush	ldy	#1
	sec
	lda	SP
	sbc	#2
psh1	sta	SP
	bcs	psh2
	dec	SP+1
psh2	lda	0,X
	sta	(SP),Y
	inx
	dey
	bpl	psh2
	ldy	#1
	ldx	#0
	txa
	rts

	public	.rpushx
.rpushx	ldy	#3
	sec
	lda	SP
	sbc	#4
	jmp	psh1

	public	.rpull
.rpull	ldy	#1
pop1	lda	(SP),Y
	sta	0,X
	inx
	dey
	bpl	pop1
	clc
	lda	SP
	adc	#2
	sta	SP
	bcc	pop2
	inc	SP+1
pop2	ldy	#1
	ldx	#0
	txa
	rts

	public	.rpullx
.rpullx	ldy	#3
lpop1	lda	(SP),Y
	sta	0,X
	inx
	dey
	bpl	lpop1
	clc
	lda	SP
	adc	#4
	sta	SP
	bcc	lpop2
	inc	SP+1
lpop2	ldy	#1
	ldx	#0
	txa
	rts
*
makefile
.SUFFIXES: .c .a65 .r .i

.c.r:
	cg65 +g0,8,80,10 -o $*.r $*.c
	sqz65 $*.r

.c.i:
	cci -ao $*.asm $*.c
	optint65 -ZAP $*.asm
	sqz65 $*.i

.a65.r:
	as65 -o $*.r $*.a65
	sqz65 $*.r

SRC= fldstar.a65 flt.a65 fstswt.a65 index.a65 strchr.a65 interp.a65\
	istack.a65 lmath.a65 longs.a65 lshift.a65 math.a65\
	move.a65 movmem.a65 rindex.a65 strrchr.a65 setjmp.a65 setmem.a65\
	shift.a65 stack.a65 strcat.a65 strcmp.a65 strcpy.a65 strequ.a65\
	strlen.a65 strncat.a65 strncmp.a65 strncpy.a65 sup.a65\
	swapmem.a65 swit.a65 tmpsav.a65 

REL= fldstar.r flt.r fstswt.r index.r strchr.r interp.r\
	istack.r lmath.r longs.r lshift.r math.r\
	move.r movmem.r rindex.r strrchr.r setjmp.r setmem.r\
	shift.r stack.r strcat.r strcmp.r strcpy.r strequ.r\
	strlen.r strncat.r strncmp.r strncpy.r sup.r\
	swapmem.r swit.r tmpsav.r

rel: $(REL)
	echo done
