/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TooManyListenersException;
import javax.comm.SerialPort;
import javax.comm.SerialPortEventListener;
import javax.comm.UnsupportedCommOperationException;

class NullSerialPort
extends SerialPort {
    private InputStream ins;
    private OutputStream outs;
    private int rcvThreshold = -1;
    int rcvTimeout = -1;
    private boolean framing = false;
    private int framingByte;
    boolean framingByteReceived;
    private int baudrate;
    private int parity;
    private int dataBits;
    private int stopBits;
    private int flowcontrol;
    private boolean dtr = true;
    private boolean rts = true;
    private boolean closed = false;

    NullSerialPort(String string) throws IOException {
        this.name = string;
    }

    public InputStream getInputStream() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        return this.ins;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        return this.outs;
    }

    public void enableReceiveThreshold(int n) throws UnsupportedCommOperationException {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        this.rcvThreshold = n;
    }

    public void disableReceiveThreshold() {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        this.rcvThreshold = -1;
    }

    public boolean isReceiveThresholdEnabled() {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        return this.rcvThreshold != -1;
    }

    public int getReceiveThreshold() {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        return this.rcvThreshold;
    }

    public void enableReceiveTimeout(int n) throws UnsupportedCommOperationException {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        this.rcvTimeout = n;
    }

    public void disableReceiveTimeout() {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        this.rcvTimeout = -1;
    }

    public int getReceiveTimeout() {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        return this.rcvTimeout;
    }

    public boolean isReceiveTimeoutEnabled() {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        return this.rcvTimeout != -1;
    }

    public void disableReceiveFraming() {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        this.framing = false;
    }

    public void enableReceiveFraming(int n) throws UnsupportedCommOperationException {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        this.framing = true;
        this.framingByte = n & 0xFF;
    }

    public int getReceiveFramingByte() {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        return this.framingByte;
    }

    public boolean isReceiveFramingEnabled() {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        return this.framing;
    }

    public void setInputBufferSize(int n) {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
    }

    public int getInputBufferSize() {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        return 0;
    }

    public void setOutputBufferSize(int n) {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
    }

    public int getOutputBufferSize() {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        return 0;
    }

    public int getBaudRate() {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        return this.baudrate;
    }

    public int getDataBits() {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        return this.dataBits;
    }

    public int getStopBits() {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        return this.stopBits;
    }

    public int getParity() {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        return this.parity;
    }

    public void setFlowControlMode(int n) throws UnsupportedCommOperationException {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        this.flowcontrol = n;
    }

    public int getFlowControlMode() {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        return this.flowcontrol;
    }

    public void setSerialPortParams(int n, int n2, int n3, int n4) throws UnsupportedCommOperationException {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        this.baudrate = n;
        this.parity = n4;
        this.dataBits = n2;
        this.stopBits = n3;
    }

    public void sendBreak(int n) {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
    }

    public void setDTR(boolean bl) {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        if ((this.flowcontrol & 1) == 1) {
            return;
        }
        this.dtr = bl;
    }

    public boolean isDTR() {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        return this.dtr;
    }

    public void setRTS(boolean bl) {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        if ((this.flowcontrol & 1) == 1) {
            throw new IllegalStateException("Cannot modify RTS when Hardware flowcontrol is on.");
        }
        this.rts = bl;
    }

    public boolean isRTS() {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        return this.rts;
    }

    public boolean isCTS() {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        return true;
    }

    public boolean isDSR() {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        return true;
    }

    public boolean isRI() {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        return false;
    }

    public boolean isCD() {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        return true;
    }

    public synchronized void addEventListener(SerialPortEventListener serialPortEventListener) throws TooManyListenersException {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
    }

    public synchronized void removeEventListener() {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
    }

    public synchronized void notifyOnDataAvailable(boolean bl) {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
    }

    public synchronized void notifyOnOutputEmpty(boolean bl) {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
    }

    public synchronized void notifyOnCTS(boolean bl) {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
    }

    public synchronized void notifyOnDSR(boolean bl) {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
    }

    public synchronized void notifyOnCarrierDetect(boolean bl) {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
    }

    public synchronized void notifyOnRingIndicator(boolean bl) {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
    }

    public synchronized void notifyOnOverrunError(boolean bl) {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
    }

    public synchronized void notifyOnParityError(boolean bl) {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
    }

    public synchronized void notifyOnFramingError(boolean bl) {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
    }

    public synchronized void notifyOnBreakInterrupt(boolean bl) {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
    }

    protected void finalize() throws Throwable {
    }

    public void close() {
        this.closed = true;
        super.close();
    }
}

