/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.TextArea;
import java.io.IOException;
import javax.comm.ParallelPort;

public class Receiver
extends Panel
implements Runnable {
    private TextArea text;
    private ReceiveOptions options;
    private ByteStatistics counter;
    private ParallelPortDisplay owner;
    private byte[] buffer;
    private int textCount;
    private int delay;

    public Receiver(ParallelPortDisplay parallelPortDisplay, int n, int n2) {
        this.owner = parallelPortDisplay;
        this.buffer = new byte[2048];
        this.setLayout((LayoutManager)new BorderLayout());
        this.options = new ReceiveOptions(parallelPortDisplay.port);
        this.add("North", (Component)this.options);
        this.counter = new ByteStatistics("Bytes Received", 10, parallelPortDisplay.port, true);
        this.add("South", (Component)this.counter);
        this.text = new TextArea(n, n2);
        this.add("Center", (Component)this.text);
        this.textCount = 0;
        this.delay = 0;
    }

    public Receiver(ParallelPortDisplay parallelPortDisplay, int n, int n2, int n3) {
        this(parallelPortDisplay, n, n2);
        this.delay = n3;
    }

    public void setPort(ParallelPort parallelPort) {
        this.counter.setPort(parallelPort);
        this.options.setPort(parallelPort);
    }

    public void showValues() {
        this.options.showValues();
        this.counter.showValues();
    }

    public void clearValues() {
        this.text.setText("");
        this.counter.clearValues();
        this.options.clearValues();
    }

    public void setBitsPerCharacter(int n) {
        this.counter.setBitsPerCharacter(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.owner.open) {
            try {
                Receiver receiver = this;
                synchronized (receiver) {
                    this.wait(10000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.owner.ctlSigs.DA) continue;
            this.readData();
        }
    }

    private String displayText(byte[] byArray, int n) {
        if (this.textCount > 5000) {
            this.text.setText("");
            this.textCount = 0;
        }
        byte[] byArray2 = new byte[n * 4];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (Character.isISOControl((char)byArray[i]) && !Character.isWhitespace((char)byArray[i])) {
                byArray2[n2++] = 60;
                byArray2[n2++] = 94;
                byArray2[n2++] = (byte)(byArray[i] + 64);
                byArray2[n2++] = 62;
                continue;
            }
            byArray2[n2++] = byArray[i];
        }
        String string = new String(byArray2, 0, n2);
        this.text.append(string);
        this.counter.incrementValue((long)n);
        this.textCount += n;
        return string;
    }

    public void readData() {
        try {
            while (this.owner.open && this.owner.in.available() > 0) {
                int n = this.owner.in.read(this.buffer);
                if (n > 0) {
                    if (n > this.buffer.length) {
                        System.out.println(this.owner.port.getName() + ": Input buffer overflow!");
                    }
                    String string = this.displayText(this.buffer, n);
                    if (this.owner.lineMonitor) {
                        this.owner.transmitter.sendString(string);
                    }
                }
                if (this.delay <= 0) continue;
                long l = System.currentTimeMillis() + (long)this.delay;
                long l2 = 0L;
                while (l2 < l) {
                    try {
                        Thread.sleep(this.delay);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    l2 = System.currentTimeMillis();
                }
            }
            this.owner.ctlSigs.DA = false;
            this.owner.ctlSigs.showErrorValues();
        }
        catch (IOException iOException) {
            System.out.println(this.owner.port.getName() + ": Cannot read input stream");
        }
    }
}

