/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comm;

import com.sun.comm.Unix;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;

public class PathBundle {
    private File file;
    private int type;
    private Vector rootPathVector = new Vector();
    private boolean rootPort = false;

    public PathBundle() {
        this.rootPort = true;
    }

    private PathBundle(File file, int type, PathBundle rootPort) {
        this.file = file;
        this.type = type;
        rootPort.addToVector(this);
    }

    private void addToVector(PathBundle phyPort) {
        this.rootPathVector.add(phyPort);
    }

    public void add(String pathName, int type) {
        File baseFile = new File(pathName);
        if (baseFile.exists()) {
            if (baseFile.isDirectory()) {
                File[] files = baseFile.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    if (!Unix.isDevLink(files[i].getPath())) continue;
                    new PathBundle(files[i], type, this);
                }
            } else if (Unix.isDevLink(baseFile.getPath())) {
                new PathBundle(baseFile, type, this);
            }
        }
    }

    public PathBundle[] getAll() {
        PathBundle[] pathList;
        if (this.rootPort) {
            int portNbr = 0;
            pathList = new PathBundle[this.rootPathVector.size()];
            Enumeration e = this.rootPathVector.elements();
            while (e.hasMoreElements()) {
                pathList[portNbr++] = (PathBundle)e.nextElement();
            }
        } else {
            pathList = new PathBundle[]{this};
        }
        return pathList;
    }

    public File getFile() {
        return this.file;
    }

    public int getType() {
        return this.type;
    }

    public String getPath() {
        return this.file.getPath();
    }

    public String getName() {
        return this.file.getName();
    }

    public int getCount() {
        if (this.rootPort) {
            return this.rootPathVector.size();
        }
        return 1;
    }

    public void clear() {
        if (this.rootPort) {
            this.rootPathVector.clear();
        }
    }
}

