/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comm;

import com.sun.comm.PathBundle;
import com.sun.comm.PortmapDatabase;
import com.sun.comm.PortmapEntry;
import com.sun.comm.SunrayInfo;
import com.sun.comm.Unix;
import java.io.IOException;
import java.util.Enumeration;
import javax.comm.CommDriver;
import javax.comm.CommPortIdentifier;

public class Portmapping {
    private static CommDriver driver = null;
    private static final int SERIAL = 1;
    private static final int PARALLEL = 2;
    private static final int DEFAULT_ALIASING = 0;
    private static final int DONGLE_ALIASING = 1;

    public static Enumeration refreshPortDatabase(String portMapFilename, CommDriver driver, PathBundle serverPorts) throws IOException {
        String debug_portmap;
        Portmapping.driver = driver;
        if (portMapFilename != null) {
            try {
                PortmapDatabase.loadPortmapFile(portMapFilename);
            }
            catch (IOException e) {
                System.err.println("Error accessing " + portMapFilename);
            }
        }
        if ((debug_portmap = System.getProperty("debug_portmap")) != null && debug_portmap.equals("all")) {
            PortmapDatabase.dump();
        }
        Portmapping.registerCommPorts(serverPorts);
        return PortmapDatabase.getCommPortIdentifiers();
    }

    private static void registerCommPorts(PathBundle serverPorts) {
        Enumeration e;
        PathBundle[] portList = serverPorts.getAll();
        if (SunrayInfo.isSessionActive()) {
            portList = serverPorts.getAll();
            for (int i = 0; i < portList.length; ++i) {
                String dtuName = PortmapDatabase.terminalIdToDTUname(SunrayInfo.getSessionTerminalId());
                if (dtuName == null) continue;
                e = PortmapDatabase.findDTUnameRefs(dtuName);
                while (e.hasMoreElements()) {
                    PortmapEntry pme = (PortmapEntry)e.nextElement();
                    if (!pme.getEquatedTarget().equals(portList[i].getPath())) continue;
                    Portmapping.add(new CommPortIdentifier(pme.getLogicalName(), null, portList[i].getType(), driver));
                }
            }
            PathBundle donglePorts = new PathBundle();
            donglePorts.add(SunrayInfo.getSessionDevRoot() + "/dev/term", 1);
            donglePorts.add(SunrayInfo.getSessionDevRoot() + "/dev/printers", 2);
            portList = donglePorts.getAll();
            for (int i = 0; i < donglePorts.getCount(); ++i) {
                String fullPath = portList[i].getPath();
                String aliasName = portList[i].getName();
                int portType = portList[i].getType();
                if (PortmapDatabase.findByEquivName(fullPath).hasMoreElements() || PortmapDatabase.findByALNpath(fullPath).hasMoreElements()) continue;
                if (aliasName != fullPath) {
                    PortmapDatabase.add(new PortmapEntry(aliasName, fullPath));
                }
                Portmapping.add(new CommPortIdentifier(aliasName, null, portType, driver));
            }
            e = PortmapDatabase.findSessionLocalALNs();
            while (e.hasMoreElements()) {
                PortmapEntry pme = (PortmapEntry)e.nextElement();
                Portmapping.add(new CommPortIdentifier(pme.getLogicalName(), null, pme.getALNportType(), driver));
            }
        } else {
            portList = serverPorts.getAll();
            for (int i = 0; i < portList.length; ++i) {
                String fullPath = portList[i].getPath();
                String aliasName = portList[i].getName();
                int portType = portList[i].getType();
                e = PortmapDatabase.findByEquivName(fullPath);
                if (e.hasMoreElements()) {
                    while (e.hasMoreElements()) {
                        PortmapEntry pme = (PortmapEntry)e.nextElement();
                        if (!pme.isSessionIndependent() || pme.isHidden()) continue;
                        Portmapping.add(new CommPortIdentifier(pme.getLogicalName(), null, portType, driver));
                    }
                    continue;
                }
                Portmapping.add(new CommPortIdentifier(fullPath, null, portType, driver));
            }
        }
        if (Unix.isSuperUser()) {
            e = PortmapDatabase.findDTUspecificALNs();
            while (e.hasMoreElements()) {
                PortmapEntry pme = (PortmapEntry)e.nextElement();
                String termId = PortmapDatabase.DTUnameToTerminalId(pme.getDTUname());
                if (termId == null || !SunrayInfo.isDTUonline(termId)) continue;
                Portmapping.add(new CommPortIdentifier(pme.getLogicalName(), null, pme.getALNportType(), driver));
            }
        }
    }

    public static Enumeration getCommPortIdentifiers() {
        return PortmapDatabase.getCommPortIdentifiers();
    }

    public static void add(CommPortIdentifier cpi) {
        PortmapDatabase.add(cpi);
    }

    public static String translatePortname(String portName) throws IOException {
        return PortmapDatabase.translatePortname(portName);
    }
}

