/*
 * Decompiled with CFR 0.152.
 */
package ags.communication;

import ags.communication.DataUtil;
import ags.controller.Launcher;
import ags.script.BadVariableValueException;
import ags.script.Variable;
import gnu.io.CommPort;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class GenericHost {
    private SerialPort port = null;
    InputStream in = null;
    OutputStream out = null;
    int currentBaud = 1;
    FlowControl currentFlow = FlowControl.none;
    static boolean legacyMode = false;
    public static char CANCEL_INPUT = (char)24;
    public static String HEX_BYTES_PER_LINE = "hexBytesPerLine";
    private boolean echoCheck;
    static GenericHost instance;
    String expectedPrompt = null;

    public static void setLegacyMode(boolean mode) {
        legacyMode = mode;
    }

    public static boolean isLegacyMode() {
        return legacyMode;
    }

    public String getExpectedPrompt() {
        return this.expectedPrompt;
    }

    public void setExpectedPrompt(String expectedPrompt) {
        this.expectedPrompt = expectedPrompt;
    }

    public GenericHost() {
        instance = this;
    }

    public GenericHost(CommPort port) {
        this();
        this.setEchoCheck(true);
        this.port = (SerialPort)port;
        try {
            this.in = port.getInputStream();
            this.out = port.getOutputStream();
            this.port.setDTR(true);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public static GenericHost getInstance() {
        return instance;
    }

    public boolean isEchoCheck() {
        return this.echoCheck;
    }

    public void setEchoCheck(boolean echoCheck) {
        System.out.println("echo check set to " + echoCheck);
        this.echoCheck = echoCheck;
    }

    public void setBaud(int baudRate) {
        try {
            this.port.setSerialPortParams(baudRate, 8, 1, 0);
            this.port.setFlowControlMode(this.currentFlow.val);
            this.port.setDTR(true);
            this.currentBaud = baudRate;
        }
        catch (UnsupportedCommOperationException ex) {
            ex.printStackTrace();
        }
    }

    public void setFlowControl(FlowControl f) {
        this.currentFlow = f;
        System.out.println("Local flow control set to " + (Object)((Object)f));
        this.setBaud(this.currentBaud);
    }

    public void typeHex(String filename, String start) throws IOException {
        int addr;
        byte[] data;
        try {
            System.out.println("Trying to send binary " + filename);
            data = DataUtil.getFileAsBytes(filename);
        }
        catch (IOException ex) {
            System.out.println("Got an error when trying to read binary file " + filename + ", please check that this file exists and, if necessary, its containing directory is in the classpath");
            throw ex;
        }
        System.out.println("Got file " + filename);
        try {
            addr = Integer.parseInt(start, 16);
        }
        catch (NumberFormatException ex) {
            throw new IOException("Bad starting address was passed in to the typeHex command: " + start);
        }
        System.out.println("Typing contents of binary file " + filename + ", starting at address " + start);
        this.setExpectedPrompt("*");
        int hexBytes = Integer.parseInt(Variable.getVariable(HEX_BYTES_PER_LINE).getValue());
        for (int pos = 0; pos < data.length; pos += hexBytes) {
            StringBuffer bytes = new StringBuffer();
            for (int i = 0; i < hexBytes && i + pos < data.length; ++i) {
                if (i > 0) {
                    bytes.append(" ");
                }
                bytes.append(Integer.toString(data[pos + i] & 0xFF, 16));
            }
            String out = Integer.toString(addr + pos, 16) + ":" + bytes + "\r";
            this.writeParanoid(out.toUpperCase());
        }
    }

    public void writeParanoid(String s) throws IOException {
        if (legacyMode) {
            s = s.toUpperCase();
        }
        byte[] bytes = s.getBytes();
        byte[] expect = new byte[1];
        if (!this.isEchoCheck()) {
            long waitTime = DataUtil.nanosPerCharAtSpeed(this.currentBaud);
            long cycleTime = DataUtil.cyclesToNanos(4000L);
            waitTime = Math.max(waitTime, cycleTime) * 2L;
            System.out.println("Using " + waitTime + " nano sleep for " + this.currentBaud + " baud");
            for (int i = 0; i < bytes.length; ++i) {
                this.out.flush();
                Launcher.checkRuntimeStatus();
                this.writeOutput(bytes, i, 1);
                DataUtil.nanosleep(waitTime);
            }
            this.out.flush();
            long lineWait = DataUtil.cyclesToNanos(1000 * (bytes.length + 1));
            DataUtil.nanosleep(lineWait);
        } else {
            int errors = 0;
            for (int i = 0; i < bytes.length && errors < 2; ++i) {
                Launcher.checkRuntimeStatus();
                try {
                    this.writeOutput(bytes, i, 1);
                    if (bytes[i] >= 32) {
                        this.expect(s.substring(i, i + 1), 500, false);
                    }
                    errors = 0;
                    continue;
                }
                catch (IOException ex) {
                    System.out.println("Failure writing line, retrying...");
                    this.cancelLine();
                    i = -1;
                    ++errors;
                }
            }
            if (errors >= 2) {
                throw new IOException("Cannot write " + s);
            }
        }
        this.expectPrompt();
    }

    public void cancelLine() throws IOException {
        this.writeOutput((byte)CANCEL_INPUT);
    }

    public void expectPrompt() throws IOException {
        if (this.expectedPrompt == null || "".equals("")) {
            return;
        }
        if (this.isEchoCheck()) {
            this.expect(this.expectedPrompt, 5000, false);
        } else {
            DataUtil.wait(500);
        }
    }

    public boolean expectBytes(byte[] data, int timeout) throws IOException {
        int length = Math.max(80, Math.max(this.inputAvailable(), data.length * 2));
        ByteBuffer bb = ByteBuffer.allocate(length);
        while (timeout > 0) {
            Launcher.checkRuntimeStatus();
            while (this.inputAvailable() == 0 && timeout > 0) {
                Launcher.checkRuntimeStatus();
                --timeout;
                DataUtil.wait(1);
            }
            if (timeout <= 0) continue;
            byte[] receivedData = this.readBytes();
            bb.put(receivedData);
            if (!DataUtil.bufferContains(bb, data)) continue;
            return true;
        }
        if (bb.position() == 0) {
            throw new IOException("expected " + Arrays.toString(data) + " but timed out");
        }
        throw new IOException("Expected " + Arrays.toString(data) + " but got " + Arrays.toString(bb.array()));
    }

    public boolean expect(String string, int timeout, boolean noConversion) throws IOException {
        StringBuffer searchString = new StringBuffer();
        while (timeout > 0) {
            Launcher.checkRuntimeStatus();
            while (this.inputAvailable() == 0 && timeout > 0) {
                DataUtil.wait(1);
                --timeout;
            }
            String receivedString = this.readString();
            if (!noConversion) {
                receivedString = DataUtil.convertFromAppleText(receivedString);
            }
            searchString.append(receivedString);
            if (!searchString.toString().contains(string)) continue;
            return true;
        }
        if (searchString.equals("")) {
            throw new IOException("expected " + string + " but timed out");
        }
        throw new IOException("Expected " + string + " but got " + searchString.toString());
    }

    public String readString() throws IOException {
        return DataUtil.bytesToString(this.readBytes());
    }

    public byte[] readBytes() throws IOException {
        byte[] data = new byte[this.inputAvailable()];
        this.readInput(data);
        return data;
    }

    public void write(String s) throws IOException {
        byte[] bytes = s.getBytes();
        for (int i = 0; i < bytes.length; ++i) {
            this.writeOutput(bytes, i, 1);
        }
    }

    public int inputAvailable() throws IOException {
        int avail = 0;
        avail = this.in.available();
        return avail;
    }

    int readInput(byte[] buffer) throws IOException {
        int size = this.in.read(buffer);
        if (size != buffer.length) {
            System.out.println("Buffer was of size " + buffer.length + " but we got back " + size);
        }
        return size;
    }

    public void writeOutput(byte ... buffer) throws IOException {
        this.writeOutput(buffer, 0, buffer.length);
    }

    void waitToSend(int timeout) throws IOException {
        if (this.currentFlow == FlowControl.hardware) {
            while (!this.port.isCTS() && timeout > 0) {
                DataUtil.wait(10);
                timeout -= 10;
            }
            if (timeout <= 0) {
                throw new IOException("Timed out waiting to send data to remote host!");
            }
        }
    }

    public void writeOutput(byte[] buffer, int offset, int length) throws IOException {
        if (buffer == null || offset >= buffer.length || buffer.length == 0 || length == 0) {
            return;
        }
        this.out.write(buffer, offset, length);
    }

    static {
        try {
            new Variable(HEX_BYTES_PER_LINE).setValue(String.valueOf(64));
        }
        catch (BadVariableValueException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FlowControl {
        none(0),
        xon(4),
        hardware(1);

        private int val;

        private FlowControl(int v) {
            this.val = v;
        }

        public int getConfigValue() {
            return this.val;
        }
    }
}

