/*
 * Decompiled with CFR 0.152.
 */
package ags.controller;

import ags.controller.Configurable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configurator {
    public static Map<Field, Object> DEFAULT_VALUES = new HashMap<Field, Object>();

    private static Class[] getClasses(String packageName) throws ClassNotFoundException, IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        assert (classLoader != null);
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = classLoader.getResources(path);
        ArrayList<File> dirs = new ArrayList<File>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            dirs.add(new File(resource.getFile()));
        }
        ArrayList<Class> classes = new ArrayList<Class>();
        for (File directory : dirs) {
            classes.addAll(Configurator.findClasses(directory, packageName));
        }
        return classes.toArray(new Class[classes.size()]);
    }

    private static List<Class> findClasses(File directory, String packageName) throws ClassNotFoundException {
        File[] files;
        ArrayList<Class> classes = new ArrayList<Class>();
        if (!directory.exists()) {
            String path = directory.getPath();
            if (path.toLowerCase().contains(".jar!")) {
                path = path.substring(path.indexOf(58) + 1, path.lastIndexOf(33));
                return Configurator.findClassInJar(new File(path));
            }
            return classes;
        }
        for (File file : files = directory.listFiles()) {
            if (file.isDirectory()) {
                assert (!file.getName().contains("."));
                classes.addAll(Configurator.findClasses(file, packageName + "." + file.getName()));
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            classes.add(Class.forName(packageName + '.' + file.getName().substring(0, file.getName().length() - 6)));
        }
        return classes;
    }

    private static List<Class> findClassInJar(File jarFile) {
        ArrayList<Class> classes = new ArrayList<Class>();
        try {
            JarFile jar = new JarFile(jarFile, false);
            Enumeration<JarEntry> e = jar.entries();
            while (e.hasMoreElements()) {
                JarEntry entry = e.nextElement();
                String name = entry.getName();
                if (!name.endsWith(".class")) continue;
                name = name.substring(0, name.length() - 6);
                name = name.replace('/', '.');
                classes.add(Class.forName(name));
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(Configurator.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(Configurator.class.getName()).log(Level.SEVERE, null, ex);
        }
        return classes;
    }

    public static List<Field> findVariables() {
        ArrayList<Field> out = new ArrayList<Field>();
        try {
            Class[] allClasses;
            for (Class c : allClasses = Configurator.getClasses("ags")) {
                for (Field f : c.getDeclaredFields()) {
                    Configurable annotation = Configurator.getAnnotation(f);
                    if (annotation == null) continue;
                    out.add(f);
                }
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(Configurator.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(Configurator.class.getName()).log(Level.SEVERE, null, ex);
        }
        return out;
    }

    public static void setVariable(Field f, String value) {
        Configurable annotation = Configurator.getAnnotation(f);
        if (annotation == null) {
            return;
        }
        try {
            if (f.getType().equals(Boolean.class) || f.getType().equals(Boolean.TYPE)) {
                boolean b = Boolean.parseBoolean(value);
                f.setBoolean(null, b);
            } else if (f.getType().equals(Integer.class) || f.getType().equals(Integer.TYPE)) {
                int i = Integer.parseInt(value);
                f.setInt(null, i);
            } else if (f.getType().equals(String.class)) {
                f.set(null, String.valueOf(value));
            } else if (f.getType().isEnum()) {
                f.set(null, Enum.valueOf(f.getType(), value));
            }
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(Configurator.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void setVariable(Field field, Object value) {
        Configurator.setVariable(field, String.valueOf(value));
    }

    public static Configurable getAnnotation(Field f) {
        Configurable annotation = f.getAnnotation(Configurable.class);
        return annotation;
    }

    public static String getName(Field var) {
        return var.getDeclaringClass().getCanonicalName() + "." + var.getName();
    }

    public static void main(String[] args) {
        List<Field> vars = Configurator.findVariables();
        for (Field var : vars) {
            System.out.println("Field " + Configurator.getName(var));
        }
    }

    public static void revertDefaults() {
        for (Field f : Configurator.findVariables()) {
            try {
                f.set(null, DEFAULT_VALUES.get(f));
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(Configurator.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(Configurator.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static void loadValues() {
        Preferences prefs = Preferences.userNodeForPackage(Configurator.class);
        for (Field f : Configurator.findVariables()) {
            String value = prefs.get(Configurator.getName(f), null);
            if (value == null) continue;
            Configurator.setVariable(f, value);
        }
    }

    public static void saveValues() {
        Preferences prefs = Preferences.userNodeForPackage(Configurator.class);
        for (Field f : Configurator.findVariables()) {
            Object currentValue = null;
            try {
                currentValue = f.get(null);
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(Configurator.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(Configurator.class.getName()).log(Level.SEVERE, null, ex);
            }
            boolean saveValue = true;
            if (currentValue == null && DEFAULT_VALUES.get(f) == null) {
                saveValue = false;
            } else if (currentValue.equals(DEFAULT_VALUES.get(f))) {
                saveValue = false;
            }
            if (saveValue) {
                prefs.put(Configurator.getName(f), String.valueOf(currentValue));
                continue;
            }
            prefs.remove(Configurator.getName(f));
        }
    }

    static {
        for (Field f : Configurator.findVariables()) {
            try {
                Object defaultValue = f.get(null);
                DEFAULT_VALUES.put(f, defaultValue);
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(Configurator.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(Configurator.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (NullPointerException nullPointerException) {}
        }
    }
}

