/*
 * Decompiled with CFR 0.152.
 */
package ags.controller;

import ags.communication.TCPTransferHost;
import ags.communication.TransferHost;
import ags.controller.Configurable;
import ags.controller.FileType;
import ags.game.Game;
import ags.game.GameUtil;
import ags.script.Script;
import ags.ui.HiresBufferedScreen;
import ags.ui.gameSelector.GameSelectorApplication;
import ags.ui.host.Main;
import gnu.io.CommPort;
import gnu.io.RXTXCommDriver;
import gnu.io.SerialPort;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;

public class Launcher
implements Runnable {
    private static String START_PROGRAM = "Start Program";
    private static String STOP_PROGRAM = "Stop Program";
    private static PrintStream outLogRedirect = null;
    private static PrintStream errLogRedirect = null;
    @Configurable(category=Configurable.CATEGORY.COM, isRequired=true)
    public static MACHINE_TYPES MACHINE_TYPE = MACHINE_TYPES.Apple2e;
    @Configurable(category=Configurable.CATEGORY.COM, isRequired=true)
    public static PORT_TYPES PORT_TYPE = PORT_TYPES.TCP;
    @Configurable(category=Configurable.CATEGORY.COM, isRequired=true)
    public static String HOST = "localhost";
    @Configurable(category=Configurable.CATEGORY.COM, isRequired=true)
    public static String PORT = "1977";
    @Configurable(category=Configurable.CATEGORY.COM, isRequired=false)
    public static boolean DEBUG_BOOTSTRAP = false;
    @Configurable(category=Configurable.CATEGORY.RUNTIME, isRequired=false)
    @FileType(value="jar")
    public static String RXTX_JAR_PATH = "lib/RXTXcomm.jar";
    @Configurable(category=Configurable.CATEGORY.RUNTIME, isRequired=true)
    public static String RXTX_LIB_PATH = "rxtxSerial";
    @Configurable(category=Configurable.CATEGORY.RUNTIME, isRequired=true)
    @FileType(value="jar")
    public static String COMM_JAR_PATH = "lib/comm.jar";
    @Configurable(category=Configurable.CATEGORY.RUNTIME, isRequired=true)
    @FileType(value="jar")
    public static String JAXB_API_JAR_PATH = "lib/jaxb-api.jar";
    @Configurable(category=Configurable.CATEGORY.RUNTIME, isRequired=true)
    @FileType(value=".")
    public static String DATA_DIR = "lib/data";
    static Thread activeThread = null;
    private static boolean TERMINATE_PROGRAM = true;
    private TransferHost host;
    private CommPort port;
    private List<Game> games;

    private static void attachLogViewer(JTextArea logDisplay) {
        logDisplay.setVisible(true);
        logDisplay.setText("");
        if (outLogRedirect == null) {
            outLogRedirect = new PrintStream(new OutputStreamImpl(System.out), true);
            errLogRedirect = new PrintStream(new OutputStreamImpl(System.err), true);
            System.setOut(outLogRedirect);
            System.setErr(errLogRedirect);
        }
    }

    public static void checkRuntimeStatus() {
        if (TERMINATE_PROGRAM) {
            throw new RuntimeException("Program terminated by user intervention");
        }
        Main.instance.setTitle("AGS 3.0 - " + activeThread.getName());
    }

    private static void finished() {
        activeThread = null;
        Main.instance.startStopButton.setText(START_PROGRAM);
        Main.instance.startStopButton.setEnabled(true);
        Main.instance.setTitle("AGS 3.0 - Not running");
    }

    public static void startStop() {
        TERMINATE_PROGRAM = true;
        Main.instance.startStopButton.setEnabled(false);
        if (!TERMINATE_PROGRAM) {
            Launcher.stop();
        } else {
            Main.instance.startStopButton.setText(STOP_PROGRAM);
            Launcher.start();
        }
    }

    private static void stop() {
        TERMINATE_PROGRAM = true;
    }

    private static void start() {
        Launcher.attachLogViewer(Main.instance.logDisplay);
        if (activeThread != null && activeThread.isAlive()) {
            return;
        }
        TERMINATE_PROGRAM = false;
        activeThread = new Thread(new Launcher());
        try {
            ArrayList<URL> classpath = new ArrayList<URL>();
            classpath.add(new File(DATA_DIR).getCanonicalFile().toURI().toURL());
            classpath.add(new File(RXTX_JAR_PATH).getCanonicalFile().toURI().toURL());
            classpath.add(new File(COMM_JAR_PATH).getCanonicalFile().toURI().toURL());
            if (JAXB_API_JAR_PATH != null && !"".equals(JAXB_API_JAR_PATH)) {
                classpath.add(new File(JAXB_API_JAR_PATH).getCanonicalFile().toURI().toURL());
            }
            URL[] urls = classpath.toArray(new URL[0]);
            activeThread.setContextClassLoader(new URLClassLoader(urls, Launcher.class.getClassLoader()));
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(Launcher.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(Launcher.class.getName()).log(Level.SEVERE, null, ex);
        }
        activeThread.setPriority(7);
        activeThread.start();
        Main.instance.startStopButton.setEnabled(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            Launcher.loadCommLibrary();
            this.validateRequirements();
            this.initPort();
            this.bootstrap();
            this.main();
        }
        catch (Throwable ex) {
            this.showError(ex.getMessage());
            Logger.getLogger(Launcher.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            this.shutdown();
        }
    }

    private void showError(String message) {
        String showMessage = "";
        int len = 0;
        for (int i = 0; i < message.length(); ++i) {
            char c;
            showMessage = showMessage + message.charAt(i);
            if (++len <= 60 || (c = message.toLowerCase().charAt(i)) >= 'a' && c <= 'z') continue;
            showMessage = showMessage + "\n";
            len = 0;
        }
        JOptionPane.showMessageDialog(null, "An error has occurred: \n" + showMessage, "Error", 0);
    }

    public static void loadCommLibrary() throws RuntimeException {
        try {
            System.loadLibrary(RXTX_LIB_PATH);
        }
        catch (UnsatisfiedLinkError ex) {
            try {
                System.load(RXTX_LIB_PATH);
                File f = new File(RXTX_LIB_PATH);
                String lib = "";
                try {
                    lib = f.getParentFile().getCanonicalPath();
                }
                catch (IOException ex1) {
                    Logger.getLogger(Launcher.class.getName()).log(Level.SEVERE, null, ex1);
                }
                Field paths = ClassLoader.class.getDeclaredField("usr_paths");
                paths.setAccessible(true);
                Object[] pathList = (String[])paths.get(null);
                if (Arrays.binarySearch(pathList, lib) < 0) {
                    String[] newPathList = new String[pathList.length + 1];
                    for (int i = 0; i < pathList.length; ++i) {
                        newPathList[i] = pathList[i];
                    }
                    newPathList[pathList.length] = lib;
                    System.out.println("Adding lib path " + lib);
                    paths.set(null, newPathList);
                }
            }
            catch (UnsatisfiedLinkError ex1) {
                throw new RuntimeException("Could not find rxtxSerial library in the expected lib path " + System.getProperty("java.library.path"));
            }
            catch (IllegalArgumentException ex1) {
                Logger.getLogger(Launcher.class.getName()).log(Level.SEVERE, null, ex1);
            }
            catch (IllegalAccessException ex1) {
                Logger.getLogger(Launcher.class.getName()).log(Level.SEVERE, null, ex1);
            }
            catch (NoSuchFieldException ex1) {
                Logger.getLogger(Launcher.class.getName()).log(Level.SEVERE, null, ex1);
            }
            catch (SecurityException ex1) {
                Logger.getLogger(Launcher.class.getName()).log(Level.SEVERE, null, ex1);
            }
        }
    }

    private void validateRequirements() throws RuntimeException {
        this.games = GameUtil.readGames();
        if (this.games == null) {
            throw new RuntimeException("No games found.  Check your games directory is properly set and contains games.xml");
        }
    }

    private void initPort() throws Throwable {
        switch (PORT_TYPE) {
            case SERIAL: {
                RXTXCommDriver driver = new RXTXCommDriver();
                driver.initialize();
                try {
                    this.port = driver.getCommPort(PORT, 1);
                }
                catch (Throwable t) {
                    System.out.println("Error opening port: " + this.port.getName());
                    t.printStackTrace();
                    this.port = null;
                }
                if (this.port == null) {
                    throw new IOException("Port '" + PORT + "' is not available!");
                }
                System.out.println("Opened port: " + this.port.getName());
                this.host = new TransferHost(this.port);
                break;
            }
            case TCP: {
                int portnum = Integer.parseInt(PORT);
                this.host = new TCPTransferHost(HOST, portnum);
            }
        }
    }

    private void bootstrap() throws Throwable {
        Script.USE_TARGET = MACHINE_TYPE.toString();
        if (DEBUG_BOOTSTRAP) {
            Script.USE_TARGET = Script.USE_TARGET + "_debug";
        }
        this.host.init();
    }

    private void main() throws Throwable {
        try {
            Thread.currentThread().setName("Starting launcher");
            HiresBufferedScreen screen = new HiresBufferedScreen();
            GameSelectorApplication app = new GameSelectorApplication(screen);
            app.setGames(this.games);
            Thread.currentThread().setName("Launcher running");
            app.mainLoop(this.host);
        }
        catch (Throwable ex) {
            if (ex.getCause() != null) {
                ex = ex.getCause();
            }
            ex.printStackTrace();
            throw ex;
        }
    }

    public void shutdown() {
        if (this.port != null) {
            ((SerialPort)this.port).setDTR(false);
            this.port.close();
        }
        Launcher.finished();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PORT_TYPES {
        SERIAL,
        TCP;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MACHINE_TYPES {
        Apple2,
        Apple2e,
        Apple2c,
        Apple2gs;

    }

    private static class OutputStreamImpl
    extends OutputStream {
        private PrintStream out;

        public OutputStreamImpl(PrintStream out) {
            this.out = out;
        }

        public void write(int b) throws IOException {
            this.out.write(b);
            JTextArea disp = Main.instance.logDisplay;
            disp.append("" + (char)b);
            disp.setCaretPosition(disp.getText().length());
        }
    }
}

