/*
 * Decompiled with CFR 0.152.
 */
package ags.disk;

import ags.disk.C6RWTS;
import ags.disk.Disk;
import ags.disk.Dos33RWTS;
import ags.disk.MiniRWTS;
import java.io.IOException;
import java.io.InputStream;

public class Disk33
extends Disk {
    static int[] LOGICAL_SECTOR_ORDER = new int[]{0, 13, 11, 9, 7, 5, 3, 1, 14, 12, 10, 8, 6, 4, 2, 15};
    static int[] PHYSICAL_SECTOR_ORDER = new int[]{0, 7, 14, 6, 13, 5, 12, 4, 11, 3, 10, 2, 9, 1, 8, 15};

    public Disk33(InputStream file) throws IOException {
        super(file);
        this.setupRWTS();
    }

    public Disk33(String filename) throws IOException {
        super(filename);
        this.setupRWTS();
    }

    public void setupRWTS() throws IOException {
        this.registerRWTS(new Dos33RWTS());
        this.registerRWTS(new MiniRWTS());
        this.registerRWTS(new C6RWTS());
    }

    protected int translatePhysicalSectorNumber(int sectorNumber) {
        if (sectorNumber < 0 || sectorNumber >= 16) {
            System.out.println("Sector " + sectorNumber + " is out of range!");
            return 0;
        }
        return PHYSICAL_SECTOR_ORDER[sectorNumber];
    }

    protected int translateLogicalSectorNumber(int sectorNumber) {
        if (sectorNumber < 0 || sectorNumber >= 16) {
            System.out.println("Sector " + sectorNumber + " is out of range!");
            return 0;
        }
        return LOGICAL_SECTOR_ORDER[sectorNumber];
    }

    protected boolean isBootable(byte[] sector0) {
        boolean isBootable = true;
        isBootable &= sector0[0] == 1;
        isBootable &= sector0[54] == 108;
        isBootable &= sector0[55] == 62;
        return isBootable &= sector0[56] == 0;
    }
}

