/*
 * Decompiled with CFR 0.152.
 */
package ags.disk;

import ags.disk.Drive;
import ags.disk.RWTS;
import java.io.IOException;

public class Dos33RWTS
extends RWTS {
    public static int ADDR_COMMAND = 12;
    public static int ADDR_SLOT = 1;
    public static int ADDR_DRIVE_NO = 2;
    public static int ADDR_VOLUME = 3;
    public static int ADDR_TRACK = 4;
    public static int ADDR_SECTOR = 5;
    public static int ADDR_BUFFER = 8;
    public static int ADDR_RWTS_IOB_PTR = 72;
    public static byte COMMAND_READ_SECTOR = 1;
    public static byte COMMAND_WRITE_SECTOR = (byte)2;

    public Dos33RWTS() throws IOException {
        super("rwts", 132, 72, 133, 73);
    }

    public RWTS.CommandBlock parseCommandBlock(byte[] commandBlock) {
        if (commandBlock.length != 16) {
            return null;
        }
        byte command = commandBlock[ADDR_COMMAND];
        if (command != COMMAND_READ_SECTOR && command != COMMAND_WRITE_SECTOR) {
            return null;
        }
        int slot = (commandBlock[ADDR_SLOT] >> 4) - 1;
        if (slot < 0 || slot > 6) {
            return null;
        }
        int drive = commandBlock[ADDR_DRIVE_NO] - 1;
        if (drive != 0 && drive != 1) {
            return null;
        }
        byte track = commandBlock[ADDR_TRACK];
        if (track < 0 || track > 35) {
            return null;
        }
        byte sector = commandBlock[ADDR_SECTOR];
        if (sector < 0 || sector > 15) {
            return null;
        }
        int ioBuffAddr = 0xFF & commandBlock[ADDR_BUFFER] | 0xFF00 & commandBlock[ADDR_BUFFER + 1] << 8;
        RWTS.CommandBlock theCommand = new RWTS.CommandBlock(this, this);
        theCommand.setSlot(slot);
        theCommand.setDrive(drive);
        theCommand.setTrack(track);
        theCommand.setSector(sector);
        theCommand.setBufferAddress(ioBuffAddr);
        theCommand.setVolume(255);
        if (command == COMMAND_READ_SECTOR) {
            theCommand.setCommand(RWTS.Command.READ);
        }
        if (command == COMMAND_WRITE_SECTOR) {
            theCommand.setCommand(RWTS.Command.WRITE);
        }
        System.out.println((Object)((Object)theCommand.getCommand()) + ": S" + slot + ",D" + drive + ",T" + track + ",S" + sector);
        return theCommand;
    }

    void advance(RWTS.CommandBlock command) {
    }

    void finishRWTS(Drive aThis, RWTS.CommandBlock command) {
    }
}

