/*
 * Decompiled with CFR 0.152.
 */
package ags.disk;

import ags.communication.DataUtil;
import ags.communication.TransferHost;
import ags.controller.Launcher;
import ags.disk.C6RWTS;
import ags.disk.Disk;
import ags.disk.RWTS;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Drive {
    public static byte COMMAND_SET_ADDRESS = 0;
    public static byte COMMAND_SET_LENGTH = 1;
    public static byte COMMAND_STORE = (byte)2;
    public static byte COMMAND_READBLOCK = (byte)3;
    public static byte COMMAND_END = (byte)4;
    TransferHost apple;
    Disk[][] disk = new Disk[7][2];
    Disk bootDisk;

    public Drive(TransferHost t) {
        this.apple = t;
    }

    public void insertDisk(int slot, int drive, Disk newdisk) {
        this.disk[slot][drive] = newdisk;
    }

    public void ejectDisk(int slot, int drive) {
        this.disk[slot][drive] = null;
    }

    public void boot() throws IOException {
        this.boot(5, 0);
    }

    public void boot(int slot, int drive) throws IOException {
        this.bootDisk = this.disk[slot][drive];
        C6RWTS.USE_SLOT = slot;
        C6RWTS.USE_DRIVE = drive;
        this.apple.loadDriver("c6rwts", 604);
        byte[] sector0 = this.bootDisk.getSector(0, 0, 2048);
        int numSectors = sector0[0];
        int address = 2048;
        int sector = 0;
        for (int i = 0; i < numSectors; ++i) {
            System.out.println("Sending track 0, sector " + sector + " to address $" + Integer.toHexString(address));
            int sectorNum = this.bootDisk.translatePhysicalSectorNumber(sector++);
            byte[] sectorData = this.bootDisk.getSector(0, sectorNum, address);
            this.apple.sendRawData(this.hackBootSector(sectorData), address, 0, 256);
            address += 256;
        }
        System.out.println("Cold start dos (or die trying anyway)");
        byte[] executeCode = new byte[]{-94, (byte)(slot + 1 << 4), -122, 43, -87, (byte)(8 + numSectors), -123, 39, -87, 1, -123, 61, -87, 0, -123, 38, -123, 65, 76, 1, 8};
        this.apple.sendRawData(executeCode, 816, 0, executeCode.length);
        this.apple.jmp(816, false);
        this.mainLoop();
    }

    public void mainLoop() throws IOException {
        while (Thread.currentThread().isAlive()) {
            byte[] commandBlock = this.waitForCommand();
            System.out.println("Got command with " + commandBlock.length + " bytes");
            RWTS.CommandBlock command = this.bootDisk.parseCommand(commandBlock);
            if (command == null) {
                System.out.println("Could not identify how to handle this request!");
                continue;
            }
            if (command.getCommand() == RWTS.Command.READ) {
                while (command.getSectorCount() > 0) {
                    Disk d = this.disk[command.getSlot()][command.getDrive()];
                    int sector = command.getSector();
                    if (!command.isLogicalSector()) {
                        sector = d.translatePhysicalSectorNumber(sector);
                    }
                    this.storeMemory(command.getBufferAddress(), d.getSector(command.getTrack(), command.getSector(), command.getBufferAddress()));
                    command.next();
                }
            } else if (command.getCommand() == RWTS.Command.WRITE) {
                byte[] newSector = this.readData(command.getBufferAddress(), 256);
                this.disk[command.getSlot()][command.getDrive()].setSector(command.getTrack(), command.getSector(), newSector);
            }
            command.finishRWTS(this);
            this.finishRWTS();
        }
    }

    public byte[] waitForCommand() throws IOException {
        while (this.apple.inputAvailable() == 0) {
            try {
                Thread.sleep(100L);
                Launcher.checkRuntimeStatus();
            }
            catch (InterruptedException ex) {
                Logger.getLogger(Drive.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        int lastCheck = this.apple.inputAvailable();
        boolean gotMore = true;
        while (gotMore) {
            LockSupport.parkNanos(DataUtil.NANOS_PER_CHAR * 2L);
            int check = this.apple.inputAvailable();
            if (check != lastCheck) continue;
            gotMore = false;
            lastCheck = check;
        }
        return this.read();
    }

    public void finishRWTS() throws IOException {
        this.apple.writeOutput(COMMAND_END);
    }

    public byte[] readData(int address, int length) throws IOException {
        System.out.println("Reading " + length + " bytes from $" + Integer.toHexString(address));
        this.setAddress(address);
        this.setLength(length);
        this.apple.readBytes();
        this.apple.writeOutput(COMMAND_READBLOCK);
        return this.read();
    }

    public byte[] read() throws IOException {
        int timeout = 200;
        boolean pos = false;
        int length = 256;
        ArrayList<Byte> buffer = new ArrayList<Byte>();
        while (buffer.size() < length && timeout > 0) {
            byte[] b;
            while (this.apple.inputAvailable() == 0 && timeout > 0) {
                DataUtil.wait(20);
                timeout -= 20;
            }
            if (timeout != 0) {
                timeout = 40;
            }
            if (this.apple.inputAvailable() <= 0) continue;
            for (byte B : b = this.apple.readBytes()) {
                buffer.add(B);
            }
        }
        if (buffer.size() > 0) {
            byte[] output = new byte[buffer.size()];
            for (int i = 0; i < buffer.size(); ++i) {
                output[i] = (Byte)buffer.get(i);
            }
            return output;
        }
        return null;
    }

    public void sendRawData(byte[] fileData, int addressStart, int dataStart, int length) throws IOException {
        int size;
        int end = dataStart + length;
        for (int offset = dataStart; offset < end; offset += size) {
            this.setAddress(offset + addressStart);
            size = Math.min(256, end - offset);
            this.setLength(size);
            this.apple.writeOutput(COMMAND_STORE);
            this.apple.writeOutput(fileData, offset, size);
        }
    }

    private byte[] hackBootSector(byte[] sectorData) {
        int i;
        int[] search = new int[]{74, 74, 74, 74, 9, 192};
        int[] replace = new int[]{74, 74, 74, 74, 169, 2};
        int found = 0;
        int match = 0;
        for (i = 0; i < sectorData.length && found < search.length; ++i) {
            if (sectorData[i] == (byte)search[found]) {
                ++found;
                continue;
            }
            found = 0;
            match = i + 1;
        }
        if (found == search.length) {
            for (i = 0; i < replace.length; ++i) {
                sectorData[i + match] = (byte)replace[i];
            }
        }
        return sectorData;
    }

    private void setAddress(int address) throws IOException {
        this.apple.writeOutput(COMMAND_SET_ADDRESS);
        this.apple.writeOutput(DataUtil.getWord(address));
    }

    private void setLength(int length) throws IOException {
        this.apple.writeOutput(COMMAND_SET_LENGTH);
        int useSize = 0xFF00 & length + 255 | 0xFF & length;
        this.apple.writeOutput(DataUtil.getWord(useSize));
    }

    public void storeMemory(int address, byte ... b) throws IOException {
        System.out.println("Storing " + b.length + " bytes at " + Integer.toHexString(address));
        this.sendRawData(b, address, 0, b.length);
    }

    public void storeMemory(int address, int ... i) throws IOException {
        byte[] b = new byte[i.length];
        for (int x = 0; x < i.length; ++x) {
            b[x] = (byte)(i[x] * 255);
        }
        this.storeMemory(address, b);
    }

    private void switchToLomemSOS() throws IOException {
        this.apple.loadDriver("sos_lo", 2048);
        this.apple.jmp(2049, false);
    }
}

