/*
 * Decompiled with CFR 0.152.
 */
package ags.script;

import ags.script.BadVariableValueException;
import ags.script.Engine;
import ags.script.InitalizationException;
import ags.script.Variable;
import ags.script.exception.FatalScriptException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractCommand {
    public static Pattern variablePattern = Pattern.compile("\\{(.*?)\\}");
    private int lineNumber = 0;
    private Set requiredVariables = new HashSet();

    public void init(String[] args, int lineNumber) throws InitalizationException {
        this.lineNumber = lineNumber;
        try {
            this.init(args);
        }
        catch (InitalizationException ex) {
            throw new InitalizationException("Error on scipt line " + lineNumber + ": " + ex.getMessage());
        }
    }

    public Set getRequiredVariables() {
        return this.requiredVariables;
    }

    protected boolean getBoolean(String value, boolean defaultValue) {
        if (value == null || value.equals("")) {
            return defaultValue;
        }
        char val = value.toLowerCase().charAt(0);
        switch (val) {
            case '1': 
            case 't': 
            case 'y': {
                return true;
            }
        }
        return false;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    protected void trackVariableDependencies(String val) {
        if (val == null) {
            return;
        }
        Engine installer = Engine.getInstance();
        Matcher m = variablePattern.matcher(val);
        while (m.find()) {
            String varName = m.group(1);
            Variable var = Variable.getVariable(varName);
            this.requiredVariables.add(var);
            var.addDependency(this);
        }
    }

    protected String translateValue(String val) {
        if (val == null) {
            return null;
        }
        String newValue = new String(val);
        for (Variable v : this.requiredVariables) {
            if (!v.isInitalized()) continue;
            newValue = newValue.replaceAll("\\{" + v.getName() + "\\}", v.getValue());
        }
        Matcher m = variablePattern.matcher(newValue);
        if (m.find()) {
            return null;
        }
        return newValue;
    }

    protected void verifyFile(String file) throws BadVariableValueException {
        String useFile = this.translateValue(file);
    }

    protected void verifyDirectory(String file) throws BadVariableValueException {
        String useFile = this.translateValue(file);
        if (useFile != null) {
            if (useFile.indexOf(32) >= 0) {
                throw new BadVariableValueException(new FileNotFoundException("Please do not use path names with spaces.  This will break external command-line driven applications."));
            }
            File f = new File(useFile);
            if (!f.exists() || !f.isDirectory()) {
                throw new BadVariableValueException(new FileNotFoundException("Could not find directory " + useFile));
            }
        }
    }

    public void execute() throws FatalScriptException {
        for (Variable v : this.requiredVariables) {
            if (v.isInitalized()) continue;
            throw new FatalScriptException("Script uses uninitalized variable " + v.getName(), null);
        }
        try {
            this.checkPaths();
        }
        catch (BadVariableValueException ex) {
            throw new FatalScriptException("Error during last-minute validation check", ex);
        }
        this.doExecute();
    }

    protected static String promptUser(String prompt, String defaultValue) throws FatalScriptException {
        int retries = 100;
        try {
            while (retries > 0) {
                --retries;
                Engine.flushInput();
                Engine.getOut().print(prompt);
                if (defaultValue != null) {
                    Engine.getOut().println(" [" + defaultValue + "]");
                }
                Engine.getOut().print(">");
                Engine.flushOutput();
                String enteredValue = Engine.getIn().readLine();
                if (enteredValue == null || "".equals(enteredValue.trim())) {
                    enteredValue = defaultValue;
                }
                if (enteredValue != null) {
                    return enteredValue;
                }
                Engine.getOut().println("Input not understood.  Please try again.");
            }
        }
        catch (IOException ex) {
            throw new FatalScriptException("I/O Error when waiting to receive user input", ex);
        }
        throw new FatalScriptException("Failed to receive user input", null);
    }

    protected abstract void init(String[] var1) throws InitalizationException;

    public abstract void checkPaths() throws BadVariableValueException;

    protected abstract void doExecute() throws FatalScriptException;
}

