/*
 * Decompiled with CFR 0.152.
 */
package ags.script;

import ags.controller.Configurable;
import ags.script.BadVariableValueException;
import ags.script.InitalizationException;
import ags.script.Script;
import ags.script.Target;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;

public class Engine {
    @Configurable(category=Configurable.CATEGORY.ADVANCED, isRequired=false)
    public static boolean FLUSH_REQUIRES_NEWLINE = false;
    private static Engine instance = null;
    public static BufferedReader in = null;
    public static PrintStream out = null;
    Target errorHandler = null;
    Target gotoNext = null;

    public static BufferedReader getIn() {
        return in;
    }

    public static void flushInput() {
        try {
            while (in.ready()) {
                in.readLine();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void flushOutput() {
        if (FLUSH_REQUIRES_NEWLINE) {
            out.println();
        }
        out.flush();
    }

    public static PrintStream getOut() {
        return out;
    }

    public static PrintStream getLogOut() {
        return out;
    }

    public static void start(String script) {
        instance = new Engine();
        instance.init(script);
        instance.run();
    }

    public static Engine getInstance() {
        return instance;
    }

    private Engine() {
    }

    private void init(String script) {
        try {
            Script.parseScript(script);
            Target.verifyAll();
        }
        catch (BadVariableValueException ex) {
            ex.printStackTrace(Engine.getOut());
            System.exit(1);
        }
        catch (InitalizationException ex) {
            ex.printStackTrace(Engine.getOut());
            System.exit(1);
        }
    }

    private void run() {
        String targetName = Script.DEFAULT_TARGET;
        if (Script.USE_TARGET != null) {
            targetName = Script.USE_TARGET;
        }
        Target runMe = Target.getTarget(targetName);
        try {
            System.out.println("Executing script target " + targetName);
            if (runMe == null) {
                throw new Exception("Target " + targetName + " not found!");
            }
            runMe.call();
        }
        catch (Exception ex) {
            ex.printStackTrace(out);
            System.exit(1);
        }
    }

    public void setGotoNext(Target gotoNext) {
        this.gotoNext = gotoNext;
    }

    public Target getGotoNext() {
        return this.gotoNext;
    }

    public void setErrorHandler(Target errorHandler) {
        this.errorHandler = errorHandler;
    }

    public Target getErrorHandler() {
        return this.errorHandler;
    }

    static {
        in = new BufferedReader(new InputStreamReader(System.in));
        out = System.out;
    }
}

