/*
 * Decompiled with CFR 0.152.
 */
package ags.script;

import ags.controller.Configurable;
import ags.script.AbstractCommand;
import ags.script.InitalizationException;
import ags.script.Target;
import ags.script.commands.Baud;
import ags.script.commands.Call;
import ags.script.commands.Confirm;
import ags.script.commands.Echo;
import ags.script.commands.EchoCheck;
import ags.script.commands.Expect;
import ags.script.commands.ExpectPrompt;
import ags.script.commands.FlowControl;
import ags.script.commands.Goto;
import ags.script.commands.LegacyMode;
import ags.script.commands.OnError;
import ags.script.commands.Require;
import ags.script.commands.SendBinary;
import ags.script.commands.SendChar;
import ags.script.commands.SendMessage;
import ags.script.commands.SendText;
import ags.script.commands.SendTextBlind;
import ags.script.commands.SetVariable;
import ags.script.commands.Wait;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class Script {
    @Configurable(category=Configurable.CATEGORY.ADVANCED, isRequired=false)
    public static String DEFAULT_TARGET = "default";
    public static String USE_TARGET = null;

    private Script() {
    }

    public static void parseScript(String scriptPath) throws InitalizationException {
        InputStream in = null;
        File f = new File(scriptPath);
        if (f.exists() && f.isFile()) {
            try {
                in = new FileInputStream(f);
            }
            catch (FileNotFoundException ex) {
                in = null;
            }
        } else {
            in = ClassLoader.getSystemResourceAsStream(scriptPath);
        }
        if (in == null) {
            throw new InitalizationException("Specified script not found: " + scriptPath);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        Target defaultTarget = new Target(DEFAULT_TARGET);
        List currentTarget = defaultTarget.getCommands();
        String currentLine = null;
        int lineNumber = 0;
        try {
            while ((currentLine = reader.readLine()) != null) {
                String[] commandArgs;
                ++lineNumber;
                if (currentLine.indexOf(59) >= 0) {
                    currentLine = currentLine.substring(0, currentLine.indexOf(59));
                }
                if ((currentLine = currentLine.trim()).matches("^\\[.*?\\]$")) {
                    String targetName = currentLine.substring(1, currentLine.length() - 1);
                    Target t = new Target(targetName);
                    currentTarget = t.getCommands();
                    continue;
                }
                if (currentTarget == null || "".equals(currentLine) || (commandArgs = Script.splitCommand(currentLine)).length == 0) continue;
                Command command = null;
                try {
                    command = Command.valueOf(commandArgs[0]);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                if (command == null) {
                    throw new InitalizationException("Error parsing script " + scriptPath + " at line " + lineNumber + ": Unknown command '" + commandArgs[0] + "' -- full line = " + currentLine);
                }
                Class commandClass = command.getCommandClass();
                AbstractCommand newCommand = null;
                try {
                    newCommand = (AbstractCommand)commandClass.newInstance();
                }
                catch (InstantiationException ex) {
                    throw new InitalizationException("Error parsing script " + scriptPath + " at line " + lineNumber + ": " + ex.getMessage() + " -- full line = " + currentLine);
                }
                catch (IllegalAccessException ex) {
                    throw new InitalizationException("Error parsing script " + scriptPath + " at line " + lineNumber + ": " + ex.getMessage() + " -- full line = " + currentLine);
                }
                newCommand.init(commandArgs, lineNumber);
                currentTarget.add(newCommand);
            }
        }
        catch (IOException ex) {
            throw new InitalizationException("Error when reading script: " + ex.getMessage());
        }
    }

    public static String[] splitCommand(String line) {
        ArrayList<String> args = new ArrayList<String>();
        StringBuffer current = new StringBuffer();
        boolean inQuotes = false;
        boolean ignore = false;
        block4: for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            switch (c) {
                case ' ': {
                    if (inQuotes && !ignore) {
                        current.append(c);
                        continue block4;
                    }
                    ignore = false;
                    args.add(current.toString());
                    current = new StringBuffer();
                    continue block4;
                }
                case '\"': {
                    boolean bl = inQuotes = !inQuotes;
                    if (inQuotes) continue block4;
                    ignore = true;
                    continue block4;
                }
                default: {
                    if (ignore) continue block4;
                    current.append(c);
                }
            }
        }
        args.add(current.toString());
        return args.toArray(new String[0]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Command {
        baud(Baud.class),
        call(Call.class),
        confirm(Confirm.class),
        echo(Echo.class),
        echoCheck(EchoCheck.class),
        expect(Expect.class),
        expectPrompt(ExpectPrompt.class),
        flowControl(FlowControl.class),
        flow(FlowControl.class),
        jumpTo(Goto.class),
        jump(Goto.class),
        legacy(LegacyMode.class),
        legacyMode(LegacyMode.class),
        onError(OnError.class),
        require(Require.class),
        sendBinary(SendBinary.class),
        sendChar(SendChar.class),
        sendMessage(SendMessage.class),
        sendText(SendText.class),
        sendTextBlind(SendTextBlind.class),
        set(SetVariable.class),
        wait(Wait.class);

        private Class myclass;

        private Command(Class c) {
            this.myclass = c;
        }

        public Class getCommandClass() {
            return this.myclass;
        }
    }
}

