/*
 * Decompiled with CFR 0.152.
 */
package ags.script;

import ags.script.AbstractCommand;
import ags.script.BadVariableValueException;
import ags.script.Engine;
import ags.script.Variable;
import ags.script.commands.Require;
import ags.script.exception.FatalScriptException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Target {
    private static Map allTargets = new HashMap();
    private String name;
    private List commands;
    private boolean runAlready;

    public static Target getTarget(String name) {
        Target t = (Target)allTargets.get(name);
        return t;
    }

    static void verifyAll() throws BadVariableValueException {
        for (Target t : allTargets.values()) {
            for (AbstractCommand c : t.getCommands()) {
                for (Variable v : c.getRequiredVariables()) {
                    if (v.isAccountedFor()) continue;
                    throw new BadVariableValueException(new NullPointerException("Line " + c.getLineNumber() + " refers to a variable named " + v.getName() + " which is not initalized anywhere in the script!"));
                }
            }
        }
    }

    public Target(String name) {
        this.name = name;
        this.runAlready = false;
        this.commands = new ArrayList();
        allTargets.put(name, this);
    }

    public String getName() {
        return this.name;
    }

    public List getCommands() {
        return this.commands;
    }

    public boolean isRunAlready() {
        return this.runAlready;
    }

    public void require() throws Exception {
        if (this.runAlready) {
            return;
        }
        this.call();
    }

    public void call() throws Exception {
        this.runAlready = true;
        Engine.getLogOut().println("/* running target " + this.name + " */");
        for (AbstractCommand command : this.commands) {
            try {
                Engine.getLogOut().println("/* executing line " + command.getLineNumber() + " */");
                command.execute();
                if (Engine.getInstance().getGotoNext() == null) continue;
                Target t = Engine.getInstance().getGotoNext();
                Engine.getInstance().setGotoNext(null);
                t.call();
                return;
            }
            catch (FatalScriptException ex) {
                if (Engine.getInstance().getErrorHandler() != null) {
                    Engine.getOut().println("Error in line " + command.getLineNumber() + ": " + ex.getMessage());
                    Engine.getInstance().getErrorHandler().call();
                    return;
                }
                if (!(command instanceof Require)) {
                    Engine.getOut().println("Error in line " + command.getLineNumber() + ": " + ex.getMessage());
                }
                throw ex;
            }
        }
    }
}

