/*
 * Decompiled with CFR 0.152.
 */
package ags.script;

import ags.script.AbstractCommand;
import ags.script.BadVariableValueException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Variable {
    private static Map allVariables = new HashMap();
    private String name;
    private String description;
    private String value;
    private boolean initalized = false;
    private boolean accountedFor = false;
    private List dependencies;

    public static Variable getVariable(String varName) {
        Variable var = (Variable)allVariables.get(varName);
        if (var == null) {
            var = new Variable(varName);
        }
        return var;
    }

    public Variable(String name) {
        this.name = name;
        this.dependencies = new ArrayList();
        allVariables.put(name, this);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) throws BadVariableValueException {
        this.value = value;
        try {
            this.checkDependencies();
        }
        catch (BadVariableValueException ex) {
            this.initalized = false;
            this.value = null;
            throw ex;
        }
    }

    public boolean isInitalized() {
        return this.initalized;
    }

    public void setInitalized(boolean initalized) {
        this.initalized = initalized;
    }

    public void addDependency(AbstractCommand command) {
        this.dependencies.add(command);
    }

    public void checkDependencies() throws BadVariableValueException {
        for (AbstractCommand command : this.dependencies) {
            command.checkPaths();
        }
    }

    public boolean isAccountedFor() {
        return this.accountedFor;
    }

    public void setAccountedFor(boolean accountedFor) {
        this.accountedFor = accountedFor;
    }
}

