/*
 * Decompiled with CFR 0.152.
 */
package ags.script.commands;

import ags.script.AbstractCommand;
import ags.script.BadVariableValueException;
import ags.script.Engine;
import ags.script.InitalizationException;
import ags.script.Target;
import ags.script.exception.FatalScriptException;

public class Goto
extends AbstractCommand {
    String targetName;
    Target target;

    protected void init(String[] args) throws InitalizationException {
        if (args.length != 2) {
            throw new InitalizationException("Goto expects one argument, the name of the target to jump to");
        }
        this.targetName = args[1];
    }

    public void checkPaths() throws BadVariableValueException {
        this.target = Target.getTarget(this.targetName);
        if (this.target == null) {
            throw new BadVariableValueException(new Exception("Cannot find target named " + this.targetName));
        }
    }

    protected void doExecute() throws FatalScriptException {
        Engine.getInstance().setGotoNext(this.target);
    }
}

