/*
 * Decompiled with CFR 0.152.
 */
package ags.script.commands;

import ags.communication.GenericHost;
import ags.script.AbstractCommand;
import ags.script.BadVariableValueException;
import ags.script.Engine;
import ags.script.InitalizationException;
import ags.script.exception.FatalScriptException;
import java.io.IOException;

public class SendBinary
extends AbstractCommand {
    String file = "";
    String start = "";

    protected void init(String[] args) throws InitalizationException {
        if (args.length != 3) {
            throw new InitalizationException("SendBinary expects two arguments, the path of the binary file to send, and the target address");
        }
        this.start = args[2];
        this.file = args[1];
        this.trackVariableDependencies(this.file);
        try {
            this.checkPaths();
        }
        catch (BadVariableValueException ex) {
            ex.printStackTrace(Engine.getLogOut());
            throw new InitalizationException(ex.getMessage());
        }
    }

    public void checkPaths() throws BadVariableValueException {
        this.verifyFile(this.file);
    }

    protected void doExecute() throws FatalScriptException {
        GenericHost host = GenericHost.getInstance();
        try {
            host.typeHex(this.translateValue(this.file), this.start);
        }
        catch (IOException ex) {
            throw new FatalScriptException("Error when sending binary data", ex);
        }
    }
}

