/*
 * Decompiled with CFR 0.152.
 */
package ags.ui;

import ags.communication.DataUtil;
import ags.communication.TransferHost;
import ags.ui.HiresScreen;
import ags.ui.TextScreen40;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HiresBufferedScreen
extends HiresScreen {
    int activePage = 0;
    byte[][] lastScreen = new byte[2][8192];
    boolean[] isStale = new boolean[]{true, true};

    public int getDisplayOffset() {
        return this.activePage == 0 ? 8192 : 16384;
    }

    protected void copyScreen() {
        byte[] buffer = this.getBuffer();
        for (int i = 0; i < buffer.length; ++i) {
            this.lastScreen[this.activePage][i] = buffer[i];
        }
    }

    public void send(TransferHost host) {
        this.activePage = this.activePage == 0 ? 1 : 0;
        byte[] buffer = this.getBuffer();
        try {
            if (this.isStale[this.activePage]) {
                host.sendRawData(buffer, this.getDisplayOffset(), 0, buffer.length);
            } else {
                byte[] send = DataUtil.packScreenUpdate(this.getDisplayOffset(), this.lastScreen[this.activePage], buffer);
                host.sendCompressedData(send);
            }
            this.isStale[this.activePage] = false;
            this.copyScreen();
            this.activate(host);
            if (this.activePage == 0) {
                host.toggleSwitch(49236);
            } else {
                host.toggleSwitch(49237);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(TextScreen40.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

