/*
 * Decompiled with CFR 0.152.
 */
package ags.ui;

import ags.communication.TransferHost;
import ags.ui.IVirtualScreen;
import ags.ui.IWidget;
import java.util.ArrayList;
import java.util.List;

public abstract class IApplication {
    static final int MIN_CHANGE_DISTANCE = 2048;
    protected List<IWidget> widgets;
    protected List<IWidget> visible;
    private IVirtualScreen screen;
    protected int currentWidget = -1;
    protected byte[] lastScreen;

    public IApplication(IVirtualScreen s) {
        Thread.currentThread().setName("Game Selector");
        this.widgets = new ArrayList<IWidget>();
        this.visible = new ArrayList<IWidget>();
        this.setScreen(s);
        this.init();
    }

    public void redraw() {
        this.getScreen().clear();
        for (IWidget widget : this.visible) {
            widget.redraw();
        }
    }

    public void activate(IWidget w) {
        if (!this.visible.isEmpty()) {
            this.visible.get(this.visible.size() - 1).setActive(false);
        }
        w.setActive(true);
        w.moveToTop();
        this.currentWidget = this.widgets.indexOf(w);
    }

    public void addWidget(IWidget w) {
        this.widgets.add(w);
        this.visible.add(w);
    }

    public void moveToTop(IWidget w) {
        this.visible.remove(w);
        this.visible.add(w);
        if (this.currentWidget >= 0) {
            this.widgets.get(this.currentWidget).setActive(false);
        }
        this.currentWidget = this.widgets.indexOf(w);
        w.setActive(true);
    }

    public void moveToBottom(IWidget w) {
        this.moveToTop(this.visible.get(0));
        this.visible.remove(w);
        this.visible.add(0, w);
        this.currentWidget = this.widgets.indexOf(this.visible.get(this.visible.size() - 1));
        this.visible.get(this.visible.size() - 1).setActive(true);
        w.setActive(false);
    }

    public void removeWidget(IWidget w) {
        this.widgets.remove(w);
        this.visible.remove(w);
        w.setActive(false);
        if (this.currentWidget >= this.widgets.size()) {
            this.currentWidget = this.widgets.size() - 1;
        }
        if (this.currentWidget >= 0) {
            this.activate(this.widgets.get(this.currentWidget));
        }
    }

    public boolean handleKeypress(byte b) {
        if (this.handleGlobalKeypress(b)) {
            this.redraw();
            return true;
        }
        if (this.currentWidget >= 0 && this.widgets.get(this.currentWidget).handleKeypress(b)) {
            this.redraw();
            return true;
        }
        this.handleInvalidKeypress(b);
        return false;
    }

    protected abstract void init();

    protected abstract boolean handleGlobalKeypress(byte var1);

    protected abstract boolean handleInvalidKeypress(byte var1);

    public IVirtualScreen getScreen() {
        return this.screen;
    }

    public void setScreen(IVirtualScreen screen) {
        this.screen = screen;
    }

    public void activateScreen(TransferHost host) {
        this.screen.activate(host);
    }
}

