/*
 * Decompiled with CFR 0.152.
 */
package ags.ui.gameSelector;

import ags.controller.Configurable;
import ags.game.Game;
import ags.ui.FrameBasedWidget;
import ags.ui.IApplication;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameInfoWidget
extends FrameBasedWidget {
    @Configurable(category=Configurable.CATEGORY.RUNTIME, isRequired=false)
    public static String SCREENSHOTS_PATH = "screenshots";
    @Configurable(category=Configurable.CATEGORY.ADVANCED, isRequired=false)
    public static int SCREENSHOT_SMALL_WIDTH = 10;
    @Configurable(category=Configurable.CATEGORY.ADVANCED, isRequired=false)
    public static int SCREENSHOT_SMALL_HEIGHT = 8;
    static Game activeGame = null;
    int desiredHeight = 0;
    int inactiveHeight = 0;
    boolean screenViewMode = false;
    private int currentScreen = 0;
    boolean hasScreenshots = false;

    static void setActiveItem(Game g) {
        activeGame = g;
    }

    public void drawScreenshot(String filename, int x, int y, int xSize, int ySize) throws IOException {
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(SCREENSHOTS_PATH + "/" + filename);
        BufferedImage i = ImageIO.read(in);
        this.app.getScreen().drawImage(x, y, x + xSize, y + ySize, i);
    }

    @Override
    public void setYSize(int ySize) {
        this.setYSize(ySize, false);
    }

    public void setYSize(int ySize, boolean isDesired) {
        super.setYSize(ySize);
        if (!isDesired) {
            this.inactiveHeight = ySize;
        }
    }

    public GameInfoWidget(IApplication parentApp) {
        super(parentApp);
    }

    @Override
    public void redrawInside() {
        String title = "No game selected";
        String description = "Select a game below using the arrow keys.";
        List<String> screenshots = null;
        if (activeGame != null) {
            title = activeGame.getName();
            description = this.isEmpty(activeGame.getDescription()) ? "No description for this game." : activeGame.getDescription();
            screenshots = this.normalizeList(activeGame.getScreenshot());
            if (!this.isEmpty(activeGame.getAuthor())) {
                description = description + "\n\nPublisher: " + activeGame.getAuthor();
            }
            if (!this.isEmpty(activeGame.getYear())) {
                description = description + "\n\nYear: " + activeGame.getYear();
            }
        }
        this.app.getScreen().drawBox(this.getX(), this.getY(), this.getX() + this.getXSize() - 1, this.getY() + this.getYSize() - 1, false);
        this.app.getScreen().drawText((this.getXSize() - title.length()) / 2 + this.getX(), this.getY() - 1, title, true);
        String message = null;
        if (this.screenViewMode) {
            if (screenshots == null || screenshots.isEmpty()) {
                this.screenViewMode = false;
            } else {
                if (this.currentScreen >= screenshots.size()) {
                    this.currentScreen = 0;
                }
                message = "SPACE advances, V exits";
                String screen = screenshots.get(this.currentScreen);
                try {
                    this.drawScreenshot(screen, 1, 1, 38, 22);
                }
                catch (IOException ex) {
                    Logger.getLogger(GameInfoWidget.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        } else {
            int topWidth = this.getXSize();
            int topHeight = 0;
            this.desiredHeight = this.inactiveHeight;
            if (screenshots != null && !screenshots.isEmpty()) {
                this.hasScreenshots = true;
                topWidth -= SCREENSHOT_SMALL_WIDTH;
                topHeight = SCREENSHOT_SMALL_HEIGHT * screenshots.size();
                this.drawScreenshots(screenshots, this.getX() + this.getXSize() - SCREENSHOT_SMALL_WIDTH, this.getY(), SCREENSHOT_SMALL_WIDTH, SCREENSHOT_SMALL_HEIGHT);
                this.desiredHeight = screenshots.size() * 8;
            } else {
                this.hasScreenshots = false;
            }
            List<String> lines = this.formatString(description, topWidth, topHeight, this.getXSize());
            this.desiredHeight = Math.max(this.desiredHeight, lines.size());
            for (int i = 0; i < this.getYSize() && i < lines.size(); ++i) {
                this.app.getScreen().drawText(this.getX(), this.getY() + i, lines.get(i), false);
            }
            if (!this.isActive()) {
                if (this.desiredHeight != this.inactiveHeight || this.hasScreenshots) {
                    message = "(TAB for more)";
                }
            } else {
                message = "(TAB for less" + (this.hasScreenshots ? ", V to view screens)" : ")");
            }
        }
        if (message != null) {
            this.app.getScreen().drawText((this.getXSize() - message.length()) / 2 + this.getX(), this.getY() + this.getYSize(), message, true);
        }
    }

    @Override
    public boolean handleKeypress(byte b) {
        if (this.hasScreenshots && (b == 86 || b == 118)) {
            boolean bl = this.screenViewMode = !this.screenViewMode;
            if (this.screenViewMode) {
                this.setYSize(22, true);
            } else {
                this.setYSize(this.desiredHeight, true);
            }
            return true;
        }
        if (b == 32 && this.screenViewMode) {
            ++this.currentScreen;
            return true;
        }
        return false;
    }

    @Override
    public void setActive(boolean active) {
        this.screenViewMode = false;
        this.currentScreen = 0;
        if (active) {
            this.setYSize(this.desiredHeight, true);
        } else {
            this.setYSize(this.inactiveHeight, true);
        }
        super.setActive(active);
    }

    private void drawScreenshots(List<String> screenshots, int x, int y, int xSize, int ySize) {
        for (String filename : screenshots) {
            try {
                this.drawScreenshot(filename, x, y, xSize, ySize);
                y += ySize;
                if (this.isActive()) continue;
                break;
            }
            catch (IOException ex) {
                Logger.getLogger(GameInfoWidget.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private List<String> formatString(String s, int topWidth, int topHeight, int mainWidth) {
        ArrayList<String> output = new ArrayList<String>();
        int useWidth = topWidth;
        ArrayList<String> reformat = new ArrayList<String>();
        String last = "";
        for (String line : s.split("\n")) {
            if ((line = line.trim()).length() == 0) {
                reformat.add(last);
                last = "";
                continue;
            }
            if (last.length() > 0) {
                last = last + " ";
            }
            last = last + line;
        }
        if (last.length() > 0) {
            reformat.add(last);
        }
        for (String line : reformat) {
            while (line.length() > 0) {
                if (line.length() <= useWidth) {
                    output.add(line);
                    line = "";
                } else {
                    int stop = line.lastIndexOf(32, useWidth);
                    output.add(line.substring(0, stop));
                    line = line.substring(stop + 1);
                }
                if (output.size() != topHeight) continue;
                useWidth = mainWidth;
            }
        }
        return output;
    }

    private boolean isEmpty(String s) {
        return s == null || "".equals(s);
    }

    private List<String> normalizeList(List<String> l) {
        if (l == null) {
            return l;
        }
        l = new ArrayList<String>(l);
        Iterator<String> i = l.iterator();
        while (i.hasNext()) {
            String value = i.next();
            if (!this.isEmpty(value)) continue;
            i.remove();
        }
        return l;
    }
}

