/*
 * Decompiled with CFR 0.152.
 */
package ags.ui.gameSelector;

import ags.communication.GenericHost;
import ags.game.Game;
import ags.ui.FrameBasedWidget;
import ags.ui.IApplication;
import ags.ui.gameSelector.GameInfoWidget;
import java.util.ArrayList;
import java.util.List;

public class GameResultsWidget
extends FrameBasedWidget {
    List<Game> results = new ArrayList<Game>();
    int activeItem;
    Game selection = null;

    public GameResultsWidget(IApplication a) {
        super(a);
    }

    public void redrawInside() {
        if (this.selection == null) {
            int i;
            String message = "Showing " + this.results.size() + " result";
            if (this.results.size() != 1) {
                message = message + "s";
            }
            this.app.getScreen().drawText((this.getXSize() - message.length()) / 2 + this.getX(), this.getY() - 1, message, true);
            message = "(Press ESC to search)";
            this.app.getScreen().drawText((this.getXSize() - message.length()) / 2 + this.getX(), this.getY() + this.getYSize(), message, true);
            int showStart = this.activeItem - this.getYSize() / 2;
            showStart = Math.max(0, showStart);
            int currentIndex = showStart = Math.min(showStart, Math.max(0, this.results.size() - this.getYSize()));
            for (i = 0; i < this.getYSize() && currentIndex < this.results.size(); ++currentIndex, ++i) {
                boolean hilight = currentIndex == this.activeItem;
                String name = this.results.get(currentIndex).getName();
                if (this.results.get(currentIndex).getType().equalsIgnoreCase("fc")) {
                    name = name + " (basic)";
                }
                if (this.results.get(currentIndex).getType().equalsIgnoreCase("disk")) {
                    name = name + " (disk)";
                }
                this.app.getScreen().drawText(this.getX(), this.getY() + i, name, hilight);
            }
            for (i = this.getY(); i < this.getY() + this.getYSize(); ++i) {
                this.app.getScreen().drawText(this.getX() + this.getXSize() - 1, i, "|", false);
            }
            if (this.results.size() > 0) {
                int scrollSize = this.getYSize() / this.results.size() + 1;
                int scrollStart = this.getY() + showStart * this.getYSize() / this.results.size();
                scrollStart = Math.min(scrollStart, this.getY() + this.getYSize() - scrollSize - 1);
                this.app.getScreen().drawBox(this.getX() + this.getXSize() - 1, scrollStart, this.getX() + this.getXSize() - 1, scrollStart + scrollSize, true);
            }
        } else {
            this.app.getScreen().drawText(this.getX(), this.getY(), "--> Loading game <--", true);
            this.app.getScreen().drawText(this.getX(), this.getY() + 1, this.selection.getName(), false);
            this.app.getScreen().drawText(this.getX(), this.getY() + 2, "Starting Address: " + this.selection.getStart(), false);
        }
    }

    public boolean handleKeypress(byte b) {
        boolean legacy = GenericHost.isLegacyMode();
        if (b == 11 || legacy && b == 8) {
            --this.activeItem;
        } else if (b == 10 || legacy && b == 21) {
            ++this.activeItem;
        } else if (b == 13) {
            this.executeSelection();
        } else if (b == 91 || !legacy && b == 8) {
            this.activeItem -= (this.getYSize() - 1) / 2;
        } else if (b == 93 || !legacy && b == 21) {
            this.activeItem += (this.getYSize() - 1) / 2;
        } else if (b >= 65 && b <= 90 || b >= 97 && b <= 122) {
            if (b >= 97) {
                b = (byte)(b - 32);
            }
            this.activeItem = 0;
            for (Game g : this.results) {
                if (g.getName().toUpperCase().charAt(0) >= b) break;
                ++this.activeItem;
            }
        } else {
            return false;
        }
        this.activeItem = Math.max(0, this.activeItem);
        this.activeItem = Math.min(this.activeItem, Math.max(0, this.results.size() - 1));
        GameInfoWidget.setActiveItem(this.results.get(this.activeItem));
        return true;
    }

    public void executeSelection() {
        this.selection = this.results.get(this.activeItem);
    }
}

