/*
 * Decompiled with CFR 0.152.
 */
package ags.ui.gameSelector;

import ags.ui.FrameBasedWidget;
import ags.ui.IApplication;

public class TextWidget
extends FrameBasedWidget {
    String value = "";
    int cursor = 0;

    public TextWidget(IApplication app) {
        super(app);
        this.setYSize(1);
    }

    public boolean handleKeypress(byte b) {
        switch (b) {
            case 11: {
                this.cursor = 0;
                return true;
            }
            case 21: {
                this.cursor = Math.min(this.cursor + 1, this.value.length());
                this.cursor = Math.min(this.getXSize(), this.cursor);
                return true;
            }
            case 10: {
                this.cursor = Math.min(this.getXSize(), this.value.length());
                return true;
            }
            case 8: {
                this.cursor = Math.max(0, this.cursor - 1);
                return true;
            }
            case 4: {
                if (this.cursor < this.value.length()) {
                    this.value = this.value.substring(0, this.cursor) + this.value.substring(this.cursor + 1);
                } else if (this.value.length() > 0) {
                    this.value = this.value.substring(0, this.value.length() - 1);
                    this.cursor = Math.max(this.cursor - 1, 0);
                }
                return true;
            }
            case 127: {
                if (this.cursor == 0) {
                    return true;
                }
                if (this.cursor < this.value.length() - 1) {
                    this.value = this.value.substring(0, this.cursor - 1) + this.value.substring(this.cursor);
                    this.cursor = Math.max(this.cursor - 1, 0);
                } else if (this.value.length() > 0) {
                    this.value = this.value.substring(0, this.value.length() - 1);
                    this.cursor = Math.max(this.cursor - 1, 0);
                }
                return true;
            }
        }
        char c = (char)b;
        if (c >= ' ' && c <= '\u007f') {
            if (this.cursor == this.value.length() && this.cursor < this.getXSize()) {
                this.value = this.value + c;
                ++this.cursor;
                return true;
            }
            if (this.value.length() < this.getXSize()) {
                this.value = this.value.substring(0, this.cursor) + c + this.value.substring(this.cursor);
                ++this.cursor;
                return true;
            }
        }
        return false;
    }

    public void setValue(String value) {
        if (value == null) {
            value = "";
        }
        this.value = value;
        this.cursor = value.length();
    }

    public String getValue() {
        return this.value;
    }

    public void redrawInside() {
        if (this.isActive()) {
            String val1 = this.value.substring(0, this.cursor);
            String val2 = " ";
            if (this.cursor < this.value.length()) {
                val2 = this.value.substring(this.cursor, this.cursor + 1);
            }
            String val3 = " ";
            if (this.cursor < this.value.length() - 1) {
                val3 = this.value.substring(this.cursor + 1);
            }
            if (!"".equals(val1)) {
                this.app.getScreen().drawText(this.getX(), this.getY(), val1, false);
            }
            this.app.getScreen().drawText(this.getX() + this.cursor, this.getY(), val2, true);
            if (!"".equals(val3)) {
                this.app.getScreen().drawText(this.getX() + this.cursor + 1, this.getY(), val3, false);
            }
        } else if (!"".equals(this.value)) {
            this.app.getScreen().drawText(this.getX(), this.getY(), this.value, false);
        }
    }
}

