/*
 * Decompiled with CFR 0.152.
 */
package ags.ui.graphics;

import ags.ui.graphics.ImageBuffer;
import ags.ui.graphics.Palette;
import ags.ui.graphics.Palette16;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class DHGRImage
implements ImageBuffer {
    int[][] colorMask;
    int[][] colorPattern;
    int[] pageOffset;
    Palette palette;
    int targetWidth = 140;
    int targetHeight = 192;
    private byte[] rawData = new byte[16384];

    public DHGRImage() {
        this.pageOffset = new int[]{0, 8192, 1, 8193};
        this.palette = new Palette16();
        this.colorMask = new int[][]{{15, 0, 0, 0}, {112, 1, 0, 0}, {0, 30, 0, 0}, {0, 96, 3, 0}, {0, 0, 60, 0}, {0, 0, 64, 7}, {0, 0, 0, 120}};
        this.colorPattern = new int[][]{{0, 0, 0, 0}, {8, 17, 34, 68}, {17, 34, 68, 8}, {25, 51, 102, 76}, {34, 68, 8, 17}, {42, 85, 42, 85}, {51, 102, 76, 25}, {59, 119, 110, 93}, {68, 8, 17, 34}, {76, 25, 51, 102}, {85, 42, 85, 42}, {93, 59, 119, 110}, {102, 76, 25, 51}, {110, 93, 59, 119}, {119, 110, 93, 59}, {127, 127, 127, 127}};
    }

    public void readColorImage(String file) throws IOException {
        File f = new File(file);
        BufferedImage i = ImageIO.read(f);
        Image s = i.getScaledInstance(this.targetWidth, this.targetHeight, 4);
        BufferedImage b = new BufferedImage(this.targetWidth, this.targetHeight, 1);
        b.getGraphics().drawImage(s, 0, 0, null);
        ImageIO.write((RenderedImage)b, "bmp", new File("/apple2e/test_image.bmp"));
        for (int y = 0; y < this.targetHeight; ++y) {
            for (int x = 0; x < this.targetWidth; ++x) {
                int color = this.palette.findColor(b.getRGB(x, y));
                this.plotColor(x, y, color);
            }
        }
    }

    public int calcYOffset(int i) {
        int a = i % 8 * 1024;
        int y = i / 8;
        return 128 * (y % 8) + 40 * (y / 8) + a;
    }

    public void plotColor(int x, int y, int color) {
        int yOffset = this.calcYOffset(y);
        int xOffset = x / 7 * 2;
        int maskOffset = x % 7;
        for (int i = 0; i < 4; ++i) {
            int offset = this.pageOffset[i] + xOffset + yOffset;
            int mask = this.colorMask[maskOffset][i];
            int oldByte = this.rawData[offset] & 0xFF;
            int pattern = this.colorPattern[color][i];
            this.rawData[offset] = (byte)(oldByte & (0xFF ^ mask) | pattern & mask);
            if (y % 2 != 0) continue;
            this.rawData[offset] = (byte)(this.rawData[offset] | 0x80);
        }
    }

    public byte[] getAppleImage() {
        return this.rawData;
    }

    public void setTargetSize(int x, int y) {
        this.targetWidth = x;
        this.targetHeight = y;
    }
}

