/*
 * Decompiled with CFR 0.152.
 */
package ags.ui.graphics;

import ags.ui.graphics.ColorYIQ;
import ags.ui.graphics.ImageBuffer;
import ags.ui.graphics.Palette6;
import ags.ui.graphics.PaletteYIQ;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.IndexColorModel;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class HGRImage
implements ImageBuffer {
    int[] colorMask;
    int[][] colorPattern;
    PaletteYIQ palette;
    int targetWidth = 280;
    int targetHeight = 192;
    File currentDirectory = null;
    private byte[] rawData = new byte[8192];

    public HGRImage() {
        this.palette = new Palette6();
        this.colorMask = new int[]{129, 130, 132, 136, 144, 160, 192};
        this.colorPattern = new int[][]{{0, 0}, {42, 85}, {85, 42}, {127, 127}, {128, 128}, {213, 170}, {170, 213}, {255, 255}};
    }

    public void readColorImage(String file) throws IOException {
        File f = new File(file);
        this.currentDirectory = f.getParentFile();
        BufferedImage i = ImageIO.read(f);
        this.convertColorImage(i);
    }

    public void convertColorImage(Image i) throws IOException {
        Image s = i.getScaledInstance(this.targetWidth, this.targetHeight, 2);
        BufferedImage source = new BufferedImage(this.targetWidth, this.targetHeight, 13, this.getColorModel());
        source.getGraphics().drawImage(s, 0, 0, null);
        DataBuffer raster = source.getRaster().getDataBuffer();
        for (int y = 0; y < this.targetHeight; ++y) {
            for (int x = 0; x < this.targetWidth; ++x) {
                int color = raster.getElem(y * this.targetWidth + x);
                this.plotColor(x, y, color);
            }
        }
    }

    public int calcYOffset(int i) {
        int a = i % 8 * 1024;
        int y = i / 8;
        return 128 * (y % 8) + 40 * (y / 8) + a;
    }

    public void plotColor(int x, int y, int color) {
        int yOffset = this.calcYOffset(y);
        int xOffset = x / 7;
        int maskOffset = x % 7;
        int i = x / 7 % 2;
        int offset = xOffset + yOffset;
        int mask = this.colorMask[maskOffset];
        if (color % 4 == 0 || color % 4 == 3) {
            mask &= 0x7F;
        }
        int oldByte = this.rawData[offset] & 0xFF;
        int pattern = this.colorPattern[color][i];
        this.rawData[offset] = (byte)(oldByte & (0xFF ^ mask) | pattern & mask);
    }

    public byte[] getAppleImage() {
        return this.rawData;
    }

    public void setTargetSize(int x, int y) {
        this.targetWidth = x;
        this.targetHeight = y;
    }

    private IndexColorModel getColorModel() {
        byte[] r = new byte[this.palette.colors.size()];
        byte[] g = new byte[this.palette.colors.size()];
        byte[] b = new byte[this.palette.colors.size()];
        for (int i = 0; i < this.palette.colors.size(); ++i) {
            int color = this.palette.getColor(i).toRGB();
            r[i] = (byte)ColorYIQ.getR(color);
            g[i] = (byte)ColorYIQ.getG(color);
            b[i] = (byte)ColorYIQ.getB(color);
        }
        IndexColorModel colorModel = new IndexColorModel(8, this.palette.colors.size(), r, g, b);
        return colorModel;
    }
}

