/*
 * Decompiled with CFR 0.152.
 */
package ags.ui.graphics;

import ags.ui.graphics.Palette;
import ags.ui.graphics.Palette16;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Palette48
extends Palette {
    private Map<Integer, Integer[]> appleColorIndex;

    @Override
    protected void initPalette() {
        this.MATCH_TOLERANCE = 16;
        this.appleColorIndex = new HashMap<Integer, Integer[]>();
        Palette16 p16 = new Palette16();
        List<String> patterns = this.getBlendPatterns();
        int max_diff = COLOR_DISTANCE_MAX / 3;
        for (int y = 0; y < 16; ++y) {
            for (int x = 0; x < 16; ++x) {
                if (x > y || !(this.distance(p16.getColor(y), p16.getColor(x)) <= (double)max_diff)) continue;
                this.appleColorIndex.put(this.colors.size(), new Integer[]{x, y});
                this.addColor(this.blend(p16.getColor(y), p16.getColor(x)));
            }
        }
        System.out.println("Built a palette with " + this.colors.size() + " colors");
    }

    public Integer[] getAppleColors(int color) {
        return this.appleColorIndex.get(color);
    }

    private List<String> getBlendPatterns() {
        ArrayList<String> patterns = new ArrayList<String>();
        patterns.add("#...............");
        patterns.add(".#..............");
        patterns.add("###.............");
        patterns.add("...#............");
        patterns.add("###.#...........");
        patterns.add("###.##..........");
        patterns.add(".######.........");
        patterns.add("...#.#.#........");
        patterns.add("#.#.###.#.......");
        patterns.add("...#...#.#......");
        patterns.add("###.###.#.#.....");
        patterns.add("...#...#.#.#....");
        patterns.add("...#..##.#.##...");
        patterns.add("...#..#..#.###..");
        patterns.add("...#..##.#.####.");
        patterns.add(".......#.....#.#");
        return patterns;
    }

    private int[] blend(int[] c1, int[] c2) {
        int[] newColor = new int[]{(c1[0] + c2[0]) / 2, (c1[1] + c2[1]) / 2, (c1[2] + c2[2]) / 2};
        return newColor;
    }
}

