/*
 * Decompiled with CFR 0.152.
 */
package ags.ui.host;

import ags.controller.Configurable;
import ags.controller.Configurator;
import ags.controller.FileType;
import ags.ui.host.BooleanComponent;
import ags.ui.host.EnumSelectComponent;
import ags.ui.host.FileComponent;
import ags.ui.host.IntegerComponent;
import ags.ui.host.StringComponent;
import ags.ui.host.Style;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.jdesktop.layout.GroupLayout;

public class ConfigPanel
extends JFrame {
    public ConfigPanel() {
        this.generateForm();
        this.validate();
    }

    private Component generateEditComponent(Field f) {
        if (f.getType().isEnum()) {
            return new EnumSelectComponent(f);
        }
        if (f.getType().equals(Boolean.TYPE)) {
            return new BooleanComponent(f);
        }
        if (f.getType().equals(Integer.TYPE)) {
            return new IntegerComponent(f);
        }
        if (f.getType().equals(String.class)) {
            if (f.getAnnotation(FileType.class) != null) {
                return new FileComponent(f);
            }
            return new StringComponent(f);
        }
        return new JLabel("Unknown type: " + f.getType().getCanonicalName());
    }

    private void generateForm() {
        HashMap<Configurable.CATEGORY, ArrayList<Field>> fields = new HashMap<Configurable.CATEGORY, ArrayList<Field>>();
        JTabbedPane tabPane = new JTabbedPane();
        Style.apply(tabPane);
        List<Field> allFields = Configurator.findVariables();
        for (Field f : allFields) {
            Configurable annotation = Configurator.getAnnotation(f);
            Configurable.CATEGORY cat = annotation.category();
            ArrayList<Field> catList = (ArrayList<Field>)fields.get((Object)cat);
            if (catList == null) {
                catList = new ArrayList<Field>();
                fields.put(cat, catList);
            }
            catList.add(f);
        }
        for (Configurable.CATEGORY c : Configurable.CATEGORY.values()) {
            JPanel categoryPanel = new JPanel();
            tabPane.add(c.name(), categoryPanel);
            GroupLayout layout = new GroupLayout(categoryPanel);
            categoryPanel.setLayout(layout);
            GroupLayout.ParallelGroup horizontalGroup1 = layout.createParallelGroup();
            GroupLayout.ParallelGroup horizontalGroup2 = layout.createParallelGroup();
            GroupLayout.SequentialGroup verticalGroup = layout.createSequentialGroup();
            List fieldList = (List)fields.get((Object)c);
            if (fieldList == null) {
                System.err.println("Category " + c.name() + " came back with nothing");
            } else {
                for (Field f : fieldList) {
                    JLabel fieldLabel = new JLabel(f.getName());
                    Component editComponent = this.generateEditComponent(f);
                    Style.apply(fieldLabel);
                    Style.apply(editComponent);
                    verticalGroup.add(layout.createParallelGroup(3).add(fieldLabel).add(editComponent));
                    horizontalGroup1.add(fieldLabel);
                    horizontalGroup2.add(editComponent);
                }
            }
            layout.setVerticalGroup(verticalGroup);
            layout.setHorizontalGroup(layout.createSequentialGroup().add(horizontalGroup1).add(horizontalGroup2));
            categoryPanel.validate();
            Style.apply(categoryPanel);
        }
        JPanel mainPanel = new JPanel();
        GroupLayout mainLayout = new GroupLayout(mainPanel);
        JButton saveChanges = new JButton("Save");
        saveChanges.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigPanel.this.doSaveChanges();
            }
        });
        JButton cancelChanges = new JButton("Cancel");
        cancelChanges.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigPanel.this.doCancelChanges();
            }
        });
        mainLayout.setHorizontalGroup(mainLayout.createParallelGroup(4).add(tabPane).add(mainLayout.createSequentialGroup().add(saveChanges).add(cancelChanges)));
        mainLayout.setVerticalGroup(mainLayout.createSequentialGroup().add(tabPane).add(mainLayout.createParallelGroup().add(cancelChanges).add(saveChanges)));
        Container c = this.getContentPane();
        c.add(mainPanel);
        this.setContentPane(c);
        Dimension size = mainLayout.preferredLayoutSize(mainPanel);
        size.width += 20;
        size.height += 50;
        this.setPreferredSize(size);
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b) {
            System.out.println("tweaking size");
            this.setSize(this.getPreferredSize());
        }
    }

    private void doSaveChanges() {
        Configurator.saveValues();
        this.setVisible(false);
    }

    private void doCancelChanges() {
        Configurator.revertDefaults();
        this.setVisible(false);
    }

    public static void main(String[] args) {
        Style.applyDefaults();
        ConfigPanel test = new ConfigPanel();
        test.setDefaultCloseOperation(3);
        test.setVisible(true);
    }
}

