/*
 * Decompiled with CFR 0.152.
 */
package ags.ui.host;

import ags.controller.Configurator;
import ags.controller.Launcher;
import ags.ui.host.ConfigPanel;
import ags.ui.host.Style;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.jdesktop.layout.GroupLayout;

public class Main
extends JFrame {
    public static Main instance;
    ConfigPanel c;
    static Font dialogFont;
    public JLabel banner;
    public JLabel footer;
    public JTextArea logDisplay;
    public JScrollPane logScroll;
    public Panel panel1;
    public JButton settingsButton;
    public JButton startStopButton;
    Point[] stars;
    BufferedImage i;

    public Main() {
        Configurator.loadValues();
        this.initComponents();
        this.initStarfield();
        instance = this;
        this.c = new ConfigPanel();
        Style.apply(this.logDisplay);
        Style.apply(this.logScroll);
    }

    private void initComponents() {
        this.panel1 = new Panel();
        this.logScroll = new JScrollPane();
        this.logDisplay = new JTextArea();
        this.banner = new JLabel();
        this.settingsButton = new JButton();
        this.footer = new JLabel();
        this.startStopButton = new JButton();
        this.setDefaultCloseOperation(3);
        this.setTitle("Apple Game Server 3.0");
        this.setBackground(Color.black);
        this.setCursor(new Cursor(1));
        this.setForeground(Color.black);
        this.panel1.setBackground(Color.black);
        this.panel1.addHierarchyBoundsListener(new HierarchyBoundsListener(){

            public void ancestorMoved(HierarchyEvent evt) {
            }

            public void ancestorResized(HierarchyEvent evt) {
                Main.this.resizeStarfield(evt);
            }
        });
        this.logScroll.setBackground(Color.green);
        this.logScroll.setForeground(Color.white);
        this.logScroll.setToolTipText("Double-click to clear");
        this.logScroll.setHorizontalScrollBar(null);
        this.logDisplay.setBackground(Color.black);
        this.logDisplay.setLineWrap(true);
        this.logDisplay.setSelectedTextColor(new Color(0, 0, 0));
        this.logDisplay.setSelectionColor(Color.orange);
        this.logDisplay.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Main.this.logDisplayMouseClicked(evt);
            }
        });
        this.logScroll.setViewportView(this.logDisplay);
        this.banner.setHorizontalAlignment(0);
        this.banner.setIcon(new ImageIcon(this.getClass().getResource("/ags/resources/logo_banner.png")));
        this.banner.setToolTipText("Apple Game Server v3");
        this.banner.setFocusable(false);
        this.banner.setHorizontalTextPosition(0);
        this.banner.setIconTextGap(0);
        this.settingsButton.setBackground(new Color(1, 1, 1));
        this.settingsButton.setFont(Main.getAppleFont());
        this.settingsButton.setForeground(new Color(254, 254, 254));
        this.settingsButton.setText("Edit Settings");
        this.settingsButton.setToolTipText("Edit settings and save new default settings before launching");
        this.settingsButton.setBorder(BorderFactory.createEtchedBorder(new Color(30, 255, 0), new Color(255, 0, 251)));
        this.settingsButton.setContentAreaFilled(false);
        this.settingsButton.setDefaultCapable(false);
        this.settingsButton.setFocusable(false);
        this.settingsButton.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent evt) {
                Main.this.settingsButtonMouseEntered(evt);
            }

            public void mouseExited(MouseEvent evt) {
                Main.this.settingsButtonMouseExited(evt);
            }
        });
        this.settingsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Main.this.settingsButtonActionPerformed(evt);
            }
        });
        this.footer.setHorizontalAlignment(0);
        this.footer.setIcon(new ImageIcon(this.getClass().getResource("/ags/resources/credits.png")));
        this.footer.setToolTipText("<html>Game descriptions provided mobygames.com<br>\nGreetings to the regulars on comp.sys.apple2 and<br>\nretro-computing enthusiasts everywhere!<br><br>\n][ INFINITUM!");
        this.footer.setFocusable(false);
        this.footer.setHorizontalTextPosition(0);
        this.footer.setIconTextGap(0);
        this.startStopButton.setBackground(new Color(1, 1, 1));
        this.startStopButton.setFont(Main.getAppleFont());
        this.startStopButton.setForeground(new Color(254, 254, 254));
        this.startStopButton.setText("Start Program");
        this.startStopButton.setToolTipText("Don't forget to get your Apple ][ ready first! :-)");
        this.startStopButton.setBorder(BorderFactory.createEtchedBorder(new Color(30, 255, 0), new Color(255, 0, 251)));
        this.startStopButton.setContentAreaFilled(false);
        this.startStopButton.setFocusPainted(false);
        this.startStopButton.setFocusable(false);
        this.startStopButton.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent evt) {
                Main.this.startStopButtonMouseEntered(evt);
            }

            public void mouseExited(MouseEvent evt) {
                Main.this.startStopButtonMouseExited(evt);
            }
        });
        this.startStopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Main.this.startStopButtonActionPerformed(evt);
            }
        });
        GroupLayout panel1Layout = new GroupLayout(this.panel1);
        this.panel1.setLayout(panel1Layout);
        panel1Layout.setHorizontalGroup(panel1Layout.createParallelGroup(1).add(this.banner, -1, 486, Short.MAX_VALUE).add(this.footer, -1, 486, Short.MAX_VALUE).add(panel1Layout.createSequentialGroup().addContainerGap().add(this.logScroll, -1, 474, Short.MAX_VALUE).addContainerGap()).add(2, panel1Layout.createSequentialGroup().add(115, 115, 115).add(panel1Layout.createParallelGroup(1).add(2, this.settingsButton, -1, 260, Short.MAX_VALUE).add(2, this.startStopButton, -1, 260, Short.MAX_VALUE)).add(111, 111, 111)));
        panel1Layout.setVerticalGroup(panel1Layout.createParallelGroup(1).add(panel1Layout.createSequentialGroup().add(this.banner, -2, 65, -2).addPreferredGap(0).add(this.settingsButton, -2, 24, -2).add(18, 18, 18).add(this.startStopButton, -2, 26, -2).addPreferredGap(0).add(this.logScroll, -1, 101, Short.MAX_VALUE).addPreferredGap(0).add(this.footer, -2, 65, -2)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(this.panel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(this.panel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void initStarfieldImage() {
        this.i = new BufferedImage(this.panel1.getWidth(), this.panel1.getHeight(), 1);
    }

    private void settingsButtonMouseEntered(MouseEvent evt) {
        this.settingsButton.setBackground(Color.WHITE);
        this.settingsButton.setForeground(Color.BLACK);
        this.settingsButton.setContentAreaFilled(true);
    }

    private void settingsButtonMouseExited(MouseEvent evt) {
        this.settingsButton.setBackground(Color.BLACK);
        this.settingsButton.setForeground(Color.WHITE);
        this.settingsButton.setContentAreaFilled(false);
    }

    private void startStopButtonMouseEntered(MouseEvent evt) {
        this.startStopButton.setBackground(Color.WHITE);
        this.startStopButton.setForeground(Color.BLACK);
        this.startStopButton.setContentAreaFilled(true);
    }

    private void startStopButtonMouseExited(MouseEvent evt) {
        this.startStopButton.setBackground(Color.BLACK);
        this.startStopButton.setForeground(Color.WHITE);
        this.startStopButton.setContentAreaFilled(false);
    }

    private void settingsButtonActionPerformed(ActionEvent evt) {
        this.c.setVisible(true);
    }

    private void startStopButtonActionPerformed(ActionEvent evt) {
        Launcher.startStop();
    }

    private void resizeStarfield(HierarchyEvent evt) {
        this.initStarfieldImage();
    }

    private void logDisplayMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.logDisplay.setText("");
        }
    }

    public static void main(String[] args) {
        Style.applyDefaults();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new Main().setVisible(true);
            }
        });
    }

    public static Font getAppleFont() {
        if (dialogFont == null) {
            try {
                InputStream fontInputStream = Main.class.getResourceAsStream("/ags/resources/a2like.ttf");
                Font base = Font.createFont(0, fontInputStream);
                dialogFont = base.deriveFont(0, 16.0f);
            }
            catch (FontFormatException ex) {
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return dialogFont;
    }

    private void moveStars() {
        for (Point star : this.stars) {
            star.y += star.speed;
            if (!(star.y > (double)this.panel1.getHeight())) continue;
            star.randomize(this.panel1.getWidth());
        }
    }

    private void initStarfield() {
        int i;
        this.initStarfieldImage();
        this.stars = new Point[40];
        for (i = 0; i < this.stars.length; ++i) {
            this.stars[i] = new Point(this.panel1.getWidth());
        }
        for (i = 0; i < 100; ++i) {
            this.moveStars();
        }
        Thread t = new Thread(new Runnable(){

            public void run() {
                while (true) {
                    Main.this.moveStars();
                    Main.this.repaint();
                    try {
                        Thread.sleep(33L);
                        continue;
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                        continue;
                    }
                    break;
                }
            }
        });
        t.setDaemon(true);
        t.start();
    }

    public void drawStars() {
        Graphics g = this.i.getGraphics();
        g.clearRect(0, 0, this.panel1.getWidth(), this.panel1.getHeight());
        this.panel1.paint(g);
        for (Point star : this.stars) {
            switch (star.color) {
                case 0: {
                    g.setColor(Color.WHITE);
                    break;
                }
                case 1: {
                    g.setColor(Color.BLUE);
                    break;
                }
                case 2: {
                    g.setColor(Color.ORANGE);
                    break;
                }
                case 3: {
                    g.setColor(Color.GREEN);
                }
            }
            g.drawRect(star.x, (int)star.y, 1, 1);
        }
        g.dispose();
        g = this.panel1.getGraphics();
        g.drawImage(this.i, 0, 0, null);
        g.dispose();
    }

    public void repaint() {
        super.repaint();
        this.drawStars();
    }

    static {
        dialogFont = null;
    }

    private class Point {
        int x;
        double y;
        double speed;
        int color;

        public Point(int xSize) {
            this.randomize(xSize);
        }

        void randomize(int xSize) {
            this.y = 0.0;
            this.x = (int)(Math.random() * (double)xSize);
            this.speed = Math.random() * 10.0 + 0.5;
            this.color = (int)(Math.random() * 4.0);
        }
    }
}

