; Installer script for GTK+ Runtime Environment
; Herman Bloggs <hermanator12002@yahoo.com>

; NOTE: this .NSI script is intended for NSIS v2.0 (final release).

;--------------------------------
;Globals
Var LANG_IS_SET
Var NOUI

;--------------------------------
;Configuration

Name "GTK+ ${GTK_VERSION} Rev ${GTK_REVISION}"
OutFile "gtk-runtime-${GTK_VERSION}-rev-${GTK_REVISION}.exe"
SetCompressor /SOLID lzma
ShowInstDetails show
ShowUninstDetails show
SetDateSave on

; $INSTDIR is set in .onInit function..

!include "MUI.nsh"

;--------------------------------
;Defines

!define GTK_REG_KEY       "SOFTWARE\GTK\2.0"
!define GTK_UNINSTALL_KEY "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\GTK 2.0"
!define GTK_UNINSTALL_EXE "uninst.exe"
!define GTK_REG_LANG      "Installer Language"

;--------------------------------
;Modern UI Configuration

  !define MUI_ICON        .\gtk.ico
  !define MUI_UNICON      .\gtk.ico

  !define MUI_ABORTWARNING

;--------------------------------
;Pages

  !insertmacro MUI_PAGE_WELCOME
  !insertmacro MUI_PAGE_DIRECTORY
  !insertmacro MUI_PAGE_INSTFILES
  !insertmacro MUI_PAGE_FINISH

  !insertmacro MUI_UNPAGE_WELCOME
  !insertmacro MUI_UNPAGE_CONFIRM
  !insertmacro MUI_UNPAGE_INSTFILES
  !insertmacro MUI_UNPAGE_FINISH

;--------------------------------
;Languages

  !insertmacro MUI_LANGUAGE "English"

  !insertmacro MUI_LANGUAGE "Albanian"
  !insertmacro MUI_LANGUAGE "Bulgarian"
  !insertmacro MUI_LANGUAGE "Catalan"
  !insertmacro MUI_LANGUAGE "Czech"
  !insertmacro MUI_LANGUAGE "Danish"
  !insertmacro MUI_LANGUAGE "SimpChinese"
  !insertmacro MUI_LANGUAGE "TradChinese"
  !insertmacro MUI_LANGUAGE "German"
  !insertmacro MUI_LANGUAGE "Spanish"
  !insertmacro MUI_LANGUAGE "French"
  !insertmacro MUI_LANGUAGE "Hebrew"
  !insertmacro MUI_LANGUAGE "Italian"
  !insertmacro MUI_LANGUAGE "Japanese"
  !insertmacro MUI_LANGUAGE "Korean"
  !insertmacro MUI_LANGUAGE "Hungarian"
  !insertmacro MUI_LANGUAGE "Dutch"
  !insertmacro MUI_LANGUAGE "Norwegian"
  !insertmacro MUI_LANGUAGE "Polish"
  !insertmacro MUI_LANGUAGE "PortugueseBR"
  !insertmacro MUI_LANGUAGE "Portuguese"
  !insertmacro MUI_LANGUAGE "Romanian"
  !insertmacro MUI_LANGUAGE "Serbian"
  !insertmacro MUI_LANGUAGE "Slovak"
  !insertmacro MUI_LANGUAGE "Slovenian"
  !insertmacro MUI_LANGUAGE "Finnish"
  !insertmacro MUI_LANGUAGE "Swedish"


;--------------------------------
;Translations

  !include "translations\english.nsh"
  !include "translations\albanian.nsh"
  !include "translations\bulgarian.nsh"
  !include "translations\catalan.nsh"
  !include "translations\czech.nsh"
  !include "translations\danish.nsh"
  !include "translations\dutch.nsh"
  !include "translations\finnish.nsh"
  !include "translations\french.nsh"
  !include "translations\german.nsh"
  !include "translations\hebrew.nsh"
  !include "translations\hungarian.nsh"
  !include "translations\italian.nsh"
  !include "translations\japanese.nsh"
  !include "translations\korean.nsh"
  !include "translations\norwegian.nsh"
  !include "translations\polish.nsh"
  !include "translations\portuguese.nsh"
  !include "translations\portuguese-br.nsh"
  !include "translations\serbian-latin.nsh"
  !include "translations\simp-chinese.nsh"
  !include "translations\slovak.nsh"
  !include "translations\slovenian.nsh"
  !include "translations\spanish.nsh"
  !include "translations\swedish.nsh"
  !include "translations\trad-chinese.nsh"
  !include "translations\romanian.nsh"

;--------------------------------
;Reserve Files
  ; Only need this if using bzip2 compression

  !insertmacro MUI_RESERVEFILE_LANGDLL
  ReserveFile "${NSISDIR}\Plugins\UserInfo.dll"

;--------------------------------
;Installer Sections

Section "GTK+ Runtime Environment" SecGtk
  SectionIn 1 RO

  Call CheckUserInstallRights
  Pop $R1

  Call DoWeNeedGtk
  Pop $R0
  Pop $R6

  StrCmp $R0 "0" have_gtk
  StrCmp $R0 "1" upgrade_gtk
  StrCmp $R0 "2" no_gtk no_gtk

  upgrade_gtk:
    ; Found GTK+ that needs upgrade..
    ; Logic is:
    ; - If we have HKLM rights, found HKLM version needs upgrading
    ; - If we have HKCU rights, found HKCU version needs upgrading
    ;                           OR
    ; - We have either HKLM or HKCU with correct version but user choose
    ;   to re-install.
    ; - otherwise should not be here.
    ;
    StrCmp $R6 "HKCU" 0 hklm
      ReadRegStr $R2 HKCU "${GTK_UNINSTALL_KEY}" "UninstallString"
      ReadRegStr $R3 HKCU ${GTK_REG_KEY} "Installer"
      ReadRegStr $R4 HKCU ${GTK_REG_KEY} "Path"
      Goto gtk_uninstall
    hklm:
      ReadRegStr $R2 HKLM "${GTK_UNINSTALL_KEY}" "UninstallString"
      ReadRegStr $R3 HKLM ${GTK_REG_KEY} "Installer"
      ReadRegStr $R4 HKLM ${GTK_REG_KEY} "Path"

    gtk_uninstall:
      IfFileExists $R2 0 non_nsis_gtkuninstall
      ; Check if the installer was NSIS (Set by Gaim's GTK+ installer)
      StrCmp $R3 "NSIS" 0 non_nsis_gtkuninstall
        ; If we're here, we've got path ready to uninstall..
        SetOverwrite on
        CopyFiles /SILENT $R2 "$TEMP\gtk20u.exe"
        SetOverwrite off
        ClearErrors
        ExecWait '$TEMP\gtk20u.exe /S _?=$R4'
        IfErrors 0 exec_cont
          Delete "$TEMP\gtk20u.exe"
          IfSilent 0 mb_go
            IntCmp $NOUI 0 mb_no
          mb_go:
          MessageBox MB_OK $(GTK_INSTALL_ERROR_1) IDOK
          mb_no:
          Quit

          exec_cont:
            Delete "$TEMP\gtk20u.exe"
            Goto no_gtk

        ; Try to find the GTK+ uninstaller..
        non_nsis_gtkuninstall:
          ; Look in the install path..
          StrCpy $R5 "$R4\unins000.exe"
          IfFileExists $R5 0 wipe_out_old_gtk
            ; Try to uninstall with uninstaller we found..
            ClearErrors
            ExecWait "$R5"
            IfErrors wipe_out_old_gtk no_gtk

          ; This is the worst option.. hope we don't get here..
          wipe_out_old_gtk:
            RMDir /r "$R4"
            StrCmp $R6 "HKCU" 0 delete_lm_reg
              DeleteRegKey HKCU ${GTK_REG_KEY}
            delete_lm_reg:
              DeleteRegKey HKLM ${GTK_REG_KEY}
            Goto no_gtk

    no_gtk:
      SetOutPath "$INSTDIR"
      SetOverwrite on
      File /r /x .svn /x CVS .\gtk_install_files\*.*
      SetOverwrite off

      StrCmp $R1 "HKCU" hkcu_install
      StrCmp $R1 "HKLM" hklm_install done

      hklm_install:
        WriteRegStr HKLM ${GTK_REG_KEY} "" "$INSTDIR"
        WriteRegStr HKLM ${GTK_REG_KEY} "Version" "${GTK_VERSION}"
        WriteRegStr HKLM ${GTK_REG_KEY} "Revision" "${GTK_REVISION}"
        WriteRegStr HKLM ${GTK_REG_KEY} "Path" "$INSTDIR"
        WriteRegStr HKLM ${GTK_REG_KEY} "DllPath" "$INSTDIR\bin"
        WriteRegStr HKLM ${GTK_REG_KEY} "Installer" "NSIS"
        WriteRegStr HKLM "${GTK_UNINSTALL_KEY}" "DisplayName" $(GTK_UNINSTALL_DISPLAY_NAME)
        WriteRegStr HKLM "${GTK_UNINSTALL_KEY}" "UninstallString" "$INSTDIR\${GTK_UNINSTALL_EXE}"
        SetShellVarContext "all"
        ; Apps that make use of GTK+ should add the GTK lib dir to the App Paths key..
        Goto install_success

      hkcu_install:
        WriteRegStr HKCU ${GTK_REG_KEY} "" "$INSTDIR"
        WriteRegStr HKCU ${GTK_REG_KEY} "Version" "${GTK_VERSION}"
        WriteRegStr HKLM ${GTK_REG_KEY} "Revision" "${GTK_REVISION}"
        WriteRegStr HKCU ${GTK_REG_KEY} "Path" "$INSTDIR"
        WriteRegStr HKCU ${GTK_REG_KEY} "DllPath" "$INSTDIR\bin"
        WriteRegStr HKCU ${GTK_REG_KEY} "Installer" "NSIS"
        WriteRegStr HKCU "${GTK_UNINSTALL_KEY}" "DisplayName" $(GTK_UNINSTALL_DISPLAY_NAME)
        WriteRegStr HKCU "${GTK_UNINSTALL_KEY}" "UninstallString" "$INSTDIR\${GTK_UNINSTALL_EXE}"

    install_success:
;      CreateDirectory "$SMPROGRAMS\GTK\2.0"
;      CreateShortCut "$SMPROGRAMS\GTK\2.0\Uninstall.lnk" "$INSTDIR\${GTK_UNINSTALL_EXE}"
      WriteUninstaller "$INSTDIR\${GTK_UNINSTALL_EXE}"
      ; Write out installer language
      WriteRegStr HKCU "${GTK_REG_KEY}" "${GTK_REG_LANG}" "$LANGUAGE"
      Goto done

    ; We have the correct GTK+ version installed already.. 
    have_gtk:
      ;If unattended install.. we choose no on reinstall
      IfSilent 0 mb_go1
        IntCmp $NOUI 0 upgrade_gtk
      mb_go1:
      ; Ask user if he wishes to re-install anyway..
      StrCpy $R7 $(GTK_RE_INSTALL_Q)
      StrCpy $R8 "GTK+ $R6 $R7"
      MessageBox MB_YESNO $R8 IDYES upgrade_gtk IDNO done

  done:
SectionEnd


;--------------------------------
;Uninstaller Section


Section Uninstall
  Call un.CheckUserInstallRights
  Pop $R0
  StrCmp $R0 "NONE" no_rights
  StrCmp $R0 "HKCU" try_hkcu try_hklm

  try_hkcu:
    ReadRegStr $R1 HKCU ${GTK_REG_KEY} "Path"
    StrCmp $R1 $INSTDIR 0 cant_uninstall
      ; HKCU install path matches our INSTDIR.. so uninstall
      DeleteRegKey HKCU ${GTK_REG_KEY}
      DeleteRegKey HKCU "${GTK_UNINSTALL_KEY}"
      Goto cont_uninstall

  try_hklm:
    ReadRegStr $R1 HKLM ${GTK_REG_KEY} "Path"
    StrCmp $R1 $INSTDIR 0 try_hkcu
      ; HKLM install path matches our INSTDIR.. so uninstall
      DeleteRegKey HKLM ${GTK_REG_KEY}
      DeleteRegKey HKLM "${GTK_UNINSTALL_KEY}"
      ; Sets start menu and desktop scope to all users..
      SetShellVarContext "all"

  cont_uninstall:
    ; Remove Language preference info
    DeleteRegKey HKCU ${GTK_REG_KEY}

    ; Delete Gtk dir
    ;RMDir /r "$INSTDIR"
    Delete "$INSTDIR\etc\fonts\fonts.conf"
    RMDir "$INSTDIR\etc\fonts"
    Delete "$INSTDIR\etc\gtk-2.0\gdk-pixbuf.loaders"
    Delete "$INSTDIR\etc\gtk-2.0\gtk.immodules"
    Delete "$INSTDIR\etc\gtk-2.0\gtkrc"
    RMDir "$INSTDIR\etc\gtk-2.0"
    Delete "$INSTDIR\etc\pango\pango.aliases"
    Delete "$INSTDIR\etc\pango\pango.modules"
    RMDir "$INSTDIR\etc\pango"
    RMDir "$INSTDIR\etc"
    Delete "$INSTDIR\bin\asprintf.dll"
    Delete "$INSTDIR\bin\charset.dll"
    Delete "$INSTDIR\bin\freetype6.dll"
    Delete "$INSTDIR\bin\gspawn-win32-helper.exe"
    Delete "$INSTDIR\bin\iconv.dll"
    Delete "$INSTDIR\bin\intl.dll"
    Delete "$INSTDIR\bin\jpeg62.dll"
    Delete "$INSTDIR\bin\libatk-1.0-0.dll"
    Delete "$INSTDIR\bin\libfontconfig-1.dll"
    Delete "$INSTDIR\bin\libgdk-win32-2.0-0.dll"
    Delete "$INSTDIR\bin\libgdk_pixbuf-2.0-0.dll"
    Delete "$INSTDIR\bin\libglib-2.0-0.dll"
    Delete "$INSTDIR\bin\libgmodule-2.0-0.dll"
    Delete "$INSTDIR\bin\libgobject-2.0-0.dll"
    Delete "$INSTDIR\bin\libgthread-2.0-0.dll"
    Delete "$INSTDIR\bin\libgtk-win32-2.0-0.dll"
    Delete "$INSTDIR\bin\libpango-1.0-0.dll"
    Delete "$INSTDIR\bin\libpangoft2-1.0-0.dll"
    Delete "$INSTDIR\bin\libpangowin32-1.0-0.dll"
    Delete "$INSTDIR\bin\libpng12.dll"
    Delete "$INSTDIR\bin\libpng13.dll"
    Delete "$INSTDIR\bin\libtiff3.dll"
    Delete "$INSTDIR\bin\pango-querymodules.exe"
    Delete "$INSTDIR\bin\xmlparse.dll"
    Delete "$INSTDIR\bin\xmltok.dll"
    Delete "$INSTDIR\bin\zlib1.dll"
    RMDir "$INSTDIR\bin"
    Delete "$INSTDIR\lib\pango\1.4.0\modules\pango-arabic-fc.dll"
    Delete "$INSTDIR\lib\pango\1.4.0\modules\pango-basic-fc.dll"
    Delete "$INSTDIR\lib\pango\1.4.0\modules\pango-basic-win32.dll"
    Delete "$INSTDIR\lib\pango\1.4.0\modules\pango-hangul-fc.dll"
    Delete "$INSTDIR\lib\pango\1.4.0\modules\pango-hebrew-fc.dll"
    Delete "$INSTDIR\lib\pango\1.4.0\modules\pango-indic-fc.dll"
    Delete "$INSTDIR\lib\pango\1.4.0\modules\pango-khmer-fc.dll"
    Delete "$INSTDIR\lib\pango\1.4.0\modules\pango-syriac-fc.dll"
    Delete "$INSTDIR\lib\pango\1.4.0\modules\pango-tibetan-fc.dll"
    Delete "$INSTDIR\lib\pango\1.4.0\modules\pango-thai-fc.dll"
    RMDir "$INSTDIR\lib\pango\1.4.0\modules"
    RMDir "$INSTDIR\lib\pango\1.4.0"
    RMDir "$INSTDIR\lib\pango"
    RMDir /r "$INSTDIR\lib\locale"
    RMDir "$INSTDIR\lib\gtk-2.0\2.4.0\engines"
    Delete "$INSTDIR\lib\gtk-2.0\2.4.0\immodules\im-am-et.dll"
    Delete "$INSTDIR\lib\gtk-2.0\2.4.0\immodules\im-cedilla.dll"
    Delete "$INSTDIR\lib\gtk-2.0\2.4.0\immodules\im-cyrillic-translit.dll"
    Delete "$INSTDIR\lib\gtk-2.0\2.4.0\immodules\im-ime.dll"
    Delete "$INSTDIR\lib\gtk-2.0\2.4.0\immodules\im-inuktitut.dll"
    Delete "$INSTDIR\lib\gtk-2.0\2.4.0\immodules\im-ipa.dll"
    Delete "$INSTDIR\lib\gtk-2.0\2.4.0\immodules\im-thai-broken.dll"
    Delete "$INSTDIR\lib\gtk-2.0\2.4.0\immodules\im-ti-er.dll"
    Delete "$INSTDIR\lib\gtk-2.0\2.4.0\immodules\im-ti-et.dll"
    Delete "$INSTDIR\lib\gtk-2.0\2.4.0\immodules\im-viqr.dll"
    RMDir "$INSTDIR\lib\gtk-2.0\2.4.0\immodules"
    Delete "$INSTDIR\lib\gtk-2.0\2.4.0\loaders\libpixbufloader-ani.dll"
    Delete "$INSTDIR\lib\gtk-2.0\2.4.0\loaders\libpixbufloader-bmp.dll"
    Delete "$INSTDIR\lib\gtk-2.0\2.4.0\loaders\libpixbufloader-gif.dll"
    Delete "$INSTDIR\lib\gtk-2.0\2.4.0\loaders\libpixbufloader-ico.dll"
    Delete "$INSTDIR\lib\gtk-2.0\2.4.0\loaders\libpixbufloader-jpeg.dll"
    Delete "$INSTDIR\lib\gtk-2.0\2.4.0\loaders\libpixbufloader-pcx.dll"
    Delete "$INSTDIR\lib\gtk-2.0\2.4.0\loaders\libpixbufloader-png.dll"
    Delete "$INSTDIR\lib\gtk-2.0\2.4.0\loaders\libpixbufloader-pnm.dll"
    Delete "$INSTDIR\lib\gtk-2.0\2.4.0\loaders\libpixbufloader-ras.dll"
    Delete "$INSTDIR\lib\gtk-2.0\2.4.0\loaders\libpixbufloader-tga.dll"
    Delete "$INSTDIR\lib\gtk-2.0\2.4.0\loaders\libpixbufloader-tiff.dll"
    Delete "$INSTDIR\lib\gtk-2.0\2.4.0\loaders\libpixbufloader-wbmp.dll"
    Delete "$INSTDIR\lib\gtk-2.0\2.4.0\loaders\libpixbufloader-xbm.dll"
    Delete "$INSTDIR\lib\gtk-2.0\2.4.0\loaders\libpixbufloader-xpm.dll"
    RMDir "$INSTDIR\lib\gtk-2.0\2.4.0\loaders"
    RMDir "$INSTDIR\lib\gtk-2.0\2.4.0"
    RMDir "$INSTDIR\lib\gtk-2.0"
    RMDir "$INSTDIR\lib"
    Delete "$INSTDIR\share\themes\Default\gtk-2.0\gtkrc"
    Delete "$INSTDIR\share\themes\Default\gtk-2.0\gtkrc.plain"
    RMDir "$INSTDIR\share\themes\Default\gtk-2.0"
    Delete "$INSTDIR\share\themes\Default\gtk-2.0-key\gtkrc"
    RMDir "$INSTDIR\share\themes\Default\gtk-2.0-key"
    RMDir "$INSTDIR\share\themes\Default"
    Delete "$INSTDIR\share\themes\Emacs\gtk-2.0-key\gtkrc"
    RMDir "$INSTDIR\share\themes\Emacs\gtk-2.0-key"
    RMDir "$INSTDIR\share\themes\Emacs"
    RMDir "$INSTDIR\share\themes"
    RMDir "$INSTDIR\share"
    Delete "$INSTDIR\COPYING.LIB-2"
    Delete "$INSTDIR\${GTK_UNINSTALL_EXE}"
    RMDir "$INSTDIR"

    ; Shortcuts..
;    RMDir /r "$SMPROGRAMS\GTK\2.0"
;    RMDir "$SMPROGRAMS\GTK"

    Goto done

  cant_uninstall:
    IfSilent skip_mb
    MessageBox MB_OK $(un.GTK_UNINSTALL_ERROR_1) IDOK
    skip_mb:
    Quit

  no_rights:
    IfSilent skip_mb1
    MessageBox MB_OK $(un.GTK_UNINSTALL_ERROR_2) IDOK
    skip_mb1:
    Quit

  done:
SectionEnd ; end of uninstall section

;--------------------------------
;Functions

Function CheckUserInstallRights
  ClearErrors
  UserInfo::GetName
  IfErrors Win9x
  Pop $0
  UserInfo::GetAccountType
  Pop $1

  StrCmp $1 "Admin" 0 +3
    StrCpy $1 "HKLM"
  Goto done
  StrCmp $1 "Power" 0 +3
    StrCpy $1 "HKLM"
  Goto done
  StrCmp $1 "User" 0 +3
    StrCpy $1 "HKCU"
  Goto done
  StrCmp $1 "Guest" 0 +3
    StrCpy $1 "NONE"
  Goto done
  ; Unknown error
    StrCpy $1 "NONE"
  Goto done

  Win9x:
    StrCpy $1 "HKLM"

  done:
    Push $1
FunctionEnd

Function un.CheckUserInstallRights
  ClearErrors
  UserInfo::GetName
  IfErrors Win9x
  Pop $0
  UserInfo::GetAccountType
  Pop $1
  StrCmp $1 "Admin" 0 +3
    StrCpy $1 "HKLM"
  Goto done
  StrCmp $1 "Power" 0 +3
    StrCpy $1 "HKLM"
  Goto done
  StrCmp $1 "User" 0 +3
    StrCpy $1 "HKCU"
  Goto done
  StrCmp $1 "Guest" 0 +3
    StrCpy $1 "NONE"
  Goto done
  ; Unknown error
  StrCpy $1 "NONE"
  Goto done

  Win9x:
    StrCpy $1 "HKLM"

  done:
    Push $1
FunctionEnd

;
; Usage:
;   Push $0 ; Path string
;   Call VerifyDir
;   Pop $0 ; 0 - Bad path  1 - Good path
;
Function VerifyDir
  Pop $0
  Loop:
    IfFileExists $0 dir_exists
    StrCpy $1 $0 ; save last
    Push $0
    Call GetParent
    Pop $0
    StrLen $2 $0
    ; IfFileExists "C:" on xp returns true and on win2k returns false
    ; So we're done in such a case..
    StrCmp $2 "2" loop_done
    Goto Loop

  loop_done:
    StrCpy $1 "$0\GaImFooB"
    ; Check if we can create dir on this drive..
    ClearErrors
    CreateDirectory $1
    IfErrors DirBad DirGood

  dir_exists:
    ClearErrors
    FileOpen $1 "$0\gaimfoo.bar" w
    IfErrors PathBad PathGood

    DirGood:
      RMDir $1
      Goto PathGood1

    DirBad:
      RMDir $1
      Goto PathBad1

    PathBad:
      FileClose $1
      Delete "$0\gaimfoo.bar"
      PathBad1:
      StrCpy $0 "0"
      Push $0
      Return

    PathGood:
      FileClose $1
      Delete "$0\gaimfoo.bar"
      PathGood1:
      StrCpy $0 "1"
      Push $0
FunctionEnd

Function .onVerifyInstDir
  Push $INSTDIR
  Call VerifyDir
  Pop $0
  StrCmp $0 "0" 0 dir_good
    Abort
  dir_good:
FunctionEnd

; GetParent
; input, top of stack  (e.g. C:\Program Files\Poop)
; output, top of stack (replaces, with e.g. C:\Program Files)
; modifies no other variables.
;
; Usage:
;   Push "C:\Program Files\Directory\Whatever"
;   Call GetParent
;   Pop $R0
;   ; at this point $R0 will equal "C:\Program Files\Directory"
Function GetParent
   Exch $0 ; old $0 is on top of stack
   Push $1
   Push $2
   StrCpy $1 -1
   loop:
     StrCpy $2 $0 1 $1
     StrCmp $2 "" exit
     StrCmp $2 "\" exit
     IntOp $1 $1 - 1
   Goto loop
   exit:
     StrCpy $0 $0 $1
     Pop $2
     Pop $1
     Exch $0 ; put $0 on top of stack, restore $0 to original value
FunctionEnd


; CheckGtkVersion
; inputs: Push 2 GTK+ version strings to check. The major value needs to
; be equal and the minor value needs to be greater or equal.
;
; Usage:
;   Push "2.1.0"  ; Refrence version
;   Push "2.2.1"  ; Version to check
;   Call CheckGtkVersion
;   Pop $R0
;   $R0 will now equal "1", because 2.2 is greater than 2.1
;
Function CheckGtkVersion
  ; Version we want to check
  Pop $6 
  ; Reference version
  Pop $8 

  ; Check that the string to check is at least 5 chars long (i.e. x.x.x)
  StrLen $7 $6
  IntCmp $7 5 0 bad_version

  ; Major version check
  StrCpy $7 $6 1
  StrCpy $9 $8 1
  IntCmp $7 $9 check_minor bad_version bad_version

  check_minor:
    StrCpy $7 $6 1 2
    StrCpy $9 $8 1 2
    IntCmp $7 $9 good_version bad_version good_version

  bad_version:
    StrCpy $6 "0"
    Push $6
    Goto done

  good_version:
    StrCpy $6 "1"
    Push $6
  done:
FunctionEnd

;
; Usage:
; Call DoWeNeedGtk
; First Pop:
;   0 - We have the correct version
;       Second Pop: Version found
;   1 - We have an old version that needs to be upgraded
;       Second Pop: HKLM or HKCU depending on where GTK was found.
;   2 - We don't have Gtk+ at all
;       Second Pop: "NONE" - for no rights  "" - for hklm and hkcu rights
;
Function DoWeNeedGtk
  ; Logic should be:
  ; - Check what user rights we have (HKLM or HKCU)
  ;   - If HKLM rights..
  ;     - Only check HKLM key for GTK+
  ;       - If installed to HKLM, check it and return.
  ;   - If HKCU rights..
  ;     - First check HKCU key for GTK+
  ;       - if good or bad exists stop and ret.
  ;     - If no hkcu gtk+ install, check HKLM
  ;       - If HKLM ver exists but old, return as if no ver exits.
  ;   - If no rights
  ;     - Check HKLM

  Call CheckUserInstallRights
  Pop $3
  StrCmp $3 "HKLM" check_hklm
  StrCmp $3 "HKCU" check_hkcu check_hklm
    check_hkcu:
      ReadRegStr $0 HKCU ${GTK_REG_KEY} "Version"
      ReadRegStr $4 HKCU ${GTK_REG_KEY} "Revision"
      StrCpy $5 "HKCU"
      StrCmp $0 "" check_hklm have_gtk

    check_hklm:
      ReadRegStr $0 HKLM ${GTK_REG_KEY} "Version"
      ReadRegStr $4 HKLM ${GTK_REG_KEY} "Revision"
      StrCpy $5 "HKLM"
      StrCmp $0 "" no_gtk have_gtk


  have_gtk:
    ; GTK+ is already installed.. check version.
    StrCpy $1 ${GTK_VERSION} ; Minimum GTK+ version needed
    Push $1
    Push $0
    Call CheckGtkVersion
    Pop $2
    StrCmp $2 "1" good_version bad_version
    bad_version:
      ; Bad version. If hklm ver and we have hkcu or no rights.. return no gtk
      StrCmp $3 "NONE" no_gtk  ; if no rights.. can't upgrade
      StrCmp $3 "HKCU" 0 upgrade_gtk ; if HKLM can upgrade..
        StrCmp $5 "HKLM" no_gtk upgrade_gtk ; have hkcu rights.. if found hklm ver can't upgrade..

      upgrade_gtk:
        StrCpy $2 "1"
        Push $5
        Push $2
        Goto done

  good_version:
    StrCpy $2 "0"
    StrCmp $4 "" no_rev
      StrCpy $0 "$0 rev $4"
    no_rev:
    Push $0  ; The version we already have
    Push $2
    Goto done

  no_gtk:
    StrCpy $2 "2"
    StrCmp $3 "NONE" 0 got_rights
      StrCpy $5 "NONE"
      Goto no_gtk_cont
    got_rights:
      StrCpy $5 ""
    no_gtk_cont:
    Push $5
    Push $2
    Goto done

  done:
FunctionEnd

Function .onInit
  Call ParseParameters

  ; If we got path from /D command line switch.. we're done
  StrCmp $INSTDIR "" 0 done
  Call CheckUserInstallRights
  Pop $0

  StrCmp $0 "HKLM" hklm
  StrCmp $0 "HKCU" hkcu user_dir
    hklm:
      ReadRegStr $2 HKLM "${GTK_REG_KEY}" "Path"
      Goto next
    hkcu:
      ReadRegStr $2 HKCU "${GTK_REG_KEY}" "Path"

    next:
      StrCmp $2 "" user_dir
        StrCpy $INSTDIR $2
        Goto done

  user_dir:
    StrCmp $0 "HKLM" hklm1
    StrCmp $0 "HKCU" hkcu1 hkcu1
      hklm1:
        StrCpy $INSTDIR "$COMMONFILES\GTK\2.0"
        Goto done
      hkcu1:
        StrCpy $2 "$SMPROGRAMS"
        Push $2
        Call GetParent
        Call GetParent
        Pop $2
        StrCpy $INSTDIR "$2\GTK\2.0"

  done:

  ; If Lang was set on command line don't show lang selection dialog
  IntCmp $LANG_IS_SET 1 skip_lang
    ; Display Language selection dialog
    !insertmacro MUI_LANGDLL_DISPLAY
    skip_lang:

  ; If NOUI was given on command line, run installer in silent mode except
  ; for any message boxes that may show.
  IntCmp $NOUI 0 skip_noui
    SetSilent silent
    skip_noui:
FunctionEnd

Function un.onInit

  ; Get stored language prefrence
  ReadRegStr $LANGUAGE HKCU ${GTK_REG_KEY} "${GTK_REG_LANG}"

FunctionEnd

; GetParameters
; input, none
; output, top of stack (replaces, with e.g. whatever)
; modifies no other variables.

Function GetParameters

   Push $R0
   Push $R1
   Push $R2
   Push $R3

   StrCpy $R2 1
   StrLen $R3 $CMDLINE

   ;Check for quote or space
   StrCpy $R0 $CMDLINE $R2
   StrCmp $R0 '"' 0 +3
     StrCpy $R1 '"'
     Goto loop
   StrCpy $R1 " "

   loop:
     IntOp $R2 $R2 + 1
     StrCpy $R0 $CMDLINE 1 $R2
     StrCmp $R0 $R1 get
     StrCmp $R2 $R3 get
     Goto loop

   get:
     IntOp $R2 $R2 + 1
     StrCpy $R0 $CMDLINE 1 $R2
     StrCmp $R0 " " get
     StrCpy $R0 $CMDLINE "" $R2

   Pop $R3
   Pop $R2
   Pop $R1
   Exch $R0

FunctionEnd

; StrStr
 ; input, top of stack = string to search for
 ;        top of stack-1 = string to search in
 ; output, top of stack (replaces with the portion of the string remaining)
 ; modifies no other variables.
 ;
 ; Usage:
 ;   Push "this is a long ass string"
 ;   Push "ass"
 ;   Call StrStr
 ;   Pop $R0
 ;  ($R0 at this point is "ass string")

 Function StrStr
 Exch $R1 ; st=haystack,old$R1, $R1=needle
   Exch    ; st=old$R1,haystack
   Exch $R2 ; st=old$R1,old$R2, $R2=haystack
   Push $R3
   Push $R4
   Push $R5
   StrLen $R3 $R1
   StrCpy $R4 0
   ; $R1=needle
   ; $R2=haystack
   ; $R3=len(needle)
   ; $R4=cnt
   ; $R5=tmp
   loop:
     StrCpy $R5 $R2 $R3 $R4
     StrCmp $R5 $R1 done
     StrCmp $R5 "" done
     IntOp $R4 $R4 + 1
     Goto loop
 done:
   StrCpy $R1 $R2 "" $R4
   Pop $R5
   Pop $R4
   Pop $R3
   Pop $R2
   Exch $R1
 FunctionEnd

;
; Parse the Command line
;
; Unattended install command line parameters
; /L=Language e.g.: /L=1033
;
Function ParseParameters
  IntOp $LANG_IS_SET 0 + 0
  IntOp $NOUI 0 + 0

  Call GetParameters
  Pop $R0

  ; Parse Language
  Push $R0
  Push "L="
  Call StrStr
  Pop $R1
  StrCmp $R1 "" next
    StrCpy $R1 $R1 4 2 ; Strip first 2 chars of string
    StrCpy $LANGUAGE $R1
    IntOp $LANG_IS_SET 0 + 1
  next:

  ; Parse UI setting
  Push $R0
  Push "NOUI"
  Call StrStr
  Pop $R1
  StrCmp $R1 "" next1
    IntOp $NOUI 0 + 1
  next1:
FunctionEnd
