#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include "phys.h"
#include "log.h"

extern struct phys phys_apple33;
extern struct phys phys_apple32;
extern struct phys phys_applepro;
extern struct phys phys_c1541;
extern struct phys phys_ti99;
extern struct phys phys_atari810;
extern struct phys phys_msdos1200;
extern struct phys phys_msdos360;
extern struct phys phys_mdsad;

extern struct log log_applepro;
extern struct log log_fat12;

static struct format_info {
	char *id;
	char *desc;
	char *suffix;
	struct phys *phys;
	struct log *log;
} formats[]={
	{"apple33","Apple DOS 3.3 (16-sector)","dsk",&phys_apple33,NULL},
	{"apple32","Apple DOS 3.2 (13-sector)","dsk",&phys_apple32,NULL},
	{"applepro","Apple ProDOS","po",&phys_applepro,&log_applepro},
	{"c1541","Commodore 1541","d64",&phys_c1541,NULL},
	{"ti99","TI-99/4A","v9t9",&phys_ti99,NULL},
	{"atari810","Atari 810","xfd",&phys_atari810,NULL},
	{"msdos12","MS-DOS 1200k","img",&phys_msdos1200,&log_fat12},
	{"msdos360","MS-DOS 360k","img",&phys_msdos360,&log_fat12},
	{"mdsad","North Star MDS-A-D","nsi",&phys_mdsad,NULL},
#if 0
	{"null","null",NULL,0},
#endif
	{NULL,NULL,NULL,NULL}
};

struct format_info *get_format_list(void) {
	return formats;
}

struct format_info *format_by_id(char *id) {
	struct format_info *format;

	for(format=formats;format->id!=NULL;format++) {
		if(strcasecmp(format->id,id)==0)
			return format;
	}

	return NULL;
}
