/*
 * Appleblossom - Portable Open-Source Apple IIe Emulator
 * Copyright (C) 2005 Jonathan Bettencourt (jonrelay)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __A2_COLORS_H__
#define __A2_COLORS_H__

static const long int a2_color_palette[7][16] = {
	{	/* Ticmanis SMPTE 1979 */
		0x000000, 0x901740, 0x402CA5, 0xD043E5, 0x006940, 0x808080, 0x2F95E5, 0xBFABFF, 
		0x405400, 0xD06A1A, 0x808080, 0xFF96BF, 0x2FBC1A, 0xBFD35A, 0x6FE8BF, 0xFFFFFF
	},
	{	/* Ticmanis sRGB */
		0x000000, 0x8A2140, 0x3C22A5, 0xC847E4, 0x07653E, 0x7B7E80, 0x308FE3, 0xB9A9FD, 
		0x3B5107, 0xC77028, 0x7B7E80, 0xF39AC2, 0x2FB81F, 0xB9D060, 0x6EE1C0, 0xF5FAFF
	},
	{	/* Munafo */
		0x000000, 0xE31E60, 0x604EBD, 0xFF44FD, 0x00A360, 0x9C9C9C, 0x14CFFD, 0xD0C3FF, 
		0x607203, 0xFF6A3C, 0x9C9C9C, 0xFFA0D0, 0x14F53C, 0xD0DD8D, 0x72FFD0, 0xFFFFFF
	},
	{	/* ApplePC */
		0x000000, 0x7C2040, 0x20307C, 0xBC50BC, 0x005C3C, 0x7C7C7C, 0x408CB8, 0xBCACF8, 
		0x3C4C00, 0xB86C40, 0x7C7C7C, 0xF89CBC, 0x3CA83C, 0xBCC87C, 0x7CD8BC, 0xFFFFFF
	},
	{	/* Mono */
		0x000000, 0x404040, 0x404040, 0x808080, 0x404040, 0x808080, 0x808080, 0xC0C0C0,
		0x404040, 0x808080, 0x808080, 0xC0C0C0, 0x808080, 0xC0C0C0, 0xC0C0C0, 0xFFFFFF
	},
	{	/* Green */
		0x000000, 0x004000, 0x004000, 0x008000, 0x004000, 0x008000, 0x008000, 0x00C000,
		0x004000, 0x008000, 0x008000, 0x00C000, 0x008000, 0x00C000, 0x00C000, 0x00FF00
	},
	{	/* Amber */
		0x000000, 0x402800, 0x402800, 0x806800, 0x402800, 0x806800, 0x806800, 0xC0A800,
		0x402800, 0x806800, 0x806800, 0xC0A800, 0x806800, 0xC0A800, 0xC0A800, 0xFFE800
	}
};

#endif
