/*
 * Appleblossom - Portable Open-Source Apple IIe Emulator
 * Copyright (C) 2005 Jonathan Bettencourt (jonrelay)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __A2_FONT_H__
#define __A2_FONT_H__

typedef struct A2_CHARACTER_BITMAP_ {
	unsigned char row[8];
} A2_CHARACTER_BITMAP;

A2_CHARACTER_BITMAP A2_FONT[256];

const A2_CHARACTER_BITMAP A2_DEFAULT_FONT[256] = {
	{{0x63, 0x5D, 0x55, 0x51, 0x53, 0x5F, 0x61, 0x7F}},	{{0x77, 0x6B, 0x5D, 0x5D, 0x41, 0x5D, 0x5D, 0x7F}},	{{0x43, 0x5D, 0x5D, 0x43, 0x5D, 0x5D, 0x43, 0x7F}},	{{0x63, 0x5D, 0x5F, 0x5F, 0x5F, 0x5D, 0x63, 0x7F}},
	{{0x43, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x43, 0x7F}},	{{0x41, 0x5F, 0x5F, 0x43, 0x5F, 0x5F, 0x41, 0x7F}},	{{0x41, 0x5F, 0x5F, 0x43, 0x5F, 0x5F, 0x5F, 0x7F}},	{{0x61, 0x5F, 0x5F, 0x5F, 0x59, 0x5D, 0x61, 0x7F}},
	{{0x5D, 0x5D, 0x5D, 0x41, 0x5D, 0x5D, 0x5D, 0x7F}},	{{0x63, 0x77, 0x77, 0x77, 0x77, 0x77, 0x63, 0x7F}},	{{0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x5D, 0x63, 0x7F}},	{{0x5D, 0x5B, 0x57, 0x4F, 0x57, 0x5B, 0x5D, 0x7F}},
	{{0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x41, 0x7F}},	{{0x5D, 0x49, 0x55, 0x55, 0x5D, 0x5D, 0x5D, 0x7F}},	{{0x5D, 0x5D, 0x4D, 0x55, 0x59, 0x5D, 0x5D, 0x7F}},	{{0x63, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x63, 0x7F}},
	{{0x43, 0x5D, 0x5D, 0x43, 0x5F, 0x5F, 0x5F, 0x7F}},	{{0x63, 0x5D, 0x5D, 0x5D, 0x55, 0x5B, 0x65, 0x7F}},	{{0x43, 0x5D, 0x5D, 0x43, 0x57, 0x5B, 0x5D, 0x7F}},	{{0x63, 0x5D, 0x5F, 0x63, 0x7D, 0x5D, 0x63, 0x7F}},
	{{0x41, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x7F}},	{{0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x63, 0x7F}},	{{0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x6B, 0x77, 0x7F}},	{{0x5D, 0x5D, 0x5D, 0x55, 0x55, 0x49, 0x5D, 0x7F}},
	{{0x5D, 0x5D, 0x6B, 0x77, 0x6B, 0x5D, 0x5D, 0x7F}},	{{0x5D, 0x5D, 0x6B, 0x77, 0x77, 0x77, 0x77, 0x7F}},	{{0x41, 0x7D, 0x7B, 0x77, 0x6F, 0x5F, 0x41, 0x7F}},	{{0x41, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x41, 0x7F}},
	{{0x7F, 0x5F, 0x6F, 0x77, 0x7B, 0x7D, 0x7F, 0x7F}},	{{0x41, 0x79, 0x79, 0x79, 0x79, 0x79, 0x41, 0x7F}},	{{0x7F, 0x7F, 0x77, 0x6B, 0x5D, 0x7F, 0x7F, 0x7F}},	{{0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x00}},
	{{0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F}},	{{0x77, 0x77, 0x77, 0x77, 0x77, 0x7F, 0x77, 0x7F}},	{{0x6B, 0x6B, 0x6B, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F}},	{{0x6B, 0x6B, 0x41, 0x6B, 0x41, 0x6B, 0x6B, 0x7F}},
	{{0x77, 0x61, 0x57, 0x63, 0x75, 0x43, 0x77, 0x7F}},	{{0x4F, 0x4D, 0x7B, 0x77, 0x6F, 0x59, 0x79, 0x7F}},	{{0x6F, 0x57, 0x57, 0x6F, 0x55, 0x5B, 0x65, 0x7F}},	{{0x77, 0x77, 0x77, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F}},
	{{0x77, 0x6F, 0x5F, 0x5F, 0x5F, 0x6F, 0x77, 0x7F}},	{{0x77, 0x7B, 0x7D, 0x7D, 0x7D, 0x7B, 0x77, 0x7F}},	{{0x77, 0x55, 0x63, 0x77, 0x63, 0x55, 0x77, 0x7F}},	{{0x7F, 0x77, 0x77, 0x41, 0x77, 0x77, 0x7F, 0x7F}},
	{{0x7F, 0x7F, 0x7F, 0x7F, 0x77, 0x77, 0x6F, 0x7F}},	{{0x7F, 0x7F, 0x7F, 0x41, 0x7F, 0x7F, 0x7F, 0x7F}},	{{0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x77, 0x7F}},	{{0x7F, 0x7D, 0x7B, 0x77, 0x6F, 0x5F, 0x7F, 0x7F}},
	{{0x63, 0x5D, 0x59, 0x55, 0x4D, 0x5D, 0x63, 0x7F}},	{{0x77, 0x67, 0x77, 0x77, 0x77, 0x77, 0x63, 0x7F}},	{{0x63, 0x5D, 0x7D, 0x73, 0x6F, 0x5F, 0x41, 0x7F}},	{{0x41, 0x7D, 0x7B, 0x73, 0x7D, 0x5D, 0x63, 0x7F}},
	{{0x7B, 0x73, 0x6B, 0x5B, 0x41, 0x7B, 0x7B, 0x7F}},	{{0x41, 0x5F, 0x43, 0x7D, 0x7D, 0x5D, 0x63, 0x7F}},	{{0x71, 0x6F, 0x5F, 0x43, 0x5D, 0x5D, 0x63, 0x7F}},	{{0x41, 0x7D, 0x7B, 0x77, 0x6F, 0x6F, 0x6F, 0x7F}},
	{{0x63, 0x5D, 0x5D, 0x63, 0x5D, 0x5D, 0x63, 0x7F}},	{{0x63, 0x5D, 0x5D, 0x61, 0x7D, 0x7B, 0x47, 0x7F}},	{{0x7F, 0x7F, 0x77, 0x7F, 0x77, 0x7F, 0x7F, 0x7F}},	{{0x7F, 0x7F, 0x77, 0x7F, 0x77, 0x77, 0x6F, 0x7F}},
	{{0x7B, 0x77, 0x6F, 0x5F, 0x6F, 0x77, 0x7B, 0x7F}},	{{0x7F, 0x7F, 0x41, 0x7F, 0x41, 0x7F, 0x7F, 0x7F}},	{{0x6F, 0x77, 0x7B, 0x7D, 0x7B, 0x77, 0x6F, 0x7F}},	{{0x63, 0x5D, 0x7B, 0x77, 0x77, 0x7F, 0x77, 0x7F}},
	{{0x04, 0x08, 0x36, 0x7F, 0x7E, 0x7E, 0x3F, 0x36}},	{{0x04, 0x08, 0x36, 0x41, 0x42, 0x42, 0x29, 0x36}},	{{0x00, 0x00, 0x20, 0x30, 0x38, 0x3C, 0x36, 0x21}},	{{0x7F, 0x22, 0x14, 0x08, 0x08, 0x14, 0x2A, 0x7F}},
	{{0x00, 0x01, 0x02, 0x44, 0x28, 0x10, 0x10, 0x00}},	{{0x7F, 0x7E, 0x7D, 0x1B, 0x57, 0x6F, 0x6F, 0x7F}},	{{0x07, 0x03, 0x3F, 0x46, 0x4F, 0x06, 0x7E, 0x20}},	{{0x00, 0x0C, 0x70, 0x00, 0x70, 0x18, 0x08, 0x07}},
	{{0x08, 0x10, 0x20, 0x7F, 0x20, 0x10, 0x08, 0x00}},	{{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2A}},	{{0x08, 0x08, 0x08, 0x08, 0x49, 0x2A, 0x1C, 0x08}},	{{0x08, 0x1C, 0x2A, 0x49, 0x08, 0x08, 0x08, 0x08}},
	{{0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}},	{{0x01, 0x01, 0x01, 0x11, 0x31, 0x7F, 0x30, 0x10}},	{{0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E}},	{{0x64, 0x0C, 0x1C, 0x3F, 0x1C, 0x0C, 0x04, 0x7B}},
	{{0x13, 0x18, 0x1C, 0x7E, 0x1C, 0x18, 0x10, 0x6F}},	{{0x01, 0x09, 0x08, 0x7F, 0x3E, 0x1C, 0x09, 0x01}},	{{0x01, 0x09, 0x1C, 0x3E, 0x7F, 0x08, 0x09, 0x01}},	{{0x00, 0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, 0x00}},
	{{0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x7F}},	{{0x08, 0x04, 0x02, 0x7F, 0x02, 0x04, 0x08, 0x00}},	{{0x2A, 0x55, 0x2A, 0x55, 0x2A, 0x55, 0x2A, 0x55}},	{{0x55, 0x2A, 0x55, 0x2A, 0x55, 0x2A, 0x55, 0x2A}},
	{{0x00, 0x3E, 0x41, 0x40, 0x40, 0x40, 0x7F, 0x00}},	{{0x00, 0x00, 0x7E, 0x01, 0x01, 0x01, 0x7F, 0x00}},	{{0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01}},	{{0x08, 0x1C, 0x3E, 0x7F, 0x3E, 0x1C, 0x08, 0x00}},
	{{0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F}},	{{0x14, 0x14, 0x77, 0x00, 0x77, 0x14, 0x14, 0x00}},	{{0x7F, 0x01, 0x01, 0x19, 0x19, 0x01, 0x01, 0x7F}},	{{0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40}},
	{{0x6F, 0x77, 0x7B, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F}},	{{0x7F, 0x7F, 0x63, 0x7D, 0x61, 0x5D, 0x61, 0x7F}},	{{0x5F, 0x5F, 0x43, 0x5D, 0x5D, 0x5D, 0x43, 0x7F}},	{{0x7F, 0x7F, 0x61, 0x5F, 0x5F, 0x5F, 0x61, 0x7F}},
	{{0x7D, 0x7D, 0x61, 0x5D, 0x5D, 0x5D, 0x61, 0x7F}},	{{0x7F, 0x7F, 0x63, 0x5D, 0x41, 0x5F, 0x61, 0x7F}},	{{0x73, 0x6D, 0x6F, 0x43, 0x6F, 0x6F, 0x6F, 0x7F}},	{{0x7F, 0x7F, 0x63, 0x5D, 0x5D, 0x61, 0x7D, 0x63}},
	{{0x5F, 0x5F, 0x43, 0x5D, 0x5D, 0x5D, 0x5D, 0x7F}},	{{0x77, 0x7F, 0x67, 0x77, 0x77, 0x77, 0x63, 0x7F}},	{{0x7B, 0x7F, 0x73, 0x7B, 0x7B, 0x7B, 0x5B, 0x67}},	{{0x5F, 0x5F, 0x5D, 0x5B, 0x47, 0x5B, 0x5D, 0x7F}},
	{{0x67, 0x77, 0x77, 0x77, 0x77, 0x77, 0x63, 0x7F}},	{{0x7F, 0x7F, 0x49, 0x55, 0x55, 0x55, 0x5D, 0x7F}},	{{0x7F, 0x7F, 0x43, 0x5D, 0x5D, 0x5D, 0x5D, 0x7F}},	{{0x7F, 0x7F, 0x63, 0x5D, 0x5D, 0x5D, 0x63, 0x7F}},
	{{0x7F, 0x7F, 0x43, 0x5D, 0x5D, 0x43, 0x5F, 0x5F}},	{{0x7F, 0x7F, 0x61, 0x5D, 0x5D, 0x61, 0x7D, 0x7D}},	{{0x7F, 0x7F, 0x51, 0x4F, 0x5F, 0x5F, 0x5F, 0x7F}},	{{0x7F, 0x7F, 0x61, 0x5F, 0x63, 0x7D, 0x43, 0x7F}},
	{{0x6F, 0x6F, 0x43, 0x6F, 0x6F, 0x6D, 0x73, 0x7F}},	{{0x7F, 0x7F, 0x5D, 0x5D, 0x5D, 0x59, 0x65, 0x7F}},	{{0x7F, 0x7F, 0x5D, 0x5D, 0x5D, 0x6B, 0x77, 0x7F}},	{{0x7F, 0x7F, 0x5D, 0x5D, 0x55, 0x55, 0x49, 0x7F}},
	{{0x7F, 0x7F, 0x5D, 0x6B, 0x77, 0x6B, 0x5D, 0x7F}},	{{0x7F, 0x7F, 0x5D, 0x5D, 0x5D, 0x61, 0x7D, 0x63}},	{{0x7F, 0x7F, 0x41, 0x7B, 0x77, 0x6F, 0x41, 0x7F}},	{{0x71, 0x67, 0x67, 0x4F, 0x67, 0x67, 0x71, 0x7F}},
	{{0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77}},	{{0x47, 0x73, 0x73, 0x79, 0x73, 0x73, 0x47, 0x7F}},	{{0x65, 0x53, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F}},	{{0x7F, 0x55, 0x6B, 0x55, 0x6B, 0x55, 0x7F, 0x7F}},
	{{0x1C, 0x22, 0x2A, 0x2E, 0x2C, 0x20, 0x1E, 0x00}},	{{0x08, 0x14, 0x22, 0x22, 0x3E, 0x22, 0x22, 0x00}},	{{0x3C, 0x22, 0x22, 0x3C, 0x22, 0x22, 0x3C, 0x00}},	{{0x1C, 0x22, 0x20, 0x20, 0x20, 0x22, 0x1C, 0x00}},
	{{0x3C, 0x22, 0x22, 0x22, 0x22, 0x22, 0x3C, 0x00}},	{{0x3E, 0x20, 0x20, 0x3C, 0x20, 0x20, 0x3E, 0x00}},	{{0x3E, 0x20, 0x20, 0x3C, 0x20, 0x20, 0x20, 0x00}},	{{0x1E, 0x20, 0x20, 0x20, 0x26, 0x22, 0x1E, 0x00}},
	{{0x22, 0x22, 0x22, 0x3E, 0x22, 0x22, 0x22, 0x00}},	{{0x1C, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1C, 0x00}},	{{0x02, 0x02, 0x02, 0x02, 0x02, 0x22, 0x1C, 0x00}},	{{0x22, 0x24, 0x28, 0x30, 0x28, 0x24, 0x22, 0x00}},
	{{0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3E, 0x00}},	{{0x22, 0x36, 0x2A, 0x2A, 0x22, 0x22, 0x22, 0x00}},	{{0x22, 0x22, 0x32, 0x2A, 0x26, 0x22, 0x22, 0x00}},	{{0x1C, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1C, 0x00}},
	{{0x3C, 0x22, 0x22, 0x3C, 0x20, 0x20, 0x20, 0x00}},	{{0x1C, 0x22, 0x22, 0x22, 0x2A, 0x24, 0x1A, 0x00}},	{{0x3C, 0x22, 0x22, 0x3C, 0x28, 0x24, 0x22, 0x00}},	{{0x1C, 0x22, 0x20, 0x1C, 0x02, 0x22, 0x1C, 0x00}},
	{{0x3E, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00}},	{{0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1C, 0x00}},	{{0x22, 0x22, 0x22, 0x22, 0x22, 0x14, 0x08, 0x00}},	{{0x22, 0x22, 0x22, 0x2A, 0x2A, 0x36, 0x22, 0x00}},
	{{0x22, 0x22, 0x14, 0x08, 0x14, 0x22, 0x22, 0x00}},	{{0x22, 0x22, 0x14, 0x08, 0x08, 0x08, 0x08, 0x00}},	{{0x3E, 0x02, 0x04, 0x08, 0x10, 0x20, 0x3E, 0x00}},	{{0x3E, 0x30, 0x30, 0x30, 0x30, 0x30, 0x3E, 0x00}},
	{{0x00, 0x20, 0x10, 0x08, 0x04, 0x02, 0x00, 0x00}},	{{0x3E, 0x06, 0x06, 0x06, 0x06, 0x06, 0x3E, 0x00}},	{{0x00, 0x00, 0x08, 0x14, 0x22, 0x00, 0x00, 0x00}},	{{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F}},
	{{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}},	{{0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x08, 0x00}},	{{0x14, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00}},	{{0x14, 0x14, 0x3E, 0x14, 0x3E, 0x14, 0x14, 0x00}},
	{{0x08, 0x1E, 0x28, 0x1C, 0x0A, 0x3C, 0x08, 0x00}},	{{0x30, 0x32, 0x04, 0x08, 0x10, 0x26, 0x06, 0x00}},	{{0x10, 0x28, 0x28, 0x10, 0x2A, 0x24, 0x1A, 0x00}},	{{0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00}},
	{{0x08, 0x10, 0x20, 0x20, 0x20, 0x10, 0x08, 0x00}},	{{0x08, 0x04, 0x02, 0x02, 0x02, 0x04, 0x08, 0x00}},	{{0x08, 0x2A, 0x1C, 0x08, 0x1C, 0x2A, 0x08, 0x00}},	{{0x00, 0x08, 0x08, 0x3E, 0x08, 0x08, 0x00, 0x00}},
	{{0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x10, 0x00}},	{{0x00, 0x00, 0x00, 0x3E, 0x00, 0x00, 0x00, 0x00}},	{{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00}},	{{0x00, 0x02, 0x04, 0x08, 0x10, 0x20, 0x00, 0x00}},
	{{0x1C, 0x22, 0x26, 0x2A, 0x32, 0x22, 0x1C, 0x00}},	{{0x08, 0x18, 0x08, 0x08, 0x08, 0x08, 0x1C, 0x00}},	{{0x1C, 0x22, 0x02, 0x0C, 0x10, 0x20, 0x3E, 0x00}},	{{0x3E, 0x02, 0x04, 0x0C, 0x02, 0x22, 0x1C, 0x00}},
	{{0x04, 0x0C, 0x14, 0x24, 0x3E, 0x04, 0x04, 0x00}},	{{0x3E, 0x20, 0x3C, 0x02, 0x02, 0x22, 0x1C, 0x00}},	{{0x0E, 0x10, 0x20, 0x3C, 0x22, 0x22, 0x1C, 0x00}},	{{0x3E, 0x02, 0x04, 0x08, 0x10, 0x10, 0x10, 0x00}},
	{{0x1C, 0x22, 0x22, 0x1C, 0x22, 0x22, 0x1C, 0x00}},	{{0x1C, 0x22, 0x22, 0x1E, 0x02, 0x04, 0x38, 0x00}},	{{0x00, 0x00, 0x08, 0x00, 0x08, 0x00, 0x00, 0x00}},	{{0x00, 0x00, 0x08, 0x00, 0x08, 0x08, 0x10, 0x00}},
	{{0x04, 0x08, 0x10, 0x20, 0x10, 0x08, 0x04, 0x00}},	{{0x00, 0x00, 0x3E, 0x00, 0x3E, 0x00, 0x00, 0x00}},	{{0x10, 0x08, 0x04, 0x02, 0x04, 0x08, 0x10, 0x00}},	{{0x1C, 0x22, 0x04, 0x08, 0x08, 0x00, 0x08, 0x00}},
	{{0x1C, 0x22, 0x2A, 0x2E, 0x2C, 0x20, 0x1E, 0x00}},	{{0x08, 0x14, 0x22, 0x22, 0x3E, 0x22, 0x22, 0x00}},	{{0x3C, 0x22, 0x22, 0x3C, 0x22, 0x22, 0x3C, 0x00}},	{{0x1C, 0x22, 0x20, 0x20, 0x20, 0x22, 0x1C, 0x00}},
	{{0x3C, 0x22, 0x22, 0x22, 0x22, 0x22, 0x3C, 0x00}},	{{0x3E, 0x20, 0x20, 0x3C, 0x20, 0x20, 0x3E, 0x00}},	{{0x3E, 0x20, 0x20, 0x3C, 0x20, 0x20, 0x20, 0x00}},	{{0x1E, 0x20, 0x20, 0x20, 0x26, 0x22, 0x1E, 0x00}},
	{{0x22, 0x22, 0x22, 0x3E, 0x22, 0x22, 0x22, 0x00}},	{{0x1C, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1C, 0x00}},	{{0x02, 0x02, 0x02, 0x02, 0x02, 0x22, 0x1C, 0x00}},	{{0x22, 0x24, 0x28, 0x30, 0x28, 0x24, 0x22, 0x00}},
	{{0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3E, 0x00}},	{{0x22, 0x36, 0x2A, 0x2A, 0x22, 0x22, 0x22, 0x00}},	{{0x22, 0x22, 0x32, 0x2A, 0x26, 0x22, 0x22, 0x00}},	{{0x1C, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1C, 0x00}},
	{{0x3C, 0x22, 0x22, 0x3C, 0x20, 0x20, 0x20, 0x00}},	{{0x1C, 0x22, 0x22, 0x22, 0x2A, 0x24, 0x1A, 0x00}},	{{0x3C, 0x22, 0x22, 0x3C, 0x28, 0x24, 0x22, 0x00}},	{{0x1C, 0x22, 0x20, 0x1C, 0x02, 0x22, 0x1C, 0x00}},
	{{0x3E, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00}},	{{0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1C, 0x00}},	{{0x22, 0x22, 0x22, 0x22, 0x22, 0x14, 0x08, 0x00}},	{{0x22, 0x22, 0x22, 0x2A, 0x2A, 0x36, 0x22, 0x00}},
	{{0x22, 0x22, 0x14, 0x08, 0x14, 0x22, 0x22, 0x00}},	{{0x22, 0x22, 0x14, 0x08, 0x08, 0x08, 0x08, 0x00}},	{{0x3E, 0x02, 0x04, 0x08, 0x10, 0x20, 0x3E, 0x00}},	{{0x3E, 0x30, 0x30, 0x30, 0x30, 0x30, 0x3E, 0x00}},
	{{0x00, 0x20, 0x10, 0x08, 0x04, 0x02, 0x00, 0x00}},	{{0x3E, 0x06, 0x06, 0x06, 0x06, 0x06, 0x3E, 0x00}},	{{0x00, 0x00, 0x08, 0x14, 0x22, 0x00, 0x00, 0x00}},	{{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F}},
	{{0x10, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00}},	{{0x00, 0x00, 0x1C, 0x02, 0x1E, 0x22, 0x1E, 0x00}},	{{0x20, 0x20, 0x3C, 0x22, 0x22, 0x22, 0x3C, 0x00}},	{{0x00, 0x00, 0x1E, 0x20, 0x20, 0x20, 0x1E, 0x00}},
	{{0x02, 0x02, 0x1E, 0x22, 0x22, 0x22, 0x1E, 0x00}},	{{0x00, 0x00, 0x1C, 0x22, 0x3E, 0x20, 0x1E, 0x00}},	{{0x0C, 0x12, 0x10, 0x3C, 0x10, 0x10, 0x10, 0x00}},	{{0x00, 0x00, 0x1C, 0x22, 0x22, 0x1E, 0x02, 0x1C}},
	{{0x20, 0x20, 0x3C, 0x22, 0x22, 0x22, 0x22, 0x00}},	{{0x08, 0x00, 0x18, 0x08, 0x08, 0x08, 0x1C, 0x00}},	{{0x04, 0x00, 0x0C, 0x04, 0x04, 0x04, 0x24, 0x18}},	{{0x20, 0x20, 0x22, 0x24, 0x38, 0x24, 0x22, 0x00}},
	{{0x18, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1C, 0x00}},	{{0x00, 0x00, 0x36, 0x2A, 0x2A, 0x2A, 0x22, 0x00}},	{{0x00, 0x00, 0x3C, 0x22, 0x22, 0x22, 0x22, 0x00}},	{{0x00, 0x00, 0x1C, 0x22, 0x22, 0x22, 0x1C, 0x00}},
	{{0x00, 0x00, 0x3C, 0x22, 0x22, 0x3C, 0x20, 0x20}},	{{0x00, 0x00, 0x1E, 0x22, 0x22, 0x1E, 0x02, 0x02}},	{{0x00, 0x00, 0x2E, 0x30, 0x20, 0x20, 0x20, 0x00}},	{{0x00, 0x00, 0x1E, 0x20, 0x1C, 0x02, 0x3C, 0x00}},
	{{0x10, 0x10, 0x3C, 0x10, 0x10, 0x12, 0x0C, 0x00}},	{{0x00, 0x00, 0x22, 0x22, 0x22, 0x26, 0x1A, 0x00}},	{{0x00, 0x00, 0x22, 0x22, 0x22, 0x14, 0x08, 0x00}},	{{0x00, 0x00, 0x22, 0x22, 0x2A, 0x2A, 0x36, 0x00}},
	{{0x00, 0x00, 0x22, 0x14, 0x08, 0x14, 0x22, 0x00}},	{{0x00, 0x00, 0x22, 0x22, 0x22, 0x1E, 0x02, 0x1C}},	{{0x00, 0x00, 0x3E, 0x04, 0x08, 0x10, 0x3E, 0x00}},	{{0x0E, 0x18, 0x18, 0x30, 0x18, 0x18, 0x0E, 0x00}},
	{{0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08}},	{{0x38, 0x0C, 0x0C, 0x06, 0x0C, 0x0C, 0x38, 0x00}},	{{0x1A, 0x2C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}},	{{0x00, 0x2A, 0x14, 0x2A, 0x14, 0x2A, 0x00, 0x00}}
};

/* a2font.c */
extern void a2_load_default_font(void);
extern void a2_load_font(char * fn);
extern A2_CHARACTER_BITMAP a2_get_font_char(unsigned char ch);

#endif

