/*
 * Appleblossom - Portable Open-Source Apple IIe Emulator
 * Copyright (C) 2005 Jonathan Bettencourt (jonrelay)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __A2VARS_H__
#define __A2VARS_H__

#include <stdio.h>

/* Memory */

unsigned char A2_MAIN[0xC000]; /* main memory 0x0000 - 0xBFFF */
unsigned char A2_AUX[0xC000]; /* auxiliary memory 0x0000 - 0xBFFF */
unsigned char A2_ROM[0x4000]; /* Apple II ROM 0xC000 - 0xFFFF */
unsigned char A2_BS_RAM[0x4000]; /* bank-switched RAM 0xD000 - 0xFFFF (with two banks in 0xD000-0xDFFF) */
unsigned char A2_ABS_RAM[0x4000]; /* aux bank-switched RAM 0xD000 - 0xFFFF (with two banks in 0xD000-0xDFFF) */
unsigned char A2_PERIPH_ROM[0x800]; /* peripheral card ROM 0xC000 - 0xC7FF */
unsigned char A2_PERIPH_XROM[0x4000]; /* peripheral card ROM 0xC800 - 0xCFFF */

int A2_CLOCK;

/* Apple II IO-Related Soft Switches */

unsigned char A2_KEYBOARD;
int A2_CASSETTE_OUT;
int A2_CASSETTE_IN;
int A2_SPEAKER;
int A2_STROBE;
int A2_ANN0;
int A2_ANN1;
int A2_ANN2;
int A2_ANN3;
int A2_PB0;
int A2_PB1;
int A2_PB2;
int A2_PDL0_VALUE;
int A2_PDL1_VALUE;
int A2_PDL2_VALUE;
int A2_PDL3_VALUE;
int A2_PDL0_TIMER;
int A2_PDL1_TIMER;
int A2_PDL2_TIMER;
int A2_PDL3_TIMER;
int A2_PDL_CLOCKSTART;
int A2_VBL;

/* Apple II Video-Related Soft Switches */

int A2_80VIDEO;
int A2_ALTCHAR;
int A2_GRAPHICS;
int A2_MIXED;
int A2_HIRES;
int A2_PAGE2;

/* Apple II Memory-Related Soft Switches */

int A2_80STORE; /* off = use soft switches for aux mem; on = use page 2 for aux mem */
int A2_RDAUXRAM; /* on = read aux mem 0x200 - 0xBFFF */
int A2_WRAUXRAM; /* on = write aux mem 0x200 - 0xBFFF */
int A2_INTROM; /* off = read peripheral ROM 0xC100 - 0xCFFF; on = read internal ROM 0xC100 - 0xCFFF */
int A2_AUXZP; /* off = r/w main zp/stack; on = r/w aux zp/stack */
int A2_SLOT3ROM; /* off = read slot 3 ROM 0xC300 - 0xC3FF; on = read aux slot ROM 0xC300 - 0xC3FF */
int A2_RDBSRAM; /* on = read RAM 0xD000 - 0xFFFF */
int A2_WRBSRAM; /* on = write RAM 0xD000 - 0xFFFF */
int A2_RWB2RAM; /* on = bank 2 of 0xD000 - 0xDFFF */
int A2_IOUDIS; /* IOU Disable - I'm actually not sure what this does */
int A2_IOSELECT; /* current peripheral card using 0xC800-0xCFFF space */
int A2_C069CNT;
int A2_LASTRW;
int A2_DBLREAD;

/* Disk II */

unsigned char * A2_DISK[2];
char A2_DISK_PATH[2][256];
int A2_DISK_WRPROTECT[2];
int A2_DISK_PRODOS_ORDER[2];
int A2_DISK_DIRTY[2];

/* Hard Disk */

unsigned char * A2_HDISK[2];
int A2_HDISK_LEN[2];
char A2_HDISK_PATH[2][256];
int A2_HDISK_WRPROTECT[2];
int A2_HDISK_DIRTY[2];

/* Serial Ports */

FILE * A2_SERIAL_IN[2];
FILE * A2_SERIAL_OUT[2];

#endif

