/*
 * Apple iiPod - Appleblossom Interface for iPodLinux
 * Copyright (C) 2005 Jonathan Bettencourt (jonrelay)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "../a2includes.h"
#include "ifvars.h"
#include "nano-X.h"

const long int a2_tinyfont_bitmaps[] = {
	/* INVERSE @A-Z[\]^_ */
	0xDABCF, 0xDA8AF, 0x98A9F, 0xCBBCF, 0x9AA9F, 0x89B8F, 0x8B9BF, 0xCBACF,
	0xA88AF, 0x8DD8F, 0x8DDBF, 0xA99AF, 0xBBB8F, 0x88AAF, 0xA8AAF, 0xDAADF,
	0x9A9BF, 0xDAACF, 0x9A9AF, 0xC9C9F, 0x8DDDF, 0xAAADF, 0xAADDF, 0xAA88F,
	0xADDAF, 0xADDDF, 0x8EB8F, 0xCDDCF, 0xBDDEF, 0x9DD9F, 0xDAFFF, 0xFFF8F,
	/* INVERSE  !"0-9:;? */
	0xFFFFF, 0xDDFDF, 0xAAFFF, 0xA8A8A, 0xDC9DF, 0xAEBAF, 0xDC9CF, 0xDDFFF,
	0xDBBDF, 0xDEEDF, 0xD8D8D, 0xFD8DF, 0xFFFDB, 0xFF8FF, 0xFFFDF, 0xEDDBF,
	0xDAADF, 0xD9D8F, 0x9ED8F, 0x9CE9F, 0xA8EEF, 0x89E9F, 0xC9ADF, 0x8EDDF,
	0x8DADF, 0xCACEF, 0xFDFDF, 0xFDFDB, 0xFDBDF, 0xF8F8F, 0xFDEDF, 0x9EFDF,
	/* MOUSETEXT */
	0x43630, 0x43630, 0x46740, 0x75257, 0x01A40, 0xFE5BF, 0xEA0BF, 0xF0F0F,
	0x04F40, 0x00050, 0x22720, 0x27220, 0xF0000, 0x15F40, 0xEEEEE, 0x04F40,
	0x02F20, 0x22720, 0x27220, 0x00F00, 0x8888F, 0x02F20, 0x5A5A5, 0xA5A5A,
	0x698F0, 0x0E1F0, 0x11111, 0x27F72, 0xF000F, 0x5D0D5, 0xF151F, 0x88888,
	/* INVERSE `a-z{|}~  */
	0xBDFFF, 0xF9CCF, 0xB9A9F, 0xFCBCF, 0xECACF, 0xFD9CF, 0xED8DF, 0xFCAC9,
	0xB9AAF, 0xDFDDF, 0xDFDDB, 0xBA9AF, 0xDDDDF, 0xF98AF, 0xF9AAF, 0xFDADF,
	0xF9A9B, 0xFCACE, 0xFA9BF, 0xFCD9F, 0xD8DEF, 0xFAACF, 0xFA8DF, 0xFA88F,
	0xFADAF, 0xFAAC9, 0xF8D8F, 0xE9DEF, 0xDDDDD, 0xBCDBF, 0x9CFFF, 0xADADA,
	/* @A-Z[\]^_ */
	0x25430, 0x25750, 0x67560, 0x34430, 0x65560, 0x76470, 0x74640, 0x34530,
	0x57750, 0x72270, 0x72240, 0x56650, 0x44470, 0x77550, 0x57550, 0x25520,
	0x65640, 0x25530, 0x65650, 0x36360, 0x72220, 0x55520, 0x55220, 0x55770,
	0x52250, 0x52220, 0x71470, 0x32230, 0x42210, 0x62260, 0x25000, 0x00070,
	/*  !"0-9:;? */
	0x00000, 0x22020, 0x55000, 0x57575, 0x23620, 0x51450, 0x23630, 0x22000,
	0x24420, 0x21120, 0x27272, 0x02720, 0x00024, 0x00700, 0x00020, 0x12240,
	0x25520, 0x26270, 0x61270, 0x63160, 0x57110, 0x76160, 0x36520, 0x71220,
	0x72520, 0x35310, 0x02020, 0x02024, 0x02420, 0x07070, 0x02120, 0x61020,
	/* @A-Z[\]^_ */
	0x25430, 0x25750, 0x67560, 0x34430, 0x65560, 0x76470, 0x74640, 0x34530,
	0x57750, 0x72270, 0x72240, 0x56650, 0x44470, 0x77550, 0x57550, 0x25520,
	0x65640, 0x25530, 0x65650, 0x36360, 0x72220, 0x55520, 0x55220, 0x55770,
	0x52250, 0x52220, 0x71470, 0x32230, 0x42210, 0x62260, 0x25000, 0x00070,
	/* `a-z{|}~  */
	0x42000, 0x06330, 0x46560, 0x03430, 0x13530, 0x02630, 0x12720, 0x03536,
	0x46550, 0x20220, 0x20224, 0x45650, 0x22220, 0x06750, 0x06550, 0x02520,
	0x06564, 0x03531, 0x05640, 0x03260, 0x27210, 0x05530, 0x05720, 0x05770,
	0x05250, 0x05536, 0x07270, 0x16210, 0x22222, 0x43240, 0x63000, 0x52525
};

long int a2_tinyfont_char(unsigned char ch)
{
	if (A2_ALTCHAR || (ch >= 128)) {
		return a2_tinyfont_bitmaps[ch];
	} else {
		return a2_tinyfont_bitmaps[ch & 0x3F];
	}
}

void a2_draw_char_40(GR_WINDOW_ID wid, GR_GC_ID gc, unsigned char ch, int x, int y)
{
	long int bmp = a2_tinyfont_char(ch);
	int r, row;
	for (r=4; r>=0; r--) {
		row = (bmp & 0xF);
		GrSetGCForeground( gc, ((row & 8)?WHITE:BLACK) );
		GrPoint(wid, gc, x+0, y+r);
		GrSetGCForeground( gc, ((row & 4)?WHITE:BLACK) );
		GrPoint(wid, gc, x+1, y+r);
		GrSetGCForeground( gc, ((row & 2)?WHITE:BLACK) );
		GrPoint(wid, gc, x+2, y+r);
		GrSetGCForeground( gc, ((row & 1)?WHITE:BLACK) );
		GrPoint(wid, gc, x+3, y+r);
		bmp >>= 4;
	}
}

#define __halfdither(a, b) (((a)&&(b))?WHITE:(((a)||(b))?LTGRAY:BLACK))

void a2_draw_char_80(GR_WINDOW_ID wid, GR_GC_ID gc, unsigned char ch, int x, int y)
{
	long int bmp = a2_tinyfont_char(ch);
	int r, row;
	for (r=4; r>=0; r--) {
		row = (bmp & 0xF);
		GrSetGCForeground( gc, __halfdither((row & 8),(row & 4)) );
		GrPoint(wid, gc, x+0, y+r);
		GrSetGCForeground( gc, __halfdither((row & 2),(row & 1)) );
		GrPoint(wid, gc, x+1, y+r);
		bmp >>= 4;
	}
}


