/*
 * Apple iiPod - Appleblossom Interface for iPodLinux
 * Copyright (C) 2005 Jonathan Bettencourt (jonrelay)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __IFVARS_H__
#define __IFVARS_H__

#include "nano-X.h"

#define BLACK (GR_RGB(0,0,0))
#define WHITE (GR_RGB(255,255,255))
#define LTGRAY (GR_RGB(160,160,160))

GR_GC_ID a2_gc;
GR_WINDOW_ID a2_wid;
GR_WINDOW_ID a2_bufwid;
GR_TIMER_ID a2_tid;

int a2_emulating;

int a2_selected_palette;

/* Keys */
/*
	0 - Menu
	255 - Ctrl-Reset
	8 - Left/Bksp
	21 - Right
	11 - Up
	10 - Down
	32 - Space
	9 - Tab
	13 - Return
	27 - Esc
	127 - Del
	128 - PB0
	129 - PB1
	130 - PB2
	132 - Pdl 0 Left
	133 - Pdl 0 Right
	134 - Pdl 1 Left
	135 - Pdl 1 Right
	136 - Pdl 2 Left
	137 - Pdl 2 Right
	138 - Pdl 3 Left
	139 - Pdl 3 Right
	144 - Keyboard Left
	145 - Keyboard Right
	146 - Keyboard Enter
*/
unsigned char a2_rew_key;
unsigned char a2_menu_key;
unsigned char a2_play_key;
unsigned char a2_ff_key;
unsigned char a2_wl_key;
unsigned char a2_wr_key;
unsigned char a2_act_key;

int a2_keyboard_orientation;
int a2_keyboard_pos;

#endif
