;------------------------------------------------------------------------
; Constants
;------------------------------------------------------------------------

DEF_LOMEM       .EQ     $06             Default lomem page
DEF_AUTO        .EQ     1000            Default Auto line number start
DEF_INC         .EQ     10              Default Auto increment step
DEF_ORG         .EQ     $0280           Default .OR
DEF_OBJLOW      .EQ     $0200           Default lowest object address

PROMPT          .EQ     "%"             The assembler prompt character
CR              .EQ     $8D             CR character
ESC             .EQ     $9B             ESC character
BS              .EQ     $DF             Back space key
TAB             .EQ     $89             TAB character

TAB1            .EQ     8               1st tab stop
TAB2            .EQ     12              2nd tab stop
TAB3            .EQ     21              3rd tab stop

;------------------------------------------------------------------------
; Zero page memory
; Input buffer placed in ZP because of the many references to it. Must be
;  completely in ZP because address + index remains only one byte address
; PASS must remain the first label here! See INIT routine
;------------------------------------------------------------------------

                .DU     $003E           Leave 1st part of ZP free

IN              .BS     128             Input and parse buffer

;------------------------------------------------------------------------
; Assembler registers

PASS            .BS     1               Assembler pass 0=1, 1=2
GLOBAL          .BS     2               Last defined Global label
GLOBAL_VAL      .BS     2               Last defined Global's value
LABEL_FLAG      .BS     1               Found label's assigned flag (b7)
PNTR            .BS     2               Pointer in source
INDEX           .BS     1               Index mode 0, X or Y
PC              .BS     2               Current program counter
TA              .BS     2               Current target address
TA_BEGIN        .BS     2               Begin of target address block
PC_BEG          .BS     2               Program counter at start of line
ASM_ERR         .BS     1               Assemble errors (max 255)
UNDEF           .BS     1               Undefined label if <> 0
FORWARD         .BS     1               Forward referenced label if <> 0
LL_NUM          .BS     1               Local label's number
FIRST_CHAR      .BS     1               First character of a label

;------------------------------------------------------------------------
; Editor's registers

CMD_CHR         .BS     1               First character of command
ERROR           .BS     1               Latest error
DUMP            .BS     1               Dump mode in list command
PARM1           .BS     2               Parameter 1
PARM2           .BS     2               Parameter 2

;------------------------------------------------------------------------
; General purpose registers

NEG_FLAG        .BS     1               Negative flag (if <> 0)
COUNT           .BS     1               GP counter
DELIM           .BS     1               String/ASCII delimiter
HEXVAL          .BS     2               16-bit value of expression
LEAD0           .BS     1               Leading 0 flag
CHAR            .BS     1               Character compilation register
MULDIV          .BS     2               Multiply/divide temp
EXP_SAVE        .BS     2               Expression save value
DEC_SAVE        .BS     2               Decimal convert save value
SAVE_Y          .BS     1               Save Y pointer
LENG            .BS     2               Length of block move
SRCE            .BS     2               Source for block move
DEST            .BS     2               Destination for block move

;------------------------------------------------------------------------
; Registers which are best not to be disturbed by user's program!

OLD_SAVE        .BS     1               OLD possible if <> 0
AUTO            .BS     2               Next Auto line number
AUTO_INC        .BS     1               Auto increment
AUTO_FLAG       .BS     1               Auto mode flag (if <> -)

SYM_TABLE       .BS     2               Symbol table (if MSB <> 0)
XEC_LAST        .BS     2               Last Xec address
USR_OBJLO       .BS     2               User's safe object begin
USR_OBJHI       .BS     2               User's safe object end
LOMEM           .BS     2               Lomem address   | Don't
HIMEM           .BS     2               Himem address |  change order

;------------------------------------------------------------------------
; See if we haven't crossed the page boundary

                .DO     $>$100          $100 is still OK!
                .ER     F,/Beyond zero page!/
                .FI

;------------------------------------------------------------------------
; Other memory and I/O
;------------------------------------------------------------------------

KBD             .EQ     $D010           Keyboard input register
KBDCR           .EQ     $D011           Keyboard control register

;------------------------------------------------------------------------
; ROM routines
;------------------------------------------------------------------------

WOZMON          .EQ     $FF1A           Official entry point to WOZmon
PRBYTE          .EQ     $FFDC           Print A in HEX
ECHO            .EQ     $FFEF           Print a character to the screen
