**********************************************************
*                                                        *
*              C R A T E . B P R U N N E R               *
*                                                        *
*            Michael J. Mahon - May 31, 2008             *
*                 Revised Jan 24, 2009                   *
*                                                        *
*    Copyright (c) 1996, 2003, 2004, 2005, 2008, 2009    *
*                                                        *
*   CRATE.BPRUNNER uses the BCAST protocol to receive    *
*   a BASIC program on all machines on which it is       *
*   running.                                             *
*                                                        *
*   It sets the KSW vector to re-enter SERVELP, so that  *
*   the program ends upon its first request for input.   *
*                                                        *
*   CR.BPRUNNER performs the following actions:          *
*     1. Coldstarts Applesoft                            *
*     2. Serves a BCAST request with tag $E0xx to        *
*        receive the Applesoft program                   *
*     3. Sets up Applesoft pointers                      *
*     4. RUNs the program                                *
*                                                        *
**********************************************************
*                                                        *
*                    Change History                      *
*                                                        *
*   01/24/09:                                            *
*                                                        *
*   Added code to clear ONERR flag before RUN.           *
*                                                        *
*   10/06/08:                                            *
*                                                        *
*   Revised to use SERVER to serve BCAST request.        *
*                                                        *
*   09/26/08:                                            *
*                                                        *
*   Modified to use NADAUSER definitions.                *
*                                                        *
*   08/21/08:                                            *
*                                                        *
*   Modified to use new BCAST request and v3.0 packet    *
*   format.                                              *
*                                                        *
*   05/31/08:                                            *
*                                                        *
*   First version, adapted from ROM boot code.           *
*                                                        *
**********************************************************
         pag
******************** Version setup ***********************

         org   $200       ; Load to page 2
master   equ   0          ; Non-master version
dos      equ   0          ; Non-DOS version
crate    equ   1          ; Crate version compatibiluty
mserve   equ   0          ; Non-Message Server version
ROMboot  equ   0          ; ROM boot version
enhboot  equ   0          ; Enhanced //e version

         put   NADACONST
         use   NADAMACS
loadpnt  equ   $B800      ; Crate start address
         put   nadauser
         pag
**********************************************************
*                                                        *
*                    CRATE.BPRUNNER                      *
*                                                        *
**********************************************************

BPRUNNER ldy   #0         ; Print the "Awaiting prog"
:msglp   lda   wtmsg,y    ;  message.
         jsr   COUT
         iny
         cpy   #]wtlen
         bcc   :msglp
         mov16 #:resume   ;KSW ; Set to get control
         jmp   COLDSTRT   ;    after coldstart.
:resume  mov16 #warmstrt  ;KSW ; First input ends prog.
         lda   nadapage   ; Set HIMEM
         sta   HIMEM+1    ;  and FRETOP to
         sta   FRETOP+1   ;   NadaNet load page.
         lda   #0         ; Clear the
         sta   ONERR      ;  ONERR flag.
:restart jsr   serve      ; Serve requests...
         lda   rbuf+rqmd  ; Is it a BCAST request?
         cmp   #r_BCAST+rm_REQ
         bne   :restart   ; -No, serve again.
         inc   rbuf+rqmd  ; -Yes, just once!
         lda   address+1  ; Is hi byte of tag
         cmp   #t_BASIC   ;  = BASIC prog?
         bne   :restart   ; -No, not our BCAST!
         mov16 #$801      ;address ; Set address to $801
         jsr   rcvlong    ; Read the program.
         bcs   :restart   ; -error, start over.
         lda   PSTART     ; Set up PROGEND
         adc   rbuf+len   ;  and VARTAB to
         sta   PROGEND    ;   end of program.
         sta   VARTAB
         lda   PSTART+1
         adc   rbuf+len+1
         sta   PROGEND+1
         sta   VARTAB+1
         jmp   RUNPROG    ; RUN the Applesoft prog.

         err   *-1/$280   ; BPRUN &POKEs IDTBL
         ds    $2C0-*     ;  into $280..$2BF.

* BPRUNNER message

wtmsg    asc   "Awaiting broadcast BASIC program",8D
]wtlen   equ   *-wtmsg    ; Length of msg.

         align 256        ; Align to page boundary
endcode  equ   *
         err   *-1/$300   ; Can't exceed $300
         end
