         do    1-ROMboot
*** Table of service routines used by SERVER ***

service  dw    PEEKSRV    ; Table of service routines
         dw    POKESRV    ; (Must be in order)
         dw    CALLSRV
         do    mserve
         dw    PUTMSRV
         dw    GETMSRV
         else             ; (not mserve)
         dw    ]PROTERR   ; (Error if PUTMSG)
         dw    ]PROTERR   ; (Error if GETMSG)
         fin              ; (end mserve)
         do    master     ; Only if 'master'
         dw    GETIDSRV   ; Master serves GETID
         else             ; (not master)
         dw    ]PROTERR   ; (Error if GETID)
         fin              ; (end master)
         dw    ]PROTERR   ; (Error if non-bcast BOOT)
         dw    rarl=>al   ; (BCAST data up to caller)
         dw    BPOKESRV
         dw    PKINCSRV
         dw    PKPOKSRV
         do    mserve
         dw    ]PROTERR   ; (Error if RUN)
         else             ; (master or crate)
         dw    RUNSRV
         fin
         dw    BRUNSRV

* Version message printed by INIT

vermsg   asc   "NADANET "
         db    version/16."0" ; Major version #
         asc   "."
         db    version&$0F."0" ; Minor version #
         do    mserve
         asc   " Message Server"
         fin
         asc   ", ID = $"
verlen   equ   *-vermsg   ; Length of msg
         pag
**********************************************************
*                                                        *
*                        I N I T                         *
*                                                        *
*             Michael J. Mahon - Mar 5, 2004             *
*                  Revised May 21, 2008                  *
*                                                        *
*          Copyright (c) 1996, 2004, 2005, 2008          *
*                                                        *
*  Initialize NADANET, sign on, and return to caller.    *
*                                                        *
**********************************************************

INIT     lda   bootself   ; Set up ID from BOOT
         jsr   setid
         bcs   :err       ; Bad ID, no INIT.
         lda   #$4C       ; Set warmstrt JMP to
         sta   warmstrt   ;  servlp (& nadapage)
         mov16 #servelp   ;warmstrt+1
         jsr   CROUT1     ; New line.
         ldy   #0
:msgloop lda   vermsg,y   ; Print version message
         jsr   COUT
         iny
         cpy   #verlen
         bcc   :msgloop
         lda   self       ;  and current ID.
         jsr   PRBYTE     ;   (in hex)
         jsr   CROUT1     ; New line.
         clc              ; Good return.
:err     rts
         pag
         fin   (1-ROMboot)
**********************************************************
*                                                        *
*                       S E T I D                        *
*                                                        *
*            Michael J. Mahon - May 13, 2004             *
*                  Revised Aug 17, 2008                  *
*                                                        *
*                Copyright (c) 2004, 2008                *
*                                                        *
*  Set machine ID to contents of A register and reset    *
*  the arbitration delay to 'arbtime' plus 22 cycles     *
*  times the machine ID, to avoid collisions.            *
*                                                        *
*  Delay from last arbitration poll to bus lock is 10    *
*  cycles, so 22 (2 * 11 cycles) increment provides a    *
*  little insurance.                                     *
*                                                        *
**********************************************************

setid    sta   self       ; Machine ID
         sta   sbuf+frm   ; Set sender field.
         eor   #$FF       ; Complement ID
         sta   sbuf+frmc  ;  for collision detect.
         eor   #$FF       ; Back to ID
         sec              ; Anticipate error.
         beq   :err       ; -Error if zero.
         clc              ; Anticipate no error.
         bmi   :setarb    ; -Use temp ID (>127)
         asl              ; Mult ID by 2
         adc   #arbx      ;  and add to base
:setarb  sta   arbxv      ;   arb delay.
:err     rts
         do    1-ROMboot
         pag
**********************************************************
*                                                        *
*                      S E R V E R                       *
*                                                        *
*             Michael J. Mahon - May 5, 1996             *
*                  Revised Oct 06, 2008                  *
*                                                        *
*             Copyright (c) 1996, 2004, 2008             *
*                                                        *
*  SERVER continually listens to the net, receiving all  *
*  packets, and responding to control packets directed   *
*  to 'self'.  If a key is pressed or a request handled, *
*  SERVER returns. C = 0 if count expired and is set as  *
*  the request server left it if a request was handled.  *
*                                                        *
*  To minimize missed polls, SERVER temporarily raises   *
*  RCVPKT's timeout to 20ms. from the normal value equal *
*  to the minimum arbitration time.                      *
*                                                        *
*  For every request code, there is a corresponding      *
*  server routine.  SERVER invokes these routines to     *
*  satisfy the service requests it receives.  Upon entry *
*  to 'xxxSRV', C = 0 and (X) = (rbuf+rqmd).             *
*                                                        *
*  To ensure that the next packet received is the start  *
*  packet of a request protocol, it is necessary to wait *
*  for the net to be idle or locked for at least the min *
*  arbitration time before receiving a request.  (Note   *
*  that broadcast requests begin with the network in a   *
*  locked state.)                                        *
*                                                        *
*  The entry point 'svrxkbd' is provided for 'servelp',  *
*  which ignores keyboard input.                         *
*                                                        *
**********************************************************

svrxkbd  lda   kbstrobe   ; Ignore any keypress

SERVER   lda   #idleto    ; While polling, raise
         sta   tolim      ;  RCVPKT timeout to 20ms.
:resync  ldx   #servegap  ; Delay min arb time
         cmp   zipslow    ; Zip Chip to 1MHz mode.
         ldy   drecv      ; Sample net state.
:waitidl tya
         eor   drecv      ; Has net changed?
         bmi   :resync    ; -Yes, restart timing.
         dex              ; -No, count it down.
         bne   :waitidl   ; -Keep waiting.
:serve   lda   keybd      ; Check if key pressed.
         bmi   :exit      ; -Yes, return.
         jsr   RCVCTL     ; Receive ctl pkt to 'rbuf'
         bcs   :err       ; -Timeout or Cksum err.
         lda   rbuf+frmc  ; -Cksum OK, verify that
         eor   #$FF       ;   complement of 'frmc'
         cmp   rbuf+frm   ;    is equal to 'frm'.
         bne   :frmcerr   ; -No, count collisions.
         lda   rbuf+dst   ; -Yes, good packet.
         beq   :bcastck   ; Broadcast packet OK?
         cmp   self       ; Directed to us?
         bne   :skip      ; -No, just keep time.
:bcast   lda   rbuf+rqmd  ; -Yes, get 'rqmd'
         tax              ;   and save in X.
         and   #modmask   ; Is the modifier
         cmp   #rm_REQ    ;  a Request?
         bne   ]PROTERR   ; -No, protocol error.
         txa              ; -Yes, check request.
         and   #reqmask
         beq   ]PROTERR   ; Code must be > 0
         cmp   #maxreq    ;  and < maxreq.
         bcs   ]PROTERR   ; Invalid request.
         lsr              ; Req code is * 8,
         lsr              ;  so divide by 4. (C=0)
         tay              ; Index of service routine
         mov16 service-2,y ;address ; Set up address
         lda   #reqto     ; Reset timeout to min
         sta   tolim      ;  arbitration time.
         jmp   (address)  ; Jump to service routine.

:bcastck lda   rbuf+rqmd  ; Ck broadcast valid..
         cmp   #r_BPOKE+rm_REQ ; BPOKE request?
         beq   :bcast     ; -Yes, process request.
         cmp   #r_BCAST+rm_REQ ; Broadcast BCAST req?
         beq   :bcast     ; -Yes.
         cmp   #r_BOOT+rm_REQ ; Broadcast BOOT req?
         beq   :skip      ; -Yes, ignore.
]PROTERR jsr   PROTERR    ; Record protocol error
:skip    dec   reqctr     ; Enough requests seen?
         bne   :resync    ; -No, re-sync SERVER.
         lda   #reqpidle  ; -Yes, about 20ms used.
         sta   reqctr     ; Reset counter.
         dec   servecnt   ; Enough iterations?
         beq   :exit      ; -Yes, return.
         bne   :resync    ; -No, re-sync SERVER.

:frmcerr inc16 frmcerr    ; Count sync'd collisions.
         bne   :skip      ; (always)

:err     bne   :skip      ; -Cksum error.
         dec   servecnt   ; -Timeout.  Enough?
         bne   :serve     ; -No, keep serving.
:exit    lda   #reqto     ; -Yes, restore normal
         sta   tolim      ;   request timeout,
         clc              ;    clear Carry
         rts              ;     and return.
         fin   (1-ROMboot)
         do    master+crate
         pag
*--------------------------------------------------------*
*            Broadcast Boot & Bcast Protocol             *
*--------------------------------------------------------*
*          Master                       Slaves           *
*  ========================     =======================  *
*  Bxxx   REQ (addr,leng)  ====>                         *
*                  (800 cyc. delay)                      *
*                    Data  ====>                         *
*                            :                           *
*                    Data  ====>                         *
*--------------------------------------------------------*
         pag
**********************************************************
*                                                        *
*          B O O T R E Q   &   B C A S T R E Q           *
*                                                        *
*            Michael J. Mahon - May 14, 2004             *
*                  Revised Apr 28, 2010                  *
*                                                        *
*             Copyright (c) 2004, 2008, 2010             *
*                                                        *
*  Broadcast request for all waiting machines to receive *
*  data of 'sbuf+len' length.                            *
*                                                        *
*  BOOTREQ is handled by all machines awaiting boot.     *
*  The boot image following is loaded at 'sbuf+adr' and  *
*  control is passed to the boot image.                  *
*                                                        *
*  BCASTREQ is handled by all machines awaiting BCAST    *
*  data.  'sbuf+adr' is the "tag" for the data following,*
*  that is ignored or received by waiting machines based *
*  on their state and the tag value.                     *
*                                                        *
*  Since these requests are broadcast, they do not get   *
*  ACKs from their destination(s), but simply send their *
*  data blindly.  If errors occur, waiting machines will *
*  continue to wait for good data, so verification of    *
*  proper operation must be handled separately.          *
*                                                        *
*  Because broadcast data is sent "open loop", and since *
*  BCAST clients may require time to determine whether   *
*  and how they should receive the following data, these *
*  protocols delay for 800 cycles between the request    *
*  and the sending of data.                              *
*                                                        *
*  BOOTREQ & BCASTREQ do the following steps:            *
*     1. Sets up the request                             *
*     2. Does a broadcast arbitration to seize the net   *
*        and delay 20ms to resolve any collisions and    *
*        allow slow pollers to reach their RCVPKT holds  *
*     3. Sends the request, with address/tag and length  *
*     4. Waits 800 cyc. for clients to prepare to        *
*        receive the data (or not).                      *
*     5. Sends the boot code/data stream                 *
*                                                        *
**********************************************************

BOOTREQ  lda   #r_BOOT+rm_REQ
         bne   ]doit      ; (always)

BCASTREQ lda   #r_BCAST+rm_REQ ; BCAST request
]doit    sta   sbuf+rqmd
         jsr   BCASTARB   ; Bcast arbitrate & lock bus
         jsr   SENDCTL    ; Send the BOOT request.
         jsr   lasl=>al   ; Local start address & length
         ldx   #800/5     ; Delay 800 cycles,
         jmp   DSENDLNG   ;  send data and return.
         fin   (master+crate)
         do    master








*--------------------------------------------------------*
*                    GETID Protocol                      *
*--------------------------------------------------------*
*         Requester                     Server           *
*  ========================     =======================  *
*  GETID  REQ (pseudo ID)  ====>                         *
*                          <==== GETID  ACK (ID)         *
*  GETID  DACK (ID)        ====>                         *
*--------------------------------------------------------*
         pag
**********************************************************
*                                                        *
*                    G E T I D S R V                     *
*                                                        *
*            Michael J. Mahon - May 14, 2004             *
*                 Revised Aug 17, 2008                   *
*                                                        *
*               Copyright (c) 2004, 2008                 *
*                                                        *
*  Service machine 'rbuf+frm's request to allocate a new *
*  machine ID (if 'rbuf+frm' is a pseudo-ID).            *
*                                                        *
*  The new ID is sent in the ACK packet.  GETIDSRV       *
*  requires a DACK packet from the newly allocated       *
*  machine ID before the new allocation is committed.    *
*                                                        *
*  GETIDSRV is unique in that it returns control         *
*  directly to SERVER (rather than SERVER's caller), so  *
*  that all GETID requests are processed before SERVER   *
*  returns.                                              *
*                                                        *
*  GETIDSRV does the following steps:                    *
*     1. If a pseudo-ID was received, it finds the next  *
*        available machine ID.                           *
*     2. Sends the new (or current) ID in the ACK packet *
*     3. Receives the DACK and marks the ID allocated.   *
*     4. Gives control back to SERVER.                   *
*                                                        *
**********************************************************

GETIDSRV ldx   rbuf+frm   ; Look at requester's ID
         bpl   :ack       ; -it's real, just ACK.
         ldx   #2         ; -pseudo, find new one.
:search  lda   idtable,x  ; Find lowest
         beq   :ack       ;  unused ID.
         inx
         cpx   #maxid+1
         bcc   :search
         bcs   :exit      ; Table overflow!

:ack     stx   sbuf+adr   ; Send ID to requester
         jsr   SENDACK
         lda   sbuf+adr   ; Expect new ID
         sta   sbuf+dst   ;  in DACK.
         jsr   RCVDACK
         bcs   :exit      ; -Error, don't allocate.
         ldx   sbuf+dst   ; -OK.
         lda   #1
         sta   idtable,x  ; Allocate the ID
:exit    jmp   SERVER     ; Go back to SERVER.
         fin   (master)
         pag
