* NadaNet Constant definitions

* Apple ][ definitions

keybd equ $C000 ; Keyboard port
kbstrobe equ $C010 ; Keyboard strobe
VBL equ $C019 ; Vertical blanking
spkr equ $C030 ; Speaker toggle
an0 equ $C058 ; Annunciator 0 base addr
an1 equ an0+2
an2 equ an0+4
an3 equ an0+6
pb0 equ $C061 ; "Pushbutton" 0 base addr
pb1 equ pb0+1
pb2 equ pb0+2
ptrig equ $C070 ; Paddle trigger
dsk6off equ $C0E8 ; Deselect 5.25" disk in slot 6

* Apple Monitor definitions

CSW equ $36 ; Output vector
KSW equ $38 ; Input vector
SOFTEV equ $3F2 ; Soft re-entry vector
PWREDUP equ $3F4 ; Powered-Up check byte

PRBL2 equ $F94A ; Display (X) blanks
PREAD equ $FB1E ; Read PDL(X) into Y
HOME equ $FC58 ; Clear display
CROUT1 equ $FD8B ; Clear to EOL, then CR
PRBYTE equ $FDDA ; Display A as hex byte
COUT equ $FDED ; Display character in A
BELL equ $FF3A ; Beep for 100ms.

* Applesoft definitions

PSTART equ $67 ; Start of BASIC prog
VARTAB equ $69 ; End prog / start vars
FRETOP equ $6F ; Start of string storage
HIMEM equ $73 ; Highest BASIC mem
PROGEND equ $AF ; End of BASIC prog
ONERR equ $D8 ; ONERR flag (0 = off)

COLDSTRT equ $E000 ; Cold start BASIC
FIXLINKS equ $D4F2 ; Fix up BASIC prog links
RUNPROG equ $D566 ; RUN Applesoft prog

* Mapping of hardware resources

dsend equ an1 ; Data 'send'
drecv equ pb1 ; Data 'receive'
zipslow equ dsk6off ; Zip Chip 'slow mode' for 51 ms.
 pag
* Page zero variables

lastidx equ $EB ; Last RCVPKT buffer index
ckbyte equ $EC ; Check byte
ptr equ $ED ; Data buffer pointer (0..leng-1)
address equ $FC ; Scratch addr of local data
length equ $FE ; Scratch length of local data

* Protocol constants

cyperms equ 1020 ; Cycles per ms. (really 1020.4)

arbtime equ 1 ; Min arbitration time (ms)
]cy equ arbtime*cyperms ; Arbtime in cycles
]cpx equ 11 ; Cycles per X iteration
arbx equ ]cy/]cpx ; X iterations

]servpad equ ]cy/4 ; Gap margin
servegap equ ]cy-]servpad/13 ; SERVER wait loop 13 cyc.

]cy equ ]cpx*256 ; Max arb time (cycles)
maxarb equ ]cy+cyperms/cyperms ; ceiling(max arb) (ms)

idletime equ 20 ; Idle polling timeout (ms)
   ; (stay under 51ms for Zip Chip)
reqdur equ 6 ; Typical req duration (ms)
reqpidle equ idletime/reqdur ; Requests per idletime

]cy equ idletime*cyperms ; Timeout in cycles
]cpx equ 11 ; Cycles per X iteration
]cpy equ ]cpx*256+4 ; Cycles per Y iteration
idleto equ ]cy/]cpy+1 ; Number of Y iterations

reqto equ 1 ; Timeout within protocol is
   ;  minimum arbitration time.
maxgap equ 87 ; Max intra-pkt gap (cycles)
gapwait equ maxgap/13+1 ; MONITOR wait loop is 13 cyc.

reqtime equ 3000 ; Req response timeout (ms)
rqperiod equ 20 ; Milliseconds between retrys
reqdelay equ rqperiod-3 ; ARB+SEND+RCV timeout = 3ms.

maxreqrt equ 3 ; Max # of xxxREQ retries
maxretry equ reqtime/rqperiod/maxreqrt ; # of re-sends
 pag
