         do    1-ROMboot  ; ('not ROMboot')
*--------------------------------------------------------*
*         Requester                     Server           *
*  ========================     =======================  *
*  PEEK   REQ (addr,leng)  ====>                         *
*                          <==== PEEK   ACK              *
*                          <==== Data (if >4 bytes)      *
*                            :                           *
*                          <==== Data                    *
*--------------------------------------------------------*
         pag
         fin              ; ('not ROMboot')
         do    master.crate
**********************************************************
*                                                        *
*                     P E E K R E Q                      *
*                                                        *
*             Michael J. Mahon - May 5, 1996             *
*                 Revised May 21, 2008                   *
*                                                        *
*               Copyright (c) 1996, 2008                 *
*                                                        *
*  Request machine 'sbuf+dst' to send 'sbuf+len' bytes   *
*  at its 'sbuf+adr', and put them at location 'locaddr'.*
*                                                        *
*  PEEKREQ, like other requests, will retry the request  *
*  in case of error, up to 'maxreqrt' times.  If errors  *
*  persist, it will return with Carry set.               *
*                                                        *
*  PEEKREQ does the following steps:                     *
*     1. Make the PEEK request (and receive the ACK)     *
*     2. Receive 'sbuf+len' bytes of data into 'locaddr' *
*     3. Retry in case of error up to 'maxreqrt' times   *
*                                                        *
**********************************************************

PEEKREQ  lda   #maxreqrt  ; Set request retry
         sta   reqretry   ;  counter.
:retry   lda   #r_PEEK    ; Send PEEK request.
         jsr   REQUEST
         bcs   :failed
         jsr   lasl=>al   ; Set up address/length
         lda   length+1   ; If length
         bne   :long      ;  is >255 bytes, or
         ldy   length     ;    if length is
         beq   :done      ; (length = 0!)
         cpy   #5         ;      > 4 bytes,
         bcs   :long      ;   receive multiple pkts.
         dey              ; Move short response
:short   lda   rbuf+adr,y ;  to local data address.
         sta   (address),y
         dey
         bpl   :short
         rts              ; ...and return.

:long    jsr   RCVLONG    ; Receive multiple packets
         bcc   :done      ; No problem.
:failed  dec   reqretry   ; Dec request retry count
         bne   :retry     ; Try until OK or exhausted,
         sec              ;  then return with C set.
:done    rts
         pag
         fin              ; (master.crate)
         do    1-ROMboot
**********************************************************
*                                                        *
*                     P E E K S R V                      *
*                                                        *
*             Michael J. Mahon - May 5, 1996             *
*                  Revised May 21, 2008                  *
*                                                        *
*             Copyright (c) 1996, 2005, 2008             *
*                                                        *
*  Service machine 'rbuf+frm's request to send 'rbuf+len'*
*  bytes of data from our 'rbuf+adr'.                    *
*                                                        *
*  PEEKSRV does the following steps:                     *
*     1. Check 'rbuf+len' for a 1..4 byte request        *
*     2. Send the ACK packet (with data, if short)       *
*     3. If long, send multiple response packets         *
*                                                        *
**********************************************************

PEEKSRV  jsr   rarl=>al   ; Set address/length.
         lda   length+1   ; Check for long response
         bne   :long
         ldy   length     ; Check for < 5 bytes.
         beq   :nullreq   ; length = 0.
         cpy   #5
         bcs   :long      ; - No, longer.
         dey              ; - Yes, move response
:short   lda   (address),y ;   data into ACK packet.
         sta   sbuf+adr,y
         dey
         bpl   :short
:nullreq jmp   SENDACK    ; Send ACK with response.

:long    jsr   SENDACK    ; ACK the request.
         ldx   #140/5     ; Allow requester to receive.
         jmp   DSENDLNG   ; Send long response.
         pag
*--------------------------------------------------------*
*         Requester                     Server           *
*  ========================     =======================  *
*  PEEKINC REQ (addr,inc)  ====>                         *
*                          <==== PEEKINC ACK (oldval)    *
*--------------------------------------------------------*

         fin              ; ('not ROMboot')
         do    master.crate
**********************************************************
*                                                        *
*          P K I N C R E Q ,   P K P O K R E Q           *
*                                                        *
*            Michael J. Mahon - Nov 05, 2004             *
*                                                        *
*               Copyright (c) 2004, 2010                 *
*                                                        *
*  Request machine 'sbuf+dst' to return 2 bytes at its   *
*  'sbuf+adr', then increment that value by 'sbuf+len'   *
*  (PEEKINC), or set the value to 'sbuf+len' (PEEKPOKE). *
*  The returned, unchanged value is at 'rbuf+len'.       *
*                                                        *
*  These requests, like others, will retry the request   *
*  in case of error, up to 'maxreqrt' times.  If errors  *
*  persist, SIMPLREQ will return with Carry set.         *
*                                                        *
*  PEEKINC and PEEKPOKE do the following steps:          *
*     1. Make the request (and receive the ACK)          *
*     2. Retry in case of error up to 'maxreqrt' times   *
*                                                        *
**********************************************************

PKINCREQ lda   #r_PKINC   ; Send PEEKINC request
         bne   SIMPLREQ   ; (always)

PKPOKREQ lda   #r_PKPOK   ; Send PEEKPOKE request

SIMPLREQ sta   sbuf+rqmd  ; Save request type.
         lda   #maxreqrt  ; Set request retry
         sta   reqretry   ;  counter.
:retry   lda   sbuf+rqmd  ; Send request.
         jsr   REQUEST
         bcc   :done      ; Done if no error.
         dec   reqretry   ; Dec request retry count
         bne   :retry     ; Try until OK or exhausted,
         sec              ;  then return with C set.
:done    rts
         pag
         fin              ; (master.crate)
         do    1-ROMboot
**********************************************************
*                                                        *
*           P K I N C S R V ,   P K P O K S R V          *
*                                                        *
*             Michael J. Mahon - Nov 05, 2004            *
*                  Revised Apr 30, 2010                  *
*                                                        *
*                Copyright (c) 2004, 2008                *
*                                                        *
*  Service machine 'rbuf+frm's request to send 2 bytes   *
*  at our 'rbuf+adr', then increment value by 'rbuf+len' *
*  (PEEKINC) or store 'rbuf+len' as new value (PEEKPOKE).*
*                                                        *
*  The PEEKINC and PEEKPOKE requests are "network atomic"*
*  read-modify-write primitives for synchronization and  *
*  allocation operations.                                *
*                                                        *
*  PKINCSRV and PKPOKSRV do the following steps:         *
*     1. Save initial 2-byte value in ACK buffer         *
*     2. If PKINCSRV: Increment the value by 'rbuf+len'  *
*     3. If PKPOKSRV: Set the value to 'rbuf+len'.       *
*     4. Send the ACK packet with the initial value.     *
*                                                        *
**********************************************************

PKINCSRV lda   #$FF       ; Set mask to "increment"
         bne   pkxxxsrv   ;  and go do it.

PKPOKSRV lda   #0         ; Set mask to "move"
pkxxxsrv sta   ckbyte
         jsr   ra=>a      ; Set up data address
         ldy   #0
         clc
:movinc  lda   (address),y ; Get original value
         sta   sbuf+len,y ;   and save it for ACK.
         and   ckbyte     ; ($FF=inc, $00=move)
         adc   rbuf+len,y
         sta   (address),y ; Replace with new value.
         iny
         tya              ; Don't disturb carry.
         eor   #2         ; Done?
         bne   :movinc    ; -No, go again.
         jmp   SENDACK    ; -Yes, send ACK with value.
         pag
*--------------------------------------------------------*
*              POKE, RUN, and BRUN Protocol              *
*--------------------------------------------------------*
*         Requester                     Server           *
*  ========================     =======================  *
*  xxxx   REQ (addr,leng)  ====>                         *
*                          <==== POKE   ACK              *
*                    Data  ====>                         *
*                            :                           *
*                    Data  ====>                         *
*                          <==== POKE   DACK             *
*--------------------------------------------------------*
         pag
         fin   (1-ROMboot)
         do    master.crate
**********************************************************
*                                                        *
*     P O K E R E Q ,  R U N R E Q ,   B R U N R E Q     *
*                                                        *
*            Michael J. Mahon - May 11, 1996             *
*                  Revised Sep 25, 2008                  *
*                                                        *
*             Copyright (c) 1996, 2004, 2008             *
*                                                        *
*  Request machine 'sbuf+dst' to store 'sbuf+len' bytes  *
*  at its 'sbuf+adr', and send them from our location    *
*  'locaddr'.                                            *
*                                                        *
*  These requests, like others, will retry the request   *
*  in case of error, up to 'maxreqrt' times.  If errors  *
*  persist, it will return with Carry set.               *
*                                                        *
*  POKEREQ, RUNREQ, and BRUNREQ do the following steps:  *
*     1. Make the request (and receive the ACK)          *
*     2. Send 'sbuf+len' bytes of data from 'locaddr'    *
*     3. Receive DATA ACK response                       *
*     4. Retry in case of error up to 'maxreqrt' times   *
*                                                        *
**********************************************************

RUNREQ   lda   #r_RUN     ; Send RUN request.
         bne   setreq     ; (always)

BRUNREQ  lda   #r_BRUN    ; Send BRUN request.
         bne   setreq     ; (always)

POKEREQ  lda   #r_POKE    ; Send POKE request.
setreq   sta   sbuf+rqmd  ; Set request code
         ldx   #maxreqrt  ; Set request retry
         stx   reqretry   ;  counter.
:retry   lda   sbuf+rqmd  ; Recover request code
         jsr   REQUEST
         bcs   :failed
         jsr   lasl=>al   ; Set up address/length.
         jsr   SENDLONG   ; Send multiple packets.
         jsr   RCVDACK    ; Receive DATA ACK packet.
         bcc   :done      ; -OK, return.
:failed  dec   reqretry   ; Dec request retry count
         bne   :retry     ; Try until OK or exhausted,
         sec              ;  then return with C set.
:done    rts
         pag
         fin   (master.crate)
         do    1-ROMboot
**********************************************************
*                                                        *
*    P O K E S R V ,   R U N S R V ,   B R U N S R V     *
*                                                        *
*            Michael J. Mahon - May 11, 1996             *
*                  Revised Jan 24, 2008                  *
*                                                        *
*             Copyright (c) 1996, 2008, 2009             *
*                                                        *
*  Service machine 'rbuf+frm's request to poke 'rbuf+len'*
*  bytes of data to our 'rbuf+adr'.                      *
*                                                        *
*  If RUNSRV, initialize Applesoft and RUN the BASIC     *
*  program transferred.  (Address must be > $800.)       *
*                                                        *
*  If BRUNSRV, CALL the code transferred with (A,X) set  *
*  to the code's load address.                           *
*                                                        *
*  POKESRV, RUNSRV, and BRUNSRV do the following steps:  *
*     1. If RUNSRV: lock net, save CSW/KSW hooks, and    *
*        coldstart Applesoft.                            *
*     2. Send the ACK packet                             *
*     3. Receive multiple packets to 'rbuf+adr'          *
*     4. If data received OK, send DATA ACK packet       *
*     5. If BRUNSRV: Set (A,X) to address & JMP to code. *
*     6. If RUNSRV: Init Applesoft ptrs, fix up links,   *
*        restore CSW/KSW hooks, and RUN the program.     *
*                                                        *
**********************************************************

         do    1-mserve
savhooks equ   $2FC       ; Save hooks at end of page 2
sethooks dw    rts        ; For COLDSTRT and FIXLINKS
         dw    POKESRV    ;  use hooks to retain control.

RUNSRV   sta   dsend+1    ; Lock net for coldstart
         ldx   #3         ; Save and set CSW/KSW hooks
:saveset lda   CSW,x      ;  to <rts,POKESRV> to retain
         sta   savhooks,x ;   control after coldstart.
         lda   sethooks,x
         sta   CSW,x
         dex
         bpl   :saveset
         jmp   COLDSTRT   ;    BASIC coldstart.
         fin              ; (1-mserve)
BRUNSRV  equ   *
POKESRV  jsr   SENDACK    ; ACK the request.
         jsr   rarl=>al   ; Set up address/length.
         jsr   RCVLONG    ; Receive long data message.
         bcs   rts        ; Receive error.
         delay 40         ; Allow requester to receive.
         lda   #rm_DACK   ; Send DATA ACK
         jsr   SENDRSP    ;   packet.
         lda   rbuf+rqmd  ; Recover request
         cmp   #r_POKE+rm_REQ ; POKE?
         beq   :ok        ; -Yes, return.
         cmp   #r_BRUN+rm_REQ ; -No, BRUN?
         beq   docall     ; -Yes, do CALL.
         do    mserve
                          ; (always)
         else
         lda   nadapage   ; -No, RUN.  Set HIMEM to
         sta   HIMEM+1    ;   NadaNet load page.
         sta   FRETOP+1
         clc
         lda   rbuf+adr   ; Set PSTART to start
         sta   PSTART     ;  addr and VARTAB to
         adc   rbuf+len   ;   end of program.
         sta   VARTAB
         lda   rbuf+adr+1
         sta   PSTART+1
         adc   rbuf+len+1
         sta   VARTAB+1
         mov16 #:run      ;KSW ; Retain control after
         jmp   FIXLINKS   ;  fixing up prog links.
:run     ldx   #4         ; Restore CSW/KSW hooks.
:restore lda   savhooks-1,x
         sta   CSW-1,x
         dex
         bne   :restore
         txa              ; Set byte preceding
         sta   (TXTPTR,x) ;  program to zero,
         sta   ONERR      ;   clear ONERR flag, and
         jmp   RUNPROG    ; RUN the Applesoft prog.
         fin              ; (not mserve)

:ok      clc              ; Good return.
rts      rts              ; Return.
         pag
*--------------------------------------------------------*
*         Requester                     Server           *
*  ========================     =======================  *
*  BPOKE  REQ (addr,val)   ====>                         *
*                                 (Broadcast, No ACK)    *
*--------------------------------------------------------*

         fin   (1-ROMboot)
         do    master.crate
**********************************************************
*                                                        *
*                    B P O K E R E Q                     *
*                                                        *
*            Michael J. Mahon - Nov. 04, 2004            *
*                  Revised Aug 20, 2008                  *
*                                                        *
*                Copyright (c) 2004, 2008                *
*                                                        *
*  Broadcast request to all serving machines to store 2  *
*  bytes in 'sbuf+len' at address 'sbuf+adr'.            *
*                                                        *
*  BPOKE, unlike most requests, is broadcast, and so     *
*  is not acknowledged by any receiver.  To eliminate    *
*  the chance of collision, it holds the bus locked for  *
*  20ms after arbitration, then sends the request packet.*
*  This allows enough time for any colliding sender to   *
*  send its request and re-arbitrate while the bus is    *
*  locked, so that there is no contention when the BPOKE *
*  request is finally sent.                              *
*                                                        *
*  BPOKEREQ does the following steps:                    *
*     1. Broadcast arbitrate and lock the bus            *
*     2. Set up BPOKE request                            *
*     3. Send the BPOKE request packet.                  *
*                                                        *
**********************************************************

BPOKEREQ jsr   BCASTARB   ; Bcast arbitrate & lock bus
         lda   #r_BPOKE+rm_REQ ; Set up BPOKE request.
         sta   sbuf+rqmd
         jmp   SENDCTL    ; Send the request.
         pag
         fin   (master.crate)
         do    1-ROMboot
**********************************************************
*                                                        *
*                    B P O K E S R V                     *
*                                                        *
*            Michael J. Mahon - Nov 05, 2004             *
*                 Revised May 21, 2008                   *
*                                                        *
*               Copyright (c) 2004, 2008                 *
*                                                        *
*  Service machine 'rbuf+frm's request to poke 2 bytes   *
*  of data in 'rbuf+len' to our 'rbuf+adr'.              *
*                                                        *
*  BPOKESRV does the following:                          *
*     1. Move 'rbuf+len' to memory at 'rbuf+adr'.        *
*                                                        *
**********************************************************

BPOKESRV jsr   ra=>a      ; Set up pointer
         ldy   #1         ; and move 2 bytes.
:move    lda   rbuf+len,y
         sta   (address),y
         dey
         bpl   :move
         clc
         rts              ; All done.
         pag
*--------------------------------------------------------*
*         Requester                     Server           *
*  ========================     =======================  *
*  CALL   REQ (addr,A,X)   ====>                         *
*                          <==== CALL   ACK              *
*--------------------------------------------------------*

         fin   (1-ROMboot)
         do    master.crate
**********************************************************
*                                                        *
*                     C A L L R E Q                      *
*                                                        *
*            Michael J. Mahon - May 11, 1996             *
*                  Revised Apr 30, 2010                  *
*                                                        *
*            Copyright (c) 1996, 2004, 2010              *
*                                                        *
*  Request machine 'sbuf+dst' to call a subroutine at    *
*  address 'sbuf+adr' with parameters A = 'sbuf+len' and *
*  X = 'sbuf+len+1'.                                     *
*                                                        *
*  CALLREQ jumps to SIMPLREQ to retry the request in case*
*  of error, up to 'maxreqrt' times.  If errors persist, *
*  SIMPLREQ will return to the caller with Carry set.    *
*                                                        *
*  CALLREQ does the following steps:                     *
*     1. Make the CALL request (and receive the ACK)     *
*     2. Retry in case of error up to 'maxreqrt' times   *
*                                                        *
**********************************************************

CALLREQ  lda   #r_CALL    ; Send CALL request and
         jmp   SIMPLREQ   ;  receive ACK (or error).
         pag
         fin   (master.crate)
         do    1-ROMboot
**********************************************************
*                                                        *
*                     C A L L S R V                      *
*                                                        *
*            Michael J. Mahon - May 11, 1996             *
*                  Revised Sep 25, 2008                  *
*                                                        *
*             Copyright (c) 1996, 2004, 2008             *
*                                                        *
*  Service machine 'rbuf+frm's request to call a         *
*  subroutine at our 'rbuf+adr' with parameters          *
*  A = 'rbuf+len' and X = 'rbuf+len+1'.  Flags are set   *
*  according to the value of A.                          *
*                                                        *
*  Note that when the subroutine returns, it returns to  *
*  whoever called SERVER.                                *
*                                                        *
*  CALLSRV does the following steps:                     *
*     1. Send the ACK packet                             *
*     2. Load parameters from 'rbuf+len' into A and X    *
*     3. Call subroutine at 'rbuf+adr'                   *
*                                                        *
**********************************************************

CALLSRV  jsr   SENDACK    ; ACK the request.
docall   ldx   rbuf+len+1 ; Set X parameter
         lda   rbuf+len   ;  and A parameter, and
         jmp   (rbuf+adr) ; Jump to requested address.
         pag
         fin   (1-ROMboot)
         do    1-mserve
**********************************************************
*                                                        *
*                     R E Q U E S T                      *
*                                                        *
*            Michael J. Mahon - April 20, 2004           *
*                  Revised Aug 17, 2008                  *
*                                                        *
*             Copyright (c) 1996, 2004, 2008             *
*                                                        *
*  Handle request protocol for the request in A & 'sbuf'.*
*                                                        *
*  Retry the protocol for up to 'reqtime' ms. (up to     *
*  'retrylim' times).  If successful, return with valid  *
*  response in 'rbuf' and Carry clear.                   *
*                                                        *
*  If request timed out, return with Carry set and A=0.  *
*                                                        *
*  If NAK received, return with Carry set and A>0.       *
*                                                        *
*  REQUEST performs the following steps:                 *
*     1. Complete control pkt in 'sbuf' (request in A)   *
*     2. Arbitrate for the use of the bus                *
*     3. Send the request specified in 'sbuf'            *
*     4. Receive the control response into 'rbuf'        *
*     5. Check 'rbuf' for a valid, expected response     *
*     6. Retry steps 2 to 5 up to 'retrylim' times       *
*     7. When ACKed, NAKed, or timed-out, return         *
*                                                        *
**********************************************************

REQUEST  ora   #rm_REQ    ; Add REQ modifier and
         sta   sbuf+rqmd  ; Store request code.
         lda   retrylim   ; Init retry counter.
         sta   retrycnt
:retry   lda   retrycnt   ; Timed out?
         beq   :err       ; -Yes, return w/ C set, A=0
         dec   retrycnt   ; Dec retry counter.
         jsr   ARBTRATE   ; Arbitrate for & lock bus
         jsr   SENDCTL    ; Send request in 'sbuf'.
         jsr   RCVCTL     ; Receive response in 'rbuf'.
         bcc   :ok        ; -Clean packet received.
         dlyms reqdelay   ;  delay a few ms.
         jmp   :retry     ;    and try again...

:ok      lda   rbuf+dst   ; Message received, is
         cmp   self       ;  it for us?
         bne   :proterr   ; -No, error.
         lda   sbuf+dst   ; -Yes.  Is it from
         cmp   rbuf+frm   ;   our destination?
         bne   :proterr   ; -No.  Protocol error.
         lda   sbuf+rqmd  ; -Yes.  Is the
         and   #reqmask   ;   modifier field
         ora   #rm_ACK    ;    'ACK'?
         cmp   rbuf+rqmd  ;      as expected?
         beq   :good      ; -Yes, good response!
         and   #reqmask   ; -No, construct
         ora   #rm_NAK    ;   the 'NAK' value.
         cmp   rbuf+rqmd  ; Is it a NAK?
         beq   :nakexit   ; -Yes, return w/ C set, A=1
:proterr jsr   PROTERR    ; -No, count protocol errors.
         jmp   :retry     ;    and try again...

:good    clc              ; Signal good ACK
         rts              ;  and return.

:nakexit lda   #1         ; Signal NAK
:err     sec              ; Signal error
         rts              ;  and return.
         pag
         fin   (1-mserve)
         do    1-ROMboot
**********************************************************
*                                                        *
*                     R C V D A C K                      *
*                                                        *
*            Michael J. Mahon - Apr 19, 2004             *
*                  Revised Aug 17, 2008                  *
*                                                        *
*                Copyright (c) 2004, 2008                *
*                                                        *
*  Receive DATA ACK packet.  Require a good cksum,       *
*  addressed to us, response req = sent req.  If all OK, *
*  return with Carry clear, else with Carry set.         *
*                                                        *
**********************************************************

RCVDACK  jsr   RCVCTL     ; Receive response packet.
         bcs   :err       ; Cksum error or timeout.
:ok      lda   rbuf+dst   ; Is packet for us?
         cmp   self
         bne   :proterr   ; -No, protocol error.
         lda   rbuf+frm   ; Was it sent by receiver?
         cmp   sbuf+dst
         bne   :proterr   ; -No, protocol error.
         lda   sbuf+rqmd  ; Construct sent req
         and   #reqmask   ;  with the expected
         ora   #rm_DACK   ;   'DACK' modifier.
         cmp   rbuf+rqmd  ; Does it match?
         bne   :proterr   ; -No, protocol error.
         clc              ; -Yes, clear Carry
:return  rts              ;   and return.

:err     bne   :return    ; Cksum error return.
:proterr sec              ; Return with C set,
         jmp   PROTERR    ;  after counting error.
         pag
         fin   (1-ROMboot)
